package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“A complex type to represent the result of bulk driver action.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "failedDriverIds", 
    "notFoundDriverIds", 
    "successfulDriverIds"})
@JsonInclude(Include.NON_NULL)
public class BulkDriverActionResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("failedDriverIds")
    protected List<String> failedDriverIds;

    @JsonProperty("failedDriverIds@nextLink")
    protected String failedDriverIdsNextLink;

    @JsonProperty("notFoundDriverIds")
    protected List<String> notFoundDriverIds;

    @JsonProperty("notFoundDriverIds@nextLink")
    protected String notFoundDriverIdsNextLink;

    @JsonProperty("successfulDriverIds")
    protected List<String> successfulDriverIds;

    @JsonProperty("successfulDriverIds@nextLink")
    protected String successfulDriverIdsNextLink;

    protected BulkDriverActionResult() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.bulkDriverActionResult";
    }

    /**
     * <i>“List of driver Ids where the action is failed.”</i>
     * 
     * @return property failedDriverIds
     */
    @Property(name="failedDriverIds")
    @JsonIgnore
    public CollectionPage<String> getFailedDriverIds() {
        return new CollectionPage<String>(contextPath, String.class, this.failedDriverIds, Optional.ofNullable(failedDriverIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of driver Ids where the action is failed.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property failedDriverIds
     */
    @Property(name="failedDriverIds")
    @JsonIgnore
    public CollectionPage<String> getFailedDriverIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.failedDriverIds, Optional.ofNullable(failedDriverIdsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“List of driver Ids that are not found.”</i>
     * 
     * @return property notFoundDriverIds
     */
    @Property(name="notFoundDriverIds")
    @JsonIgnore
    public CollectionPage<String> getNotFoundDriverIds() {
        return new CollectionPage<String>(contextPath, String.class, this.notFoundDriverIds, Optional.ofNullable(notFoundDriverIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of driver Ids that are not found.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property notFoundDriverIds
     */
    @Property(name="notFoundDriverIds")
    @JsonIgnore
    public CollectionPage<String> getNotFoundDriverIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.notFoundDriverIds, Optional.ofNullable(notFoundDriverIdsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“List of driver Ids where the action is successful.”</i>
     * 
     * @return property successfulDriverIds
     */
    @Property(name="successfulDriverIds")
    @JsonIgnore
    public CollectionPage<String> getSuccessfulDriverIds() {
        return new CollectionPage<String>(contextPath, String.class, this.successfulDriverIds, Optional.ofNullable(successfulDriverIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of driver Ids where the action is successful.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property successfulDriverIds
     */
    @Property(name="successfulDriverIds")
    @JsonIgnore
    public CollectionPage<String> getSuccessfulDriverIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.successfulDriverIds, Optional.ofNullable(successfulDriverIdsNextLink), Collections.emptyList(), options);
    }

    public BulkDriverActionResult withUnmappedField(String name, Object value) {
        BulkDriverActionResult _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> failedDriverIds;
        private String failedDriverIdsNextLink;
        private List<String> notFoundDriverIds;
        private String notFoundDriverIdsNextLink;
        private List<String> successfulDriverIds;
        private String successfulDriverIdsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“List of driver Ids where the action is failed.”</i>
         * 
         * @param failedDriverIds
         *            value of {@code failedDriverIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder failedDriverIds(List<String> failedDriverIds) {
            this.failedDriverIds = failedDriverIds;
            this.changedFields = changedFields.add("failedDriverIds");
            return this;
        }

        /**
         * <i>“List of driver Ids where the action is failed.”</i>
         * 
         * @param failedDriverIds
         *            value of {@code failedDriverIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder failedDriverIds(String... failedDriverIds) {
            return failedDriverIds(Arrays.asList(failedDriverIds));
        }

        /**
         * <i>“List of driver Ids where the action is failed.”</i>
         * 
         * @param failedDriverIdsNextLink
         *            value of {@code failedDriverIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder failedDriverIdsNextLink(String failedDriverIdsNextLink) {
            this.failedDriverIdsNextLink = failedDriverIdsNextLink;
            this.changedFields = changedFields.add("failedDriverIds");
            return this;
        }

        /**
         * <i>“List of driver Ids that are not found.”</i>
         * 
         * @param notFoundDriverIds
         *            value of {@code notFoundDriverIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notFoundDriverIds(List<String> notFoundDriverIds) {
            this.notFoundDriverIds = notFoundDriverIds;
            this.changedFields = changedFields.add("notFoundDriverIds");
            return this;
        }

        /**
         * <i>“List of driver Ids that are not found.”</i>
         * 
         * @param notFoundDriverIds
         *            value of {@code notFoundDriverIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notFoundDriverIds(String... notFoundDriverIds) {
            return notFoundDriverIds(Arrays.asList(notFoundDriverIds));
        }

        /**
         * <i>“List of driver Ids that are not found.”</i>
         * 
         * @param notFoundDriverIdsNextLink
         *            value of {@code notFoundDriverIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notFoundDriverIdsNextLink(String notFoundDriverIdsNextLink) {
            this.notFoundDriverIdsNextLink = notFoundDriverIdsNextLink;
            this.changedFields = changedFields.add("notFoundDriverIds");
            return this;
        }

        /**
         * <i>“List of driver Ids where the action is successful.”</i>
         * 
         * @param successfulDriverIds
         *            value of {@code successfulDriverIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder successfulDriverIds(List<String> successfulDriverIds) {
            this.successfulDriverIds = successfulDriverIds;
            this.changedFields = changedFields.add("successfulDriverIds");
            return this;
        }

        /**
         * <i>“List of driver Ids where the action is successful.”</i>
         * 
         * @param successfulDriverIds
         *            value of {@code successfulDriverIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder successfulDriverIds(String... successfulDriverIds) {
            return successfulDriverIds(Arrays.asList(successfulDriverIds));
        }

        /**
         * <i>“List of driver Ids where the action is successful.”</i>
         * 
         * @param successfulDriverIdsNextLink
         *            value of {@code successfulDriverIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder successfulDriverIdsNextLink(String successfulDriverIdsNextLink) {
            this.successfulDriverIdsNextLink = successfulDriverIdsNextLink;
            this.changedFields = changedFields.add("successfulDriverIds");
            return this;
        }

        public BulkDriverActionResult build() {
            BulkDriverActionResult _x = new BulkDriverActionResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.bulkDriverActionResult";
            _x.failedDriverIds = failedDriverIds;
            _x.failedDriverIdsNextLink = failedDriverIdsNextLink;
            _x.notFoundDriverIds = notFoundDriverIds;
            _x.notFoundDriverIdsNextLink = notFoundDriverIdsNextLink;
            _x.successfulDriverIds = successfulDriverIds;
            _x.successfulDriverIdsNextLink = successfulDriverIdsNextLink;
            return _x;
        }
    }

    private BulkDriverActionResult _copy() {
        BulkDriverActionResult _x = new BulkDriverActionResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.failedDriverIds = failedDriverIds;
        _x.notFoundDriverIds = notFoundDriverIds;
        _x.successfulDriverIds = successfulDriverIds;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BulkDriverActionResult[");
        b.append("failedDriverIds=");
        b.append(this.failedDriverIds);
        b.append(", ");
        b.append("notFoundDriverIds=");
        b.append(this.notFoundDriverIds);
        b.append(", ");
        b.append("successfulDriverIds=");
        b.append(this.successfulDriverIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
