package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "isCaptionEnabled", 
    "spokenLanguage", 
    "translationLanguages"})
@JsonInclude(Include.NON_NULL)
public class BroadcastMeetingCaptionSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("isCaptionEnabled")
    protected Boolean isCaptionEnabled;

    @JsonProperty("spokenLanguage")
    protected String spokenLanguage;

    @JsonProperty("translationLanguages")
    protected List<String> translationLanguages;

    @JsonProperty("translationLanguages@nextLink")
    protected String translationLanguagesNextLink;

    protected BroadcastMeetingCaptionSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.broadcastMeetingCaptionSettings";
    }

    @Property(name="isCaptionEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsCaptionEnabled() {
        return Optional.ofNullable(isCaptionEnabled);
    }

    public BroadcastMeetingCaptionSettings withIsCaptionEnabled(Boolean isCaptionEnabled) {
        BroadcastMeetingCaptionSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.broadcastMeetingCaptionSettings");
        _x.isCaptionEnabled = isCaptionEnabled;
        return _x;
    }

    @Property(name="spokenLanguage")
    @JsonIgnore
    public Optional<String> getSpokenLanguage() {
        return Optional.ofNullable(spokenLanguage);
    }

    public BroadcastMeetingCaptionSettings withSpokenLanguage(String spokenLanguage) {
        BroadcastMeetingCaptionSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.broadcastMeetingCaptionSettings");
        _x.spokenLanguage = spokenLanguage;
        return _x;
    }

    @Property(name="translationLanguages")
    @JsonIgnore
    public CollectionPage<String> getTranslationLanguages() {
        return new CollectionPage<String>(contextPath, String.class, this.translationLanguages, Optional.ofNullable(translationLanguagesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="translationLanguages")
    @JsonIgnore
    public CollectionPage<String> getTranslationLanguages(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.translationLanguages, Optional.ofNullable(translationLanguagesNextLink), Collections.emptyList(), options);
    }

    public BroadcastMeetingCaptionSettings withUnmappedField(String name, Object value) {
        BroadcastMeetingCaptionSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isCaptionEnabled;
        private String spokenLanguage;
        private List<String> translationLanguages;
        private String translationLanguagesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder isCaptionEnabled(Boolean isCaptionEnabled) {
            this.isCaptionEnabled = isCaptionEnabled;
            this.changedFields = changedFields.add("isCaptionEnabled");
            return this;
        }

        public Builder spokenLanguage(String spokenLanguage) {
            this.spokenLanguage = spokenLanguage;
            this.changedFields = changedFields.add("spokenLanguage");
            return this;
        }

        public Builder translationLanguages(List<String> translationLanguages) {
            this.translationLanguages = translationLanguages;
            this.changedFields = changedFields.add("translationLanguages");
            return this;
        }

        public Builder translationLanguages(String... translationLanguages) {
            return translationLanguages(Arrays.asList(translationLanguages));
        }

        public Builder translationLanguagesNextLink(String translationLanguagesNextLink) {
            this.translationLanguagesNextLink = translationLanguagesNextLink;
            this.changedFields = changedFields.add("translationLanguages");
            return this;
        }

        public BroadcastMeetingCaptionSettings build() {
            BroadcastMeetingCaptionSettings _x = new BroadcastMeetingCaptionSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.broadcastMeetingCaptionSettings";
            _x.isCaptionEnabled = isCaptionEnabled;
            _x.spokenLanguage = spokenLanguage;
            _x.translationLanguages = translationLanguages;
            _x.translationLanguagesNextLink = translationLanguagesNextLink;
            return _x;
        }
    }

    private BroadcastMeetingCaptionSettings _copy() {
        BroadcastMeetingCaptionSettings _x = new BroadcastMeetingCaptionSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isCaptionEnabled = isCaptionEnabled;
        _x.spokenLanguage = spokenLanguage;
        _x.translationLanguages = translationLanguages;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BroadcastMeetingCaptionSettings[");
        b.append("isCaptionEnabled=");
        b.append(this.isCaptionEnabled);
        b.append(", ");
        b.append("spokenLanguage=");
        b.append(this.spokenLanguage);
        b.append(", ");
        b.append("translationLanguages=");
        b.append(this.translationLanguages);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
