package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "customerId", 
    "customQuestionAnswers", 
    "emailAddress", 
    "location", 
    "name", 
    "notes", 
    "phone", 
    "timeZone"})
@JsonInclude(Include.NON_NULL)
public class BookingCustomerInformation extends BookingCustomerInformationBase implements ODataType {

    @JsonProperty("customerId")
    protected String customerId;

    @JsonProperty("customQuestionAnswers")
    protected List<BookingQuestionAnswer> customQuestionAnswers;

    @JsonProperty("customQuestionAnswers@nextLink")
    protected String customQuestionAnswersNextLink;

    @JsonProperty("emailAddress")
    protected String emailAddress;

    @JsonProperty("location")
    protected Location location;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("notes")
    protected String notes;

    @JsonProperty("phone")
    protected String phone;

    @JsonProperty("timeZone")
    protected String timeZone;

    protected BookingCustomerInformation() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.bookingCustomerInformation";
    }

    @Property(name="customerId")
    @JsonIgnore
    public Optional<String> getCustomerId() {
        return Optional.ofNullable(customerId);
    }

    public BookingCustomerInformation withCustomerId(String customerId) {
        BookingCustomerInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingCustomerInformation");
        _x.customerId = customerId;
        return _x;
    }

    @Property(name="customQuestionAnswers")
    @JsonIgnore
    public CollectionPage<BookingQuestionAnswer> getCustomQuestionAnswers() {
        return new CollectionPage<BookingQuestionAnswer>(contextPath, BookingQuestionAnswer.class, this.customQuestionAnswers, Optional.ofNullable(customQuestionAnswersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="customQuestionAnswers")
    @JsonIgnore
    public CollectionPage<BookingQuestionAnswer> getCustomQuestionAnswers(HttpRequestOptions options) {
        return new CollectionPage<BookingQuestionAnswer>(contextPath, BookingQuestionAnswer.class, this.customQuestionAnswers, Optional.ofNullable(customQuestionAnswersNextLink), Collections.emptyList(), options);
    }

    @Property(name="emailAddress")
    @JsonIgnore
    public Optional<String> getEmailAddress() {
        return Optional.ofNullable(emailAddress);
    }

    public BookingCustomerInformation withEmailAddress(String emailAddress) {
        BookingCustomerInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingCustomerInformation");
        _x.emailAddress = emailAddress;
        return _x;
    }

    @Property(name="location")
    @JsonIgnore
    public Optional<Location> getLocation() {
        return Optional.ofNullable(location);
    }

    public BookingCustomerInformation withLocation(Location location) {
        BookingCustomerInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingCustomerInformation");
        _x.location = location;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public BookingCustomerInformation withName(String name) {
        BookingCustomerInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingCustomerInformation");
        _x.name = name;
        return _x;
    }

    @Property(name="notes")
    @JsonIgnore
    public Optional<String> getNotes() {
        return Optional.ofNullable(notes);
    }

    public BookingCustomerInformation withNotes(String notes) {
        BookingCustomerInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingCustomerInformation");
        _x.notes = notes;
        return _x;
    }

    @Property(name="phone")
    @JsonIgnore
    public Optional<String> getPhone() {
        return Optional.ofNullable(phone);
    }

    public BookingCustomerInformation withPhone(String phone) {
        BookingCustomerInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingCustomerInformation");
        _x.phone = phone;
        return _x;
    }

    @Property(name="timeZone")
    @JsonIgnore
    public Optional<String> getTimeZone() {
        return Optional.ofNullable(timeZone);
    }

    public BookingCustomerInformation withTimeZone(String timeZone) {
        BookingCustomerInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingCustomerInformation");
        _x.timeZone = timeZone;
        return _x;
    }

    public BookingCustomerInformation withUnmappedField(String name, Object value) {
        BookingCustomerInformation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderBookingCustomerInformation() {
        return new Builder();
    }

    public static final class Builder {
        private String customerId;
        private List<BookingQuestionAnswer> customQuestionAnswers;
        private String customQuestionAnswersNextLink;
        private String emailAddress;
        private Location location;
        private String name;
        private String notes;
        private String phone;
        private String timeZone;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder customerId(String customerId) {
            this.customerId = customerId;
            this.changedFields = changedFields.add("customerId");
            return this;
        }

        public Builder customQuestionAnswers(List<BookingQuestionAnswer> customQuestionAnswers) {
            this.customQuestionAnswers = customQuestionAnswers;
            this.changedFields = changedFields.add("customQuestionAnswers");
            return this;
        }

        public Builder customQuestionAnswers(BookingQuestionAnswer... customQuestionAnswers) {
            return customQuestionAnswers(Arrays.asList(customQuestionAnswers));
        }

        public Builder customQuestionAnswersNextLink(String customQuestionAnswersNextLink) {
            this.customQuestionAnswersNextLink = customQuestionAnswersNextLink;
            this.changedFields = changedFields.add("customQuestionAnswers");
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            this.changedFields = changedFields.add("emailAddress");
            return this;
        }

        public Builder location(Location location) {
            this.location = location;
            this.changedFields = changedFields.add("location");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder phone(String phone) {
            this.phone = phone;
            this.changedFields = changedFields.add("phone");
            return this;
        }

        public Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            this.changedFields = changedFields.add("timeZone");
            return this;
        }

        public BookingCustomerInformation build() {
            BookingCustomerInformation _x = new BookingCustomerInformation();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.bookingCustomerInformation";
            _x.customerId = customerId;
            _x.customQuestionAnswers = customQuestionAnswers;
            _x.customQuestionAnswersNextLink = customQuestionAnswersNextLink;
            _x.emailAddress = emailAddress;
            _x.location = location;
            _x.name = name;
            _x.notes = notes;
            _x.phone = phone;
            _x.timeZone = timeZone;
            return _x;
        }
    }

    private BookingCustomerInformation _copy() {
        BookingCustomerInformation _x = new BookingCustomerInformation();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.customerId = customerId;
        _x.customQuestionAnswers = customQuestionAnswers;
        _x.emailAddress = emailAddress;
        _x.location = location;
        _x.name = name;
        _x.notes = notes;
        _x.phone = phone;
        _x.timeZone = timeZone;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BookingCustomerInformation[");
        b.append("customerId=");
        b.append(this.customerId);
        b.append(", ");
        b.append("customQuestionAnswers=");
        b.append(this.customQuestionAnswers);
        b.append(", ");
        b.append("emailAddress=");
        b.append(this.emailAddress);
        b.append(", ");
        b.append("location=");
        b.append(this.location);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("phone=");
        b.append(this.phone);
        b.append(", ");
        b.append("timeZone=");
        b.append(this.timeZone);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
