package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.BitLockerEncryptionMethod;
import odata.msgraph.client.beta.enums.ConfigurationUsage;


/**
 * <i>“BitLocker Encryption Base Policies.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "encryptionMethod", 
    "minimumPinLength", 
    "prebootRecoveryEnableMessageAndUrl", 
    "prebootRecoveryMessage", 
    "prebootRecoveryUrl", 
    "recoveryOptions", 
    "startupAuthenticationBlockWithoutTpmChip", 
    "startupAuthenticationRequired", 
    "startupAuthenticationTpmKeyUsage", 
    "startupAuthenticationTpmPinAndKeyUsage", 
    "startupAuthenticationTpmPinUsage", 
    "startupAuthenticationTpmUsage"})
@JsonInclude(Include.NON_NULL)
public class BitLockerSystemDrivePolicy implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("encryptionMethod")
    protected BitLockerEncryptionMethod encryptionMethod;

    @JsonProperty("minimumPinLength")
    protected Integer minimumPinLength;

    @JsonProperty("prebootRecoveryEnableMessageAndUrl")
    protected Boolean prebootRecoveryEnableMessageAndUrl;

    @JsonProperty("prebootRecoveryMessage")
    protected String prebootRecoveryMessage;

    @JsonProperty("prebootRecoveryUrl")
    protected String prebootRecoveryUrl;

    @JsonProperty("recoveryOptions")
    protected BitLockerRecoveryOptions recoveryOptions;

    @JsonProperty("startupAuthenticationBlockWithoutTpmChip")
    protected Boolean startupAuthenticationBlockWithoutTpmChip;

    @JsonProperty("startupAuthenticationRequired")
    protected Boolean startupAuthenticationRequired;

    @JsonProperty("startupAuthenticationTpmKeyUsage")
    protected ConfigurationUsage startupAuthenticationTpmKeyUsage;

    @JsonProperty("startupAuthenticationTpmPinAndKeyUsage")
    protected ConfigurationUsage startupAuthenticationTpmPinAndKeyUsage;

    @JsonProperty("startupAuthenticationTpmPinUsage")
    protected ConfigurationUsage startupAuthenticationTpmPinUsage;

    @JsonProperty("startupAuthenticationTpmUsage")
    protected ConfigurationUsage startupAuthenticationTpmUsage;

    protected BitLockerSystemDrivePolicy() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.bitLockerSystemDrivePolicy";
    }

    /**
     * <i>“Select the encryption method for operating system drives.”</i>
     * 
     * @return property encryptionMethod
     */
    @Property(name="encryptionMethod")
    @JsonIgnore
    public Optional<BitLockerEncryptionMethod> getEncryptionMethod() {
        return Optional.ofNullable(encryptionMethod);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code encryptionMethod}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Select the encryption method for operating system drives.”</i>
     * 
     * @param encryptionMethod
     *            new value of {@code encryptionMethod} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code encryptionMethod} field changed
     */
    public BitLockerSystemDrivePolicy withEncryptionMethod(BitLockerEncryptionMethod encryptionMethod) {
        BitLockerSystemDrivePolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bitLockerSystemDrivePolicy");
        _x.encryptionMethod = encryptionMethod;
        return _x;
    }

    /**
     * <i>“Indicates the minimum length of startup pin. Valid values 4 to 20”</i>
     * 
     * @return property minimumPinLength
     */
    @Property(name="minimumPinLength")
    @JsonIgnore
    public Optional<Integer> getMinimumPinLength() {
        return Optional.ofNullable(minimumPinLength);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code minimumPinLength}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates the minimum length of startup pin. Valid values 4 to 20”</i>
     * 
     * @param minimumPinLength
     *            new value of {@code minimumPinLength} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumPinLength} field changed
     */
    public BitLockerSystemDrivePolicy withMinimumPinLength(Integer minimumPinLength) {
        BitLockerSystemDrivePolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bitLockerSystemDrivePolicy");
        _x.minimumPinLength = minimumPinLength;
        return _x;
    }

    /**
     * <i>“Enable pre-boot recovery message and Url. If requireStartupAuthentication is
     * false, this value does not affect.”</i>
     * 
     * @return property prebootRecoveryEnableMessageAndUrl
     */
    @Property(name="prebootRecoveryEnableMessageAndUrl")
    @JsonIgnore
    public Optional<Boolean> getPrebootRecoveryEnableMessageAndUrl() {
        return Optional.ofNullable(prebootRecoveryEnableMessageAndUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * prebootRecoveryEnableMessageAndUrl} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Enable pre-boot recovery message and Url. If requireStartupAuthentication is
     * false, this value does not affect.”</i>
     * 
     * @param prebootRecoveryEnableMessageAndUrl
     *            new value of {@code prebootRecoveryEnableMessageAndUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code prebootRecoveryEnableMessageAndUrl} field changed
     */
    public BitLockerSystemDrivePolicy withPrebootRecoveryEnableMessageAndUrl(Boolean prebootRecoveryEnableMessageAndUrl) {
        BitLockerSystemDrivePolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bitLockerSystemDrivePolicy");
        _x.prebootRecoveryEnableMessageAndUrl = prebootRecoveryEnableMessageAndUrl;
        return _x;
    }

    /**
     * <i>“Defines a custom recovery message.”</i>
     * 
     * @return property prebootRecoveryMessage
     */
    @Property(name="prebootRecoveryMessage")
    @JsonIgnore
    public Optional<String> getPrebootRecoveryMessage() {
        return Optional.ofNullable(prebootRecoveryMessage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * prebootRecoveryMessage} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Defines a custom recovery message.”</i>
     * 
     * @param prebootRecoveryMessage
     *            new value of {@code prebootRecoveryMessage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code prebootRecoveryMessage} field changed
     */
    public BitLockerSystemDrivePolicy withPrebootRecoveryMessage(String prebootRecoveryMessage) {
        BitLockerSystemDrivePolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bitLockerSystemDrivePolicy");
        _x.prebootRecoveryMessage = prebootRecoveryMessage;
        return _x;
    }

    /**
     * <i>“Defines a custom recovery URL.”</i>
     * 
     * @return property prebootRecoveryUrl
     */
    @Property(name="prebootRecoveryUrl")
    @JsonIgnore
    public Optional<String> getPrebootRecoveryUrl() {
        return Optional.ofNullable(prebootRecoveryUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * prebootRecoveryUrl} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Defines a custom recovery URL.”</i>
     * 
     * @param prebootRecoveryUrl
     *            new value of {@code prebootRecoveryUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code prebootRecoveryUrl} field changed
     */
    public BitLockerSystemDrivePolicy withPrebootRecoveryUrl(String prebootRecoveryUrl) {
        BitLockerSystemDrivePolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bitLockerSystemDrivePolicy");
        _x.prebootRecoveryUrl = prebootRecoveryUrl;
        return _x;
    }

    /**
     * <i>“Allows to recover BitLocker encrypted operating system drives in the absence of
     * the required startup key information. This policy setting is applied when you
     * turn on BitLocker.”</i>
     * 
     * @return property recoveryOptions
     */
    @Property(name="recoveryOptions")
    @JsonIgnore
    public Optional<BitLockerRecoveryOptions> getRecoveryOptions() {
        return Optional.ofNullable(recoveryOptions);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code recoveryOptions}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Allows to recover BitLocker encrypted operating system drives in the absence of
     * the required startup key information. This policy setting is applied when you
     * turn on BitLocker.”</i>
     * 
     * @param recoveryOptions
     *            new value of {@code recoveryOptions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code recoveryOptions} field changed
     */
    public BitLockerSystemDrivePolicy withRecoveryOptions(BitLockerRecoveryOptions recoveryOptions) {
        BitLockerSystemDrivePolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bitLockerSystemDrivePolicy");
        _x.recoveryOptions = recoveryOptions;
        return _x;
    }

    /**
     * <i>“Indicates whether to allow BitLocker without a compatible TPM (requires a
     * password or a startup key on a USB flash drive).”</i>
     * 
     * @return property startupAuthenticationBlockWithoutTpmChip
     */
    @Property(name="startupAuthenticationBlockWithoutTpmChip")
    @JsonIgnore
    public Optional<Boolean> getStartupAuthenticationBlockWithoutTpmChip() {
        return Optional.ofNullable(startupAuthenticationBlockWithoutTpmChip);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startupAuthenticationBlockWithoutTpmChip} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether to allow BitLocker without a compatible TPM (requires a
     * password or a startup key on a USB flash drive).”</i>
     * 
     * @param startupAuthenticationBlockWithoutTpmChip
     *            new value of {@code startupAuthenticationBlockWithoutTpmChip} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startupAuthenticationBlockWithoutTpmChip} field changed
     */
    public BitLockerSystemDrivePolicy withStartupAuthenticationBlockWithoutTpmChip(Boolean startupAuthenticationBlockWithoutTpmChip) {
        BitLockerSystemDrivePolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bitLockerSystemDrivePolicy");
        _x.startupAuthenticationBlockWithoutTpmChip = startupAuthenticationBlockWithoutTpmChip;
        return _x;
    }

    /**
     * <i>“Require additional authentication at startup.”</i>
     * 
     * @return property startupAuthenticationRequired
     */
    @Property(name="startupAuthenticationRequired")
    @JsonIgnore
    public Optional<Boolean> getStartupAuthenticationRequired() {
        return Optional.ofNullable(startupAuthenticationRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startupAuthenticationRequired} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Require additional authentication at startup.”</i>
     * 
     * @param startupAuthenticationRequired
     *            new value of {@code startupAuthenticationRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startupAuthenticationRequired} field changed
     */
    public BitLockerSystemDrivePolicy withStartupAuthenticationRequired(Boolean startupAuthenticationRequired) {
        BitLockerSystemDrivePolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bitLockerSystemDrivePolicy");
        _x.startupAuthenticationRequired = startupAuthenticationRequired;
        return _x;
    }

    /**
     * <i>“Indicates if TPM startup key is allowed/required/disallowed.”</i>
     * 
     * @return property startupAuthenticationTpmKeyUsage
     */
    @Property(name="startupAuthenticationTpmKeyUsage")
    @JsonIgnore
    public Optional<ConfigurationUsage> getStartupAuthenticationTpmKeyUsage() {
        return Optional.ofNullable(startupAuthenticationTpmKeyUsage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startupAuthenticationTpmKeyUsage} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates if TPM startup key is allowed/required/disallowed.”</i>
     * 
     * @param startupAuthenticationTpmKeyUsage
     *            new value of {@code startupAuthenticationTpmKeyUsage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startupAuthenticationTpmKeyUsage} field changed
     */
    public BitLockerSystemDrivePolicy withStartupAuthenticationTpmKeyUsage(ConfigurationUsage startupAuthenticationTpmKeyUsage) {
        BitLockerSystemDrivePolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bitLockerSystemDrivePolicy");
        _x.startupAuthenticationTpmKeyUsage = startupAuthenticationTpmKeyUsage;
        return _x;
    }

    /**
     * <i>“Indicates if TPM startup pin key and key are allowed/required/disallowed.”</i>
     * 
     * @return property startupAuthenticationTpmPinAndKeyUsage
     */
    @Property(name="startupAuthenticationTpmPinAndKeyUsage")
    @JsonIgnore
    public Optional<ConfigurationUsage> getStartupAuthenticationTpmPinAndKeyUsage() {
        return Optional.ofNullable(startupAuthenticationTpmPinAndKeyUsage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startupAuthenticationTpmPinAndKeyUsage} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates if TPM startup pin key and key are allowed/required/disallowed.”</i>
     * 
     * @param startupAuthenticationTpmPinAndKeyUsage
     *            new value of {@code startupAuthenticationTpmPinAndKeyUsage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startupAuthenticationTpmPinAndKeyUsage} field changed
     */
    public BitLockerSystemDrivePolicy withStartupAuthenticationTpmPinAndKeyUsage(ConfigurationUsage startupAuthenticationTpmPinAndKeyUsage) {
        BitLockerSystemDrivePolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bitLockerSystemDrivePolicy");
        _x.startupAuthenticationTpmPinAndKeyUsage = startupAuthenticationTpmPinAndKeyUsage;
        return _x;
    }

    /**
     * <i>“Indicates if TPM startup pin is allowed/required/disallowed.”</i>
     * 
     * @return property startupAuthenticationTpmPinUsage
     */
    @Property(name="startupAuthenticationTpmPinUsage")
    @JsonIgnore
    public Optional<ConfigurationUsage> getStartupAuthenticationTpmPinUsage() {
        return Optional.ofNullable(startupAuthenticationTpmPinUsage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startupAuthenticationTpmPinUsage} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates if TPM startup pin is allowed/required/disallowed.”</i>
     * 
     * @param startupAuthenticationTpmPinUsage
     *            new value of {@code startupAuthenticationTpmPinUsage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startupAuthenticationTpmPinUsage} field changed
     */
    public BitLockerSystemDrivePolicy withStartupAuthenticationTpmPinUsage(ConfigurationUsage startupAuthenticationTpmPinUsage) {
        BitLockerSystemDrivePolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bitLockerSystemDrivePolicy");
        _x.startupAuthenticationTpmPinUsage = startupAuthenticationTpmPinUsage;
        return _x;
    }

    /**
     * <i>“Indicates if TPM startup is allowed/required/disallowed.”</i>
     * 
     * @return property startupAuthenticationTpmUsage
     */
    @Property(name="startupAuthenticationTpmUsage")
    @JsonIgnore
    public Optional<ConfigurationUsage> getStartupAuthenticationTpmUsage() {
        return Optional.ofNullable(startupAuthenticationTpmUsage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startupAuthenticationTpmUsage} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates if TPM startup is allowed/required/disallowed.”</i>
     * 
     * @param startupAuthenticationTpmUsage
     *            new value of {@code startupAuthenticationTpmUsage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startupAuthenticationTpmUsage} field changed
     */
    public BitLockerSystemDrivePolicy withStartupAuthenticationTpmUsage(ConfigurationUsage startupAuthenticationTpmUsage) {
        BitLockerSystemDrivePolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bitLockerSystemDrivePolicy");
        _x.startupAuthenticationTpmUsage = startupAuthenticationTpmUsage;
        return _x;
    }

    public BitLockerSystemDrivePolicy withUnmappedField(String name, Object value) {
        BitLockerSystemDrivePolicy _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private BitLockerEncryptionMethod encryptionMethod;
        private Integer minimumPinLength;
        private Boolean prebootRecoveryEnableMessageAndUrl;
        private String prebootRecoveryMessage;
        private String prebootRecoveryUrl;
        private BitLockerRecoveryOptions recoveryOptions;
        private Boolean startupAuthenticationBlockWithoutTpmChip;
        private Boolean startupAuthenticationRequired;
        private ConfigurationUsage startupAuthenticationTpmKeyUsage;
        private ConfigurationUsage startupAuthenticationTpmPinAndKeyUsage;
        private ConfigurationUsage startupAuthenticationTpmPinUsage;
        private ConfigurationUsage startupAuthenticationTpmUsage;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Select the encryption method for operating system drives.”</i>
         * 
         * @param encryptionMethod
         *            value of {@code encryptionMethod} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder encryptionMethod(BitLockerEncryptionMethod encryptionMethod) {
            this.encryptionMethod = encryptionMethod;
            this.changedFields = changedFields.add("encryptionMethod");
            return this;
        }

        /**
         * <i>“Indicates the minimum length of startup pin. Valid values 4 to 20”</i>
         * 
         * @param minimumPinLength
         *            value of {@code minimumPinLength} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumPinLength(Integer minimumPinLength) {
            this.minimumPinLength = minimumPinLength;
            this.changedFields = changedFields.add("minimumPinLength");
            return this;
        }

        /**
         * <i>“Enable pre-boot recovery message and Url. If requireStartupAuthentication is
         * false, this value does not affect.”</i>
         * 
         * @param prebootRecoveryEnableMessageAndUrl
         *            value of {@code prebootRecoveryEnableMessageAndUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder prebootRecoveryEnableMessageAndUrl(Boolean prebootRecoveryEnableMessageAndUrl) {
            this.prebootRecoveryEnableMessageAndUrl = prebootRecoveryEnableMessageAndUrl;
            this.changedFields = changedFields.add("prebootRecoveryEnableMessageAndUrl");
            return this;
        }

        /**
         * <i>“Defines a custom recovery message.”</i>
         * 
         * @param prebootRecoveryMessage
         *            value of {@code prebootRecoveryMessage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder prebootRecoveryMessage(String prebootRecoveryMessage) {
            this.prebootRecoveryMessage = prebootRecoveryMessage;
            this.changedFields = changedFields.add("prebootRecoveryMessage");
            return this;
        }

        /**
         * <i>“Defines a custom recovery URL.”</i>
         * 
         * @param prebootRecoveryUrl
         *            value of {@code prebootRecoveryUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder prebootRecoveryUrl(String prebootRecoveryUrl) {
            this.prebootRecoveryUrl = prebootRecoveryUrl;
            this.changedFields = changedFields.add("prebootRecoveryUrl");
            return this;
        }

        /**
         * <i>“Allows to recover BitLocker encrypted operating system drives in the absence of
         * the required startup key information. This policy setting is applied when you
         * turn on BitLocker.”</i>
         * 
         * @param recoveryOptions
         *            value of {@code recoveryOptions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder recoveryOptions(BitLockerRecoveryOptions recoveryOptions) {
            this.recoveryOptions = recoveryOptions;
            this.changedFields = changedFields.add("recoveryOptions");
            return this;
        }

        /**
         * <i>“Indicates whether to allow BitLocker without a compatible TPM (requires a
         * password or a startup key on a USB flash drive).”</i>
         * 
         * @param startupAuthenticationBlockWithoutTpmChip
         *            value of {@code startupAuthenticationBlockWithoutTpmChip} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startupAuthenticationBlockWithoutTpmChip(Boolean startupAuthenticationBlockWithoutTpmChip) {
            this.startupAuthenticationBlockWithoutTpmChip = startupAuthenticationBlockWithoutTpmChip;
            this.changedFields = changedFields.add("startupAuthenticationBlockWithoutTpmChip");
            return this;
        }

        /**
         * <i>“Require additional authentication at startup.”</i>
         * 
         * @param startupAuthenticationRequired
         *            value of {@code startupAuthenticationRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startupAuthenticationRequired(Boolean startupAuthenticationRequired) {
            this.startupAuthenticationRequired = startupAuthenticationRequired;
            this.changedFields = changedFields.add("startupAuthenticationRequired");
            return this;
        }

        /**
         * <i>“Indicates if TPM startup key is allowed/required/disallowed.”</i>
         * 
         * @param startupAuthenticationTpmKeyUsage
         *            value of {@code startupAuthenticationTpmKeyUsage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startupAuthenticationTpmKeyUsage(ConfigurationUsage startupAuthenticationTpmKeyUsage) {
            this.startupAuthenticationTpmKeyUsage = startupAuthenticationTpmKeyUsage;
            this.changedFields = changedFields.add("startupAuthenticationTpmKeyUsage");
            return this;
        }

        /**
         * <i>“Indicates if TPM startup pin key and key are allowed/required/disallowed.”</i>
         * 
         * @param startupAuthenticationTpmPinAndKeyUsage
         *            value of {@code startupAuthenticationTpmPinAndKeyUsage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startupAuthenticationTpmPinAndKeyUsage(ConfigurationUsage startupAuthenticationTpmPinAndKeyUsage) {
            this.startupAuthenticationTpmPinAndKeyUsage = startupAuthenticationTpmPinAndKeyUsage;
            this.changedFields = changedFields.add("startupAuthenticationTpmPinAndKeyUsage");
            return this;
        }

        /**
         * <i>“Indicates if TPM startup pin is allowed/required/disallowed.”</i>
         * 
         * @param startupAuthenticationTpmPinUsage
         *            value of {@code startupAuthenticationTpmPinUsage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startupAuthenticationTpmPinUsage(ConfigurationUsage startupAuthenticationTpmPinUsage) {
            this.startupAuthenticationTpmPinUsage = startupAuthenticationTpmPinUsage;
            this.changedFields = changedFields.add("startupAuthenticationTpmPinUsage");
            return this;
        }

        /**
         * <i>“Indicates if TPM startup is allowed/required/disallowed.”</i>
         * 
         * @param startupAuthenticationTpmUsage
         *            value of {@code startupAuthenticationTpmUsage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startupAuthenticationTpmUsage(ConfigurationUsage startupAuthenticationTpmUsage) {
            this.startupAuthenticationTpmUsage = startupAuthenticationTpmUsage;
            this.changedFields = changedFields.add("startupAuthenticationTpmUsage");
            return this;
        }

        public BitLockerSystemDrivePolicy build() {
            BitLockerSystemDrivePolicy _x = new BitLockerSystemDrivePolicy();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.bitLockerSystemDrivePolicy";
            _x.encryptionMethod = encryptionMethod;
            _x.minimumPinLength = minimumPinLength;
            _x.prebootRecoveryEnableMessageAndUrl = prebootRecoveryEnableMessageAndUrl;
            _x.prebootRecoveryMessage = prebootRecoveryMessage;
            _x.prebootRecoveryUrl = prebootRecoveryUrl;
            _x.recoveryOptions = recoveryOptions;
            _x.startupAuthenticationBlockWithoutTpmChip = startupAuthenticationBlockWithoutTpmChip;
            _x.startupAuthenticationRequired = startupAuthenticationRequired;
            _x.startupAuthenticationTpmKeyUsage = startupAuthenticationTpmKeyUsage;
            _x.startupAuthenticationTpmPinAndKeyUsage = startupAuthenticationTpmPinAndKeyUsage;
            _x.startupAuthenticationTpmPinUsage = startupAuthenticationTpmPinUsage;
            _x.startupAuthenticationTpmUsage = startupAuthenticationTpmUsage;
            return _x;
        }
    }

    private BitLockerSystemDrivePolicy _copy() {
        BitLockerSystemDrivePolicy _x = new BitLockerSystemDrivePolicy();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.encryptionMethod = encryptionMethod;
        _x.minimumPinLength = minimumPinLength;
        _x.prebootRecoveryEnableMessageAndUrl = prebootRecoveryEnableMessageAndUrl;
        _x.prebootRecoveryMessage = prebootRecoveryMessage;
        _x.prebootRecoveryUrl = prebootRecoveryUrl;
        _x.recoveryOptions = recoveryOptions;
        _x.startupAuthenticationBlockWithoutTpmChip = startupAuthenticationBlockWithoutTpmChip;
        _x.startupAuthenticationRequired = startupAuthenticationRequired;
        _x.startupAuthenticationTpmKeyUsage = startupAuthenticationTpmKeyUsage;
        _x.startupAuthenticationTpmPinAndKeyUsage = startupAuthenticationTpmPinAndKeyUsage;
        _x.startupAuthenticationTpmPinUsage = startupAuthenticationTpmPinUsage;
        _x.startupAuthenticationTpmUsage = startupAuthenticationTpmUsage;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BitLockerSystemDrivePolicy[");
        b.append("encryptionMethod=");
        b.append(this.encryptionMethod);
        b.append(", ");
        b.append("minimumPinLength=");
        b.append(this.minimumPinLength);
        b.append(", ");
        b.append("prebootRecoveryEnableMessageAndUrl=");
        b.append(this.prebootRecoveryEnableMessageAndUrl);
        b.append(", ");
        b.append("prebootRecoveryMessage=");
        b.append(this.prebootRecoveryMessage);
        b.append(", ");
        b.append("prebootRecoveryUrl=");
        b.append(this.prebootRecoveryUrl);
        b.append(", ");
        b.append("recoveryOptions=");
        b.append(this.recoveryOptions);
        b.append(", ");
        b.append("startupAuthenticationBlockWithoutTpmChip=");
        b.append(this.startupAuthenticationBlockWithoutTpmChip);
        b.append(", ");
        b.append("startupAuthenticationRequired=");
        b.append(this.startupAuthenticationRequired);
        b.append(", ");
        b.append("startupAuthenticationTpmKeyUsage=");
        b.append(this.startupAuthenticationTpmKeyUsage);
        b.append(", ");
        b.append("startupAuthenticationTpmPinAndKeyUsage=");
        b.append(this.startupAuthenticationTpmPinAndKeyUsage);
        b.append(", ");
        b.append("startupAuthenticationTpmPinUsage=");
        b.append(this.startupAuthenticationTpmPinUsage);
        b.append(", ");
        b.append("startupAuthenticationTpmUsage=");
        b.append(this.startupAuthenticationTpmUsage);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
