package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Double;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "averageScore", 
    "basis"})
@JsonInclude(Include.NON_NULL)
public class AverageComparativeScore implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("averageScore")
    protected Double averageScore;

    @JsonProperty("basis")
    protected String basis;

    protected AverageComparativeScore() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.averageComparativeScore";
    }

    @Property(name="averageScore")
    @JsonIgnore
    public Optional<Double> getAverageScore() {
        return Optional.ofNullable(averageScore);
    }

    public AverageComparativeScore withAverageScore(Double averageScore) {
        AverageComparativeScore _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.averageComparativeScore");
        _x.averageScore = averageScore;
        return _x;
    }

    @Property(name="basis")
    @JsonIgnore
    public Optional<String> getBasis() {
        return Optional.ofNullable(basis);
    }

    public AverageComparativeScore withBasis(String basis) {
        AverageComparativeScore _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.averageComparativeScore");
        _x.basis = basis;
        return _x;
    }

    public AverageComparativeScore withUnmappedField(String name, Object value) {
        AverageComparativeScore _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Double averageScore;
        private String basis;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder averageScore(Double averageScore) {
            this.averageScore = averageScore;
            this.changedFields = changedFields.add("averageScore");
            return this;
        }

        public Builder basis(String basis) {
            this.basis = basis;
            this.changedFields = changedFields.add("basis");
            return this;
        }

        public AverageComparativeScore build() {
            AverageComparativeScore _x = new AverageComparativeScore();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.averageComparativeScore";
            _x.averageScore = averageScore;
            _x.basis = basis;
            return _x;
        }
    }

    private AverageComparativeScore _copy() {
        AverageComparativeScore _x = new AverageComparativeScore();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.averageScore = averageScore;
        _x.basis = basis;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AverageComparativeScore[");
        b.append("averageScore=");
        b.append(this.averageScore);
        b.append(", ");
        b.append("basis=");
        b.append(this.basis);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
