package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "message", 
    "messageLanguage", 
    "scheduledEndTime", 
    "scheduledStartTime"})
@JsonInclude(Include.NON_NULL)
public class AutomaticRepliesMailTips implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("message")
    protected String message;

    @JsonProperty("messageLanguage")
    protected LocaleInfo messageLanguage;

    @JsonProperty("scheduledEndTime")
    protected DateTimeTimeZone scheduledEndTime;

    @JsonProperty("scheduledStartTime")
    protected DateTimeTimeZone scheduledStartTime;

    protected AutomaticRepliesMailTips() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.automaticRepliesMailTips";
    }

    @Property(name="message")
    @JsonIgnore
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    public AutomaticRepliesMailTips withMessage(String message) {
        AutomaticRepliesMailTips _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.automaticRepliesMailTips");
        _x.message = message;
        return _x;
    }

    @Property(name="messageLanguage")
    @JsonIgnore
    public Optional<LocaleInfo> getMessageLanguage() {
        return Optional.ofNullable(messageLanguage);
    }

    public AutomaticRepliesMailTips withMessageLanguage(LocaleInfo messageLanguage) {
        AutomaticRepliesMailTips _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.automaticRepliesMailTips");
        _x.messageLanguage = messageLanguage;
        return _x;
    }

    @Property(name="scheduledEndTime")
    @JsonIgnore
    public Optional<DateTimeTimeZone> getScheduledEndTime() {
        return Optional.ofNullable(scheduledEndTime);
    }

    public AutomaticRepliesMailTips withScheduledEndTime(DateTimeTimeZone scheduledEndTime) {
        AutomaticRepliesMailTips _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.automaticRepliesMailTips");
        _x.scheduledEndTime = scheduledEndTime;
        return _x;
    }

    @Property(name="scheduledStartTime")
    @JsonIgnore
    public Optional<DateTimeTimeZone> getScheduledStartTime() {
        return Optional.ofNullable(scheduledStartTime);
    }

    public AutomaticRepliesMailTips withScheduledStartTime(DateTimeTimeZone scheduledStartTime) {
        AutomaticRepliesMailTips _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.automaticRepliesMailTips");
        _x.scheduledStartTime = scheduledStartTime;
        return _x;
    }

    public AutomaticRepliesMailTips withUnmappedField(String name, Object value) {
        AutomaticRepliesMailTips _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String message;
        private LocaleInfo messageLanguage;
        private DateTimeTimeZone scheduledEndTime;
        private DateTimeTimeZone scheduledStartTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder message(String message) {
            this.message = message;
            this.changedFields = changedFields.add("message");
            return this;
        }

        public Builder messageLanguage(LocaleInfo messageLanguage) {
            this.messageLanguage = messageLanguage;
            this.changedFields = changedFields.add("messageLanguage");
            return this;
        }

        public Builder scheduledEndTime(DateTimeTimeZone scheduledEndTime) {
            this.scheduledEndTime = scheduledEndTime;
            this.changedFields = changedFields.add("scheduledEndTime");
            return this;
        }

        public Builder scheduledStartTime(DateTimeTimeZone scheduledStartTime) {
            this.scheduledStartTime = scheduledStartTime;
            this.changedFields = changedFields.add("scheduledStartTime");
            return this;
        }

        public AutomaticRepliesMailTips build() {
            AutomaticRepliesMailTips _x = new AutomaticRepliesMailTips();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.automaticRepliesMailTips";
            _x.message = message;
            _x.messageLanguage = messageLanguage;
            _x.scheduledEndTime = scheduledEndTime;
            _x.scheduledStartTime = scheduledStartTime;
            return _x;
        }
    }

    private AutomaticRepliesMailTips _copy() {
        AutomaticRepliesMailTips _x = new AutomaticRepliesMailTips();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.message = message;
        _x.messageLanguage = messageLanguage;
        _x.scheduledEndTime = scheduledEndTime;
        _x.scheduledStartTime = scheduledStartTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AutomaticRepliesMailTips[");
        b.append("message=");
        b.append(this.message);
        b.append(", ");
        b.append("messageLanguage=");
        b.append(this.messageLanguage);
        b.append(", ");
        b.append("scheduledEndTime=");
        b.append(this.scheduledEndTime);
        b.append(", ");
        b.append("scheduledStartTime=");
        b.append(this.scheduledStartTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
