package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "homeTenantId", 
    "homeTenantName"})
@JsonInclude(Include.NON_NULL)
public class AuditUserIdentity extends UserIdentity implements ODataType {

    @JsonProperty("homeTenantId")
    protected String homeTenantId;

    @JsonProperty("homeTenantName")
    protected String homeTenantName;

    protected AuditUserIdentity() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.auditUserIdentity";
    }

    @Property(name="homeTenantId")
    @JsonIgnore
    public Optional<String> getHomeTenantId() {
        return Optional.ofNullable(homeTenantId);
    }

    public AuditUserIdentity withHomeTenantId(String homeTenantId) {
        AuditUserIdentity _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditUserIdentity");
        _x.homeTenantId = homeTenantId;
        return _x;
    }

    @Property(name="homeTenantName")
    @JsonIgnore
    public Optional<String> getHomeTenantName() {
        return Optional.ofNullable(homeTenantName);
    }

    public AuditUserIdentity withHomeTenantName(String homeTenantName) {
        AuditUserIdentity _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditUserIdentity");
        _x.homeTenantName = homeTenantName;
        return _x;
    }

    public AuditUserIdentity withUnmappedField(String name, Object value) {
        AuditUserIdentity _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAuditUserIdentity() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private String id;
        private String ipAddress;
        private String userPrincipalName;
        private String homeTenantId;
        private String homeTenantName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.changedFields = changedFields.add("ipAddress");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public Builder homeTenantId(String homeTenantId) {
            this.homeTenantId = homeTenantId;
            this.changedFields = changedFields.add("homeTenantId");
            return this;
        }

        public Builder homeTenantName(String homeTenantName) {
            this.homeTenantName = homeTenantName;
            this.changedFields = changedFields.add("homeTenantName");
            return this;
        }

        public AuditUserIdentity build() {
            AuditUserIdentity _x = new AuditUserIdentity();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.auditUserIdentity";
            _x.displayName = displayName;
            _x.id = id;
            _x.ipAddress = ipAddress;
            _x.userPrincipalName = userPrincipalName;
            _x.homeTenantId = homeTenantId;
            _x.homeTenantName = homeTenantName;
            return _x;
        }
    }

    private AuditUserIdentity _copy() {
        AuditUserIdentity _x = new AuditUserIdentity();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.id = id;
        _x.ipAddress = ipAddress;
        _x.userPrincipalName = userPrincipalName;
        _x.homeTenantId = homeTenantId;
        _x.homeTenantName = homeTenantName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AuditUserIdentity[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("ipAddress=");
        b.append(this.ipAddress);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("homeTenantId=");
        b.append(this.homeTenantId);
        b.append(", ");
        b.append("homeTenantName=");
        b.append(this.homeTenantName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
