package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“A class containing the properties for Audit Resource.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "modifiedProperties", 
    "resourceId", 
    "type"})
@JsonInclude(Include.NON_NULL)
public class AuditResource implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("modifiedProperties")
    protected List<AuditProperty> modifiedProperties;

    @JsonProperty("modifiedProperties@nextLink")
    protected String modifiedPropertiesNextLink;

    @JsonProperty("resourceId")
    protected String resourceId;

    @JsonProperty("type")
    protected String type;

    protected AuditResource() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.auditResource";
    }

    /**
     * <i>“Display name.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Display name.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public AuditResource withDisplayName(String displayName) {
        AuditResource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditResource");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“List of modified properties.”</i>
     * 
     * @return property modifiedProperties
     */
    @Property(name="modifiedProperties")
    @JsonIgnore
    public CollectionPage<AuditProperty> getModifiedProperties() {
        return new CollectionPage<AuditProperty>(contextPath, AuditProperty.class, this.modifiedProperties, Optional.ofNullable(modifiedPropertiesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of modified properties.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property modifiedProperties
     */
    @Property(name="modifiedProperties")
    @JsonIgnore
    public CollectionPage<AuditProperty> getModifiedProperties(HttpRequestOptions options) {
        return new CollectionPage<AuditProperty>(contextPath, AuditProperty.class, this.modifiedProperties, Optional.ofNullable(modifiedPropertiesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Audit resource's Id.”</i>
     * 
     * @return property resourceId
     */
    @Property(name="resourceId")
    @JsonIgnore
    public Optional<String> getResourceId() {
        return Optional.ofNullable(resourceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code resourceId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Audit resource's Id.”</i>
     * 
     * @param resourceId
     *            new value of {@code resourceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code resourceId} field changed
     */
    public AuditResource withResourceId(String resourceId) {
        AuditResource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditResource");
        _x.resourceId = resourceId;
        return _x;
    }

    /**
     * <i>“Audit resource's type.”</i>
     * 
     * @return property type
     */
    @Property(name="type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code type} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Audit resource's type.”</i>
     * 
     * @param type
     *            new value of {@code type} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code type} field changed
     */
    public AuditResource withType(String type) {
        AuditResource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditResource");
        _x.type = type;
        return _x;
    }

    public AuditResource withUnmappedField(String name, Object value) {
        AuditResource _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private List<AuditProperty> modifiedProperties;
        private String modifiedPropertiesNextLink;
        private String resourceId;
        private String type;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Display name.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“List of modified properties.”</i>
         * 
         * @param modifiedProperties
         *            value of {@code modifiedProperties} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder modifiedProperties(List<AuditProperty> modifiedProperties) {
            this.modifiedProperties = modifiedProperties;
            this.changedFields = changedFields.add("modifiedProperties");
            return this;
        }

        /**
         * <i>“List of modified properties.”</i>
         * 
         * @param modifiedProperties
         *            value of {@code modifiedProperties} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder modifiedProperties(AuditProperty... modifiedProperties) {
            return modifiedProperties(Arrays.asList(modifiedProperties));
        }

        /**
         * <i>“List of modified properties.”</i>
         * 
         * @param modifiedPropertiesNextLink
         *            value of {@code modifiedProperties@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder modifiedPropertiesNextLink(String modifiedPropertiesNextLink) {
            this.modifiedPropertiesNextLink = modifiedPropertiesNextLink;
            this.changedFields = changedFields.add("modifiedProperties");
            return this;
        }

        /**
         * <i>“Audit resource's Id.”</i>
         * 
         * @param resourceId
         *            value of {@code resourceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.changedFields = changedFields.add("resourceId");
            return this;
        }

        /**
         * <i>“Audit resource's type.”</i>
         * 
         * @param type
         *            value of {@code type} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public AuditResource build() {
            AuditResource _x = new AuditResource();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.auditResource";
            _x.displayName = displayName;
            _x.modifiedProperties = modifiedProperties;
            _x.modifiedPropertiesNextLink = modifiedPropertiesNextLink;
            _x.resourceId = resourceId;
            _x.type = type;
            return _x;
        }
    }

    private AuditResource _copy() {
        AuditResource _x = new AuditResource();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.modifiedProperties = modifiedProperties;
        _x.resourceId = resourceId;
        _x.type = type;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AuditResource[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("modifiedProperties=");
        b.append(this.modifiedProperties);
        b.append(", ");
        b.append("resourceId=");
        b.append(this.resourceId);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
