package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“A class containing the properties for Audit Actor.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "applicationDisplayName", 
    "applicationId", 
    "ipAddress", 
    "remoteTenantId", 
    "remoteUserId", 
    "servicePrincipalName", 
    "type", 
    "userId", 
    "userPermissions", 
    "userPrincipalName", 
    "userRoleScopeTags"})
@JsonInclude(Include.NON_NULL)
public class AuditActor implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("applicationDisplayName")
    protected String applicationDisplayName;

    @JsonProperty("applicationId")
    protected String applicationId;

    @JsonProperty("ipAddress")
    protected String ipAddress;

    @JsonProperty("remoteTenantId")
    protected String remoteTenantId;

    @JsonProperty("remoteUserId")
    protected String remoteUserId;

    @JsonProperty("servicePrincipalName")
    protected String servicePrincipalName;

    @JsonProperty("type")
    protected String type;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("userPermissions")
    protected List<String> userPermissions;

    @JsonProperty("userPermissions@nextLink")
    protected String userPermissionsNextLink;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("userRoleScopeTags")
    protected List<RoleScopeTagInfo> userRoleScopeTags;

    @JsonProperty("userRoleScopeTags@nextLink")
    protected String userRoleScopeTagsNextLink;

    protected AuditActor() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.auditActor";
    }

    /**
     * <i>“Name of the Application.”</i>
     * 
     * @return property applicationDisplayName
     */
    @Property(name="applicationDisplayName")
    @JsonIgnore
    public Optional<String> getApplicationDisplayName() {
        return Optional.ofNullable(applicationDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applicationDisplayName} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Name of the Application.”</i>
     * 
     * @param applicationDisplayName
     *            new value of {@code applicationDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicationDisplayName} field changed
     */
    public AuditActor withApplicationDisplayName(String applicationDisplayName) {
        AuditActor _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditActor");
        _x.applicationDisplayName = applicationDisplayName;
        return _x;
    }

    /**
     * <i>“AAD Application Id.”</i>
     * 
     * @return property applicationId
     */
    @Property(name="applicationId")
    @JsonIgnore
    public Optional<String> getApplicationId() {
        return Optional.ofNullable(applicationId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code applicationId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“AAD Application Id.”</i>
     * 
     * @param applicationId
     *            new value of {@code applicationId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicationId} field changed
     */
    public AuditActor withApplicationId(String applicationId) {
        AuditActor _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditActor");
        _x.applicationId = applicationId;
        return _x;
    }

    /**
     * <i>“IPAddress.”</i>
     * 
     * @return property ipAddress
     */
    @Property(name="ipAddress")
    @JsonIgnore
    public Optional<String> getIpAddress() {
        return Optional.ofNullable(ipAddress);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code ipAddress} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“IPAddress.”</i>
     * 
     * @param ipAddress
     *            new value of {@code ipAddress} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ipAddress} field changed
     */
    public AuditActor withIpAddress(String ipAddress) {
        AuditActor _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditActor");
        _x.ipAddress = ipAddress;
        return _x;
    }

    /**
     * <i>“Remote Tenant Id”</i>
     * 
     * @return property remoteTenantId
     */
    @Property(name="remoteTenantId")
    @JsonIgnore
    public Optional<String> getRemoteTenantId() {
        return Optional.ofNullable(remoteTenantId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code remoteTenantId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Remote Tenant Id”</i>
     * 
     * @param remoteTenantId
     *            new value of {@code remoteTenantId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code remoteTenantId} field changed
     */
    public AuditActor withRemoteTenantId(String remoteTenantId) {
        AuditActor _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditActor");
        _x.remoteTenantId = remoteTenantId;
        return _x;
    }

    /**
     * <i>“Remote User Id”</i>
     * 
     * @return property remoteUserId
     */
    @Property(name="remoteUserId")
    @JsonIgnore
    public Optional<String> getRemoteUserId() {
        return Optional.ofNullable(remoteUserId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code remoteUserId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Remote User Id”</i>
     * 
     * @param remoteUserId
     *            new value of {@code remoteUserId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code remoteUserId} field changed
     */
    public AuditActor withRemoteUserId(String remoteUserId) {
        AuditActor _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditActor");
        _x.remoteUserId = remoteUserId;
        return _x;
    }

    /**
     * <i>“Service Principal Name (SPN).”</i>
     * 
     * @return property servicePrincipalName
     */
    @Property(name="servicePrincipalName")
    @JsonIgnore
    public Optional<String> getServicePrincipalName() {
        return Optional.ofNullable(servicePrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * servicePrincipalName} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Service Principal Name (SPN).”</i>
     * 
     * @param servicePrincipalName
     *            new value of {@code servicePrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code servicePrincipalName} field changed
     */
    public AuditActor withServicePrincipalName(String servicePrincipalName) {
        AuditActor _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditActor");
        _x.servicePrincipalName = servicePrincipalName;
        return _x;
    }

    /**
     * <i>“Actor Type.”</i>
     * 
     * @return property type
     */
    @Property(name="type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code type} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Actor Type.”</i>
     * 
     * @param type
     *            new value of {@code type} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code type} field changed
     */
    public AuditActor withType(String type) {
        AuditActor _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditActor");
        _x.type = type;
        return _x;
    }

    /**
     * <i>“User Id.”</i>
     * 
     * @return property userId
     */
    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“User Id.”</i>
     * 
     * @param userId
     *            new value of {@code userId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userId} field changed
     */
    public AuditActor withUserId(String userId) {
        AuditActor _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditActor");
        _x.userId = userId;
        return _x;
    }

    /**
     * <i>“List of user permissions when the audit was performed.”</i>
     * 
     * @return property userPermissions
     */
    @Property(name="userPermissions")
    @JsonIgnore
    public CollectionPage<String> getUserPermissions() {
        return new CollectionPage<String>(contextPath, String.class, this.userPermissions, Optional.ofNullable(userPermissionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of user permissions when the audit was performed.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property userPermissions
     */
    @Property(name="userPermissions")
    @JsonIgnore
    public CollectionPage<String> getUserPermissions(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.userPermissions, Optional.ofNullable(userPermissionsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“User Principal Name (UPN).”</i>
     * 
     * @return property userPrincipalName
     */
    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userPrincipalName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“User Principal Name (UPN).”</i>
     * 
     * @param userPrincipalName
     *            new value of {@code userPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userPrincipalName} field changed
     */
    public AuditActor withUserPrincipalName(String userPrincipalName) {
        AuditActor _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditActor");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    /**
     * <i>“List of user scope tags when the audit was performed.”</i>
     * 
     * @return property userRoleScopeTags
     */
    @Property(name="userRoleScopeTags")
    @JsonIgnore
    public CollectionPage<RoleScopeTagInfo> getUserRoleScopeTags() {
        return new CollectionPage<RoleScopeTagInfo>(contextPath, RoleScopeTagInfo.class, this.userRoleScopeTags, Optional.ofNullable(userRoleScopeTagsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of user scope tags when the audit was performed.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property userRoleScopeTags
     */
    @Property(name="userRoleScopeTags")
    @JsonIgnore
    public CollectionPage<RoleScopeTagInfo> getUserRoleScopeTags(HttpRequestOptions options) {
        return new CollectionPage<RoleScopeTagInfo>(contextPath, RoleScopeTagInfo.class, this.userRoleScopeTags, Optional.ofNullable(userRoleScopeTagsNextLink), Collections.emptyList(), options);
    }

    public AuditActor withUnmappedField(String name, Object value) {
        AuditActor _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String applicationDisplayName;
        private String applicationId;
        private String ipAddress;
        private String remoteTenantId;
        private String remoteUserId;
        private String servicePrincipalName;
        private String type;
        private String userId;
        private List<String> userPermissions;
        private String userPermissionsNextLink;
        private String userPrincipalName;
        private List<RoleScopeTagInfo> userRoleScopeTags;
        private String userRoleScopeTagsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Name of the Application.”</i>
         * 
         * @param applicationDisplayName
         *            value of {@code applicationDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicationDisplayName(String applicationDisplayName) {
            this.applicationDisplayName = applicationDisplayName;
            this.changedFields = changedFields.add("applicationDisplayName");
            return this;
        }

        /**
         * <i>“AAD Application Id.”</i>
         * 
         * @param applicationId
         *            value of {@code applicationId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            this.changedFields = changedFields.add("applicationId");
            return this;
        }

        /**
         * <i>“IPAddress.”</i>
         * 
         * @param ipAddress
         *            value of {@code ipAddress} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.changedFields = changedFields.add("ipAddress");
            return this;
        }

        /**
         * <i>“Remote Tenant Id”</i>
         * 
         * @param remoteTenantId
         *            value of {@code remoteTenantId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remoteTenantId(String remoteTenantId) {
            this.remoteTenantId = remoteTenantId;
            this.changedFields = changedFields.add("remoteTenantId");
            return this;
        }

        /**
         * <i>“Remote User Id”</i>
         * 
         * @param remoteUserId
         *            value of {@code remoteUserId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remoteUserId(String remoteUserId) {
            this.remoteUserId = remoteUserId;
            this.changedFields = changedFields.add("remoteUserId");
            return this;
        }

        /**
         * <i>“Service Principal Name (SPN).”</i>
         * 
         * @param servicePrincipalName
         *            value of {@code servicePrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder servicePrincipalName(String servicePrincipalName) {
            this.servicePrincipalName = servicePrincipalName;
            this.changedFields = changedFields.add("servicePrincipalName");
            return this;
        }

        /**
         * <i>“Actor Type.”</i>
         * 
         * @param type
         *            value of {@code type} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        /**
         * <i>“User Id.”</i>
         * 
         * @param userId
         *            value of {@code userId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        /**
         * <i>“List of user permissions when the audit was performed.”</i>
         * 
         * @param userPermissions
         *            value of {@code userPermissions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPermissions(List<String> userPermissions) {
            this.userPermissions = userPermissions;
            this.changedFields = changedFields.add("userPermissions");
            return this;
        }

        /**
         * <i>“List of user permissions when the audit was performed.”</i>
         * 
         * @param userPermissions
         *            value of {@code userPermissions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPermissions(String... userPermissions) {
            return userPermissions(Arrays.asList(userPermissions));
        }

        /**
         * <i>“List of user permissions when the audit was performed.”</i>
         * 
         * @param userPermissionsNextLink
         *            value of {@code userPermissions@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPermissionsNextLink(String userPermissionsNextLink) {
            this.userPermissionsNextLink = userPermissionsNextLink;
            this.changedFields = changedFields.add("userPermissions");
            return this;
        }

        /**
         * <i>“User Principal Name (UPN).”</i>
         * 
         * @param userPrincipalName
         *            value of {@code userPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        /**
         * <i>“List of user scope tags when the audit was performed.”</i>
         * 
         * @param userRoleScopeTags
         *            value of {@code userRoleScopeTags} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRoleScopeTags(List<RoleScopeTagInfo> userRoleScopeTags) {
            this.userRoleScopeTags = userRoleScopeTags;
            this.changedFields = changedFields.add("userRoleScopeTags");
            return this;
        }

        /**
         * <i>“List of user scope tags when the audit was performed.”</i>
         * 
         * @param userRoleScopeTags
         *            value of {@code userRoleScopeTags} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRoleScopeTags(RoleScopeTagInfo... userRoleScopeTags) {
            return userRoleScopeTags(Arrays.asList(userRoleScopeTags));
        }

        /**
         * <i>“List of user scope tags when the audit was performed.”</i>
         * 
         * @param userRoleScopeTagsNextLink
         *            value of {@code userRoleScopeTags@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRoleScopeTagsNextLink(String userRoleScopeTagsNextLink) {
            this.userRoleScopeTagsNextLink = userRoleScopeTagsNextLink;
            this.changedFields = changedFields.add("userRoleScopeTags");
            return this;
        }

        public AuditActor build() {
            AuditActor _x = new AuditActor();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.auditActor";
            _x.applicationDisplayName = applicationDisplayName;
            _x.applicationId = applicationId;
            _x.ipAddress = ipAddress;
            _x.remoteTenantId = remoteTenantId;
            _x.remoteUserId = remoteUserId;
            _x.servicePrincipalName = servicePrincipalName;
            _x.type = type;
            _x.userId = userId;
            _x.userPermissions = userPermissions;
            _x.userPermissionsNextLink = userPermissionsNextLink;
            _x.userPrincipalName = userPrincipalName;
            _x.userRoleScopeTags = userRoleScopeTags;
            _x.userRoleScopeTagsNextLink = userRoleScopeTagsNextLink;
            return _x;
        }
    }

    private AuditActor _copy() {
        AuditActor _x = new AuditActor();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.applicationDisplayName = applicationDisplayName;
        _x.applicationId = applicationId;
        _x.ipAddress = ipAddress;
        _x.remoteTenantId = remoteTenantId;
        _x.remoteUserId = remoteUserId;
        _x.servicePrincipalName = servicePrincipalName;
        _x.type = type;
        _x.userId = userId;
        _x.userPermissions = userPermissions;
        _x.userPrincipalName = userPrincipalName;
        _x.userRoleScopeTags = userRoleScopeTags;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AuditActor[");
        b.append("applicationDisplayName=");
        b.append(this.applicationDisplayName);
        b.append(", ");
        b.append("applicationId=");
        b.append(this.applicationId);
        b.append(", ");
        b.append("ipAddress=");
        b.append(this.ipAddress);
        b.append(", ");
        b.append("remoteTenantId=");
        b.append(this.remoteTenantId);
        b.append(", ");
        b.append("remoteUserId=");
        b.append(this.remoteUserId);
        b.append(", ");
        b.append("servicePrincipalName=");
        b.append(this.servicePrincipalName);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("userPermissions=");
        b.append(this.userPermissions);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("userRoleScopeTags=");
        b.append(this.userRoleScopeTags);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
