package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "app", 
    "user"})
@JsonInclude(Include.NON_NULL)
public class AuditActivityInitiator implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("app")
    protected AppIdentity app;

    @JsonProperty("user")
    protected AuditUserIdentity user;

    protected AuditActivityInitiator() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.auditActivityInitiator";
    }

    @Property(name="app")
    @JsonIgnore
    public Optional<AppIdentity> getApp() {
        return Optional.ofNullable(app);
    }

    public AuditActivityInitiator withApp(AppIdentity app) {
        AuditActivityInitiator _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditActivityInitiator");
        _x.app = app;
        return _x;
    }

    @Property(name="user")
    @JsonIgnore
    public Optional<AuditUserIdentity> getUser() {
        return Optional.ofNullable(user);
    }

    public AuditActivityInitiator withUser(AuditUserIdentity user) {
        AuditActivityInitiator _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditActivityInitiator");
        _x.user = user;
        return _x;
    }

    public AuditActivityInitiator withUnmappedField(String name, Object value) {
        AuditActivityInitiator _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AppIdentity app;
        private AuditUserIdentity user;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder app(AppIdentity app) {
            this.app = app;
            this.changedFields = changedFields.add("app");
            return this;
        }

        public Builder user(AuditUserIdentity user) {
            this.user = user;
            this.changedFields = changedFields.add("user");
            return this;
        }

        public AuditActivityInitiator build() {
            AuditActivityInitiator _x = new AuditActivityInitiator();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.auditActivityInitiator";
            _x.app = app;
            _x.user = user;
            return _x;
        }
    }

    private AuditActivityInitiator _copy() {
        AuditActivityInitiator _x = new AuditActivityInitiator();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.app = app;
        _x.user = user;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AuditActivityInitiator[");
        b.append("app=");
        b.append(this.app);
        b.append(", ");
        b.append("user=");
        b.append(this.user);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
