package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "conferenceId", 
    "dialinUrl", 
    "tollFreeNumber", 
    "tollFreeNumbers", 
    "tollNumber", 
    "tollNumbers"})
@JsonInclude(Include.NON_NULL)
public class AudioConferencing implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("conferenceId")
    protected String conferenceId;

    @JsonProperty("dialinUrl")
    protected String dialinUrl;

    @JsonProperty("tollFreeNumber")
    protected String tollFreeNumber;

    @JsonProperty("tollFreeNumbers")
    protected List<String> tollFreeNumbers;

    @JsonProperty("tollFreeNumbers@nextLink")
    protected String tollFreeNumbersNextLink;

    @JsonProperty("tollNumber")
    protected String tollNumber;

    @JsonProperty("tollNumbers")
    protected List<String> tollNumbers;

    @JsonProperty("tollNumbers@nextLink")
    protected String tollNumbersNextLink;

    protected AudioConferencing() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.audioConferencing";
    }

    @Property(name="conferenceId")
    @JsonIgnore
    public Optional<String> getConferenceId() {
        return Optional.ofNullable(conferenceId);
    }

    public AudioConferencing withConferenceId(String conferenceId) {
        AudioConferencing _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.audioConferencing");
        _x.conferenceId = conferenceId;
        return _x;
    }

    @Property(name="dialinUrl")
    @JsonIgnore
    public Optional<String> getDialinUrl() {
        return Optional.ofNullable(dialinUrl);
    }

    public AudioConferencing withDialinUrl(String dialinUrl) {
        AudioConferencing _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.audioConferencing");
        _x.dialinUrl = dialinUrl;
        return _x;
    }

    @Property(name="tollFreeNumber")
    @JsonIgnore
    public Optional<String> getTollFreeNumber() {
        return Optional.ofNullable(tollFreeNumber);
    }

    public AudioConferencing withTollFreeNumber(String tollFreeNumber) {
        AudioConferencing _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.audioConferencing");
        _x.tollFreeNumber = tollFreeNumber;
        return _x;
    }

    @Property(name="tollFreeNumbers")
    @JsonIgnore
    public CollectionPage<String> getTollFreeNumbers() {
        return new CollectionPage<String>(contextPath, String.class, this.tollFreeNumbers, Optional.ofNullable(tollFreeNumbersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="tollFreeNumbers")
    @JsonIgnore
    public CollectionPage<String> getTollFreeNumbers(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.tollFreeNumbers, Optional.ofNullable(tollFreeNumbersNextLink), Collections.emptyList(), options);
    }

    @Property(name="tollNumber")
    @JsonIgnore
    public Optional<String> getTollNumber() {
        return Optional.ofNullable(tollNumber);
    }

    public AudioConferencing withTollNumber(String tollNumber) {
        AudioConferencing _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.audioConferencing");
        _x.tollNumber = tollNumber;
        return _x;
    }

    @Property(name="tollNumbers")
    @JsonIgnore
    public CollectionPage<String> getTollNumbers() {
        return new CollectionPage<String>(contextPath, String.class, this.tollNumbers, Optional.ofNullable(tollNumbersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="tollNumbers")
    @JsonIgnore
    public CollectionPage<String> getTollNumbers(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.tollNumbers, Optional.ofNullable(tollNumbersNextLink), Collections.emptyList(), options);
    }

    public AudioConferencing withUnmappedField(String name, Object value) {
        AudioConferencing _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String conferenceId;
        private String dialinUrl;
        private String tollFreeNumber;
        private List<String> tollFreeNumbers;
        private String tollFreeNumbersNextLink;
        private String tollNumber;
        private List<String> tollNumbers;
        private String tollNumbersNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder conferenceId(String conferenceId) {
            this.conferenceId = conferenceId;
            this.changedFields = changedFields.add("conferenceId");
            return this;
        }

        public Builder dialinUrl(String dialinUrl) {
            this.dialinUrl = dialinUrl;
            this.changedFields = changedFields.add("dialinUrl");
            return this;
        }

        public Builder tollFreeNumber(String tollFreeNumber) {
            this.tollFreeNumber = tollFreeNumber;
            this.changedFields = changedFields.add("tollFreeNumber");
            return this;
        }

        public Builder tollFreeNumbers(List<String> tollFreeNumbers) {
            this.tollFreeNumbers = tollFreeNumbers;
            this.changedFields = changedFields.add("tollFreeNumbers");
            return this;
        }

        public Builder tollFreeNumbers(String... tollFreeNumbers) {
            return tollFreeNumbers(Arrays.asList(tollFreeNumbers));
        }

        public Builder tollFreeNumbersNextLink(String tollFreeNumbersNextLink) {
            this.tollFreeNumbersNextLink = tollFreeNumbersNextLink;
            this.changedFields = changedFields.add("tollFreeNumbers");
            return this;
        }

        public Builder tollNumber(String tollNumber) {
            this.tollNumber = tollNumber;
            this.changedFields = changedFields.add("tollNumber");
            return this;
        }

        public Builder tollNumbers(List<String> tollNumbers) {
            this.tollNumbers = tollNumbers;
            this.changedFields = changedFields.add("tollNumbers");
            return this;
        }

        public Builder tollNumbers(String... tollNumbers) {
            return tollNumbers(Arrays.asList(tollNumbers));
        }

        public Builder tollNumbersNextLink(String tollNumbersNextLink) {
            this.tollNumbersNextLink = tollNumbersNextLink;
            this.changedFields = changedFields.add("tollNumbers");
            return this;
        }

        public AudioConferencing build() {
            AudioConferencing _x = new AudioConferencing();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.audioConferencing";
            _x.conferenceId = conferenceId;
            _x.dialinUrl = dialinUrl;
            _x.tollFreeNumber = tollFreeNumber;
            _x.tollFreeNumbers = tollFreeNumbers;
            _x.tollFreeNumbersNextLink = tollFreeNumbersNextLink;
            _x.tollNumber = tollNumber;
            _x.tollNumbers = tollNumbers;
            _x.tollNumbersNextLink = tollNumbersNextLink;
            return _x;
        }
    }

    private AudioConferencing _copy() {
        AudioConferencing _x = new AudioConferencing();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.conferenceId = conferenceId;
        _x.dialinUrl = dialinUrl;
        _x.tollFreeNumber = tollFreeNumber;
        _x.tollFreeNumbers = tollFreeNumbers;
        _x.tollNumber = tollNumber;
        _x.tollNumbers = tollNumbers;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AudioConferencing[");
        b.append("conferenceId=");
        b.append(this.conferenceId);
        b.append(", ");
        b.append("dialinUrl=");
        b.append(this.dialinUrl);
        b.append(", ");
        b.append("tollFreeNumber=");
        b.append(this.tollFreeNumber);
        b.append(", ");
        b.append("tollFreeNumbers=");
        b.append(this.tollFreeNumbers);
        b.append(", ");
        b.append("tollNumber=");
        b.append(this.tollNumber);
        b.append(", ");
        b.append("tollNumbers=");
        b.append(this.tollNumbers);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
