package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AttributeMappingSourceType;

@JsonPropertyOrder({
    "@odata.type", 
    "expression", 
    "name", 
    "parameters", 
    "type"})
@JsonInclude(Include.NON_NULL)
public class AttributeMappingSource implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("expression")
    protected String expression;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("parameters")
    protected List<StringKeyAttributeMappingSourceValuePair> parameters;

    @JsonProperty("parameters@nextLink")
    protected String parametersNextLink;

    @JsonProperty("type")
    protected AttributeMappingSourceType type;

    protected AttributeMappingSource() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.attributeMappingSource";
    }

    @Property(name="expression")
    @JsonIgnore
    public Optional<String> getExpression() {
        return Optional.ofNullable(expression);
    }

    public AttributeMappingSource withExpression(String expression) {
        AttributeMappingSource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attributeMappingSource");
        _x.expression = expression;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public AttributeMappingSource withName(String name) {
        AttributeMappingSource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attributeMappingSource");
        _x.name = name;
        return _x;
    }

    @Property(name="parameters")
    @JsonIgnore
    public CollectionPage<StringKeyAttributeMappingSourceValuePair> getParameters() {
        return new CollectionPage<StringKeyAttributeMappingSourceValuePair>(contextPath, StringKeyAttributeMappingSourceValuePair.class, this.parameters, Optional.ofNullable(parametersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="parameters")
    @JsonIgnore
    public CollectionPage<StringKeyAttributeMappingSourceValuePair> getParameters(HttpRequestOptions options) {
        return new CollectionPage<StringKeyAttributeMappingSourceValuePair>(contextPath, StringKeyAttributeMappingSourceValuePair.class, this.parameters, Optional.ofNullable(parametersNextLink), Collections.emptyList(), options);
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<AttributeMappingSourceType> getType() {
        return Optional.ofNullable(type);
    }

    public AttributeMappingSource withType(AttributeMappingSourceType type) {
        AttributeMappingSource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attributeMappingSource");
        _x.type = type;
        return _x;
    }

    public AttributeMappingSource withUnmappedField(String name, Object value) {
        AttributeMappingSource _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String expression;
        private String name;
        private List<StringKeyAttributeMappingSourceValuePair> parameters;
        private String parametersNextLink;
        private AttributeMappingSourceType type;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder expression(String expression) {
            this.expression = expression;
            this.changedFields = changedFields.add("expression");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder parameters(List<StringKeyAttributeMappingSourceValuePair> parameters) {
            this.parameters = parameters;
            this.changedFields = changedFields.add("parameters");
            return this;
        }

        public Builder parameters(StringKeyAttributeMappingSourceValuePair... parameters) {
            return parameters(Arrays.asList(parameters));
        }

        public Builder parametersNextLink(String parametersNextLink) {
            this.parametersNextLink = parametersNextLink;
            this.changedFields = changedFields.add("parameters");
            return this;
        }

        public Builder type(AttributeMappingSourceType type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public AttributeMappingSource build() {
            AttributeMappingSource _x = new AttributeMappingSource();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.attributeMappingSource";
            _x.expression = expression;
            _x.name = name;
            _x.parameters = parameters;
            _x.parametersNextLink = parametersNextLink;
            _x.type = type;
            return _x;
        }
    }

    private AttributeMappingSource _copy() {
        AttributeMappingSource _x = new AttributeMappingSource();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.expression = expression;
        _x.name = name;
        _x.parameters = parameters;
        _x.type = type;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AttributeMappingSource[");
        b.append("expression=");
        b.append(this.expression);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("parameters=");
        b.append(this.parameters);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
