package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AccessReviewTimeoutBehavior;

@JsonPropertyOrder({
    "@odata.type", 
    "accessReviewTimeoutBehavior", 
    "durationInDays", 
    "isAccessRecommendationEnabled", 
    "isApprovalJustificationRequired", 
    "isEnabled", 
    "recurrenceType", 
    "reviewers", 
    "reviewerType", 
    "startDateTime"})
@JsonInclude(Include.NON_NULL)
public class AssignmentReviewSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("accessReviewTimeoutBehavior")
    protected AccessReviewTimeoutBehavior accessReviewTimeoutBehavior;

    @JsonProperty("durationInDays")
    protected Integer durationInDays;

    @JsonProperty("isAccessRecommendationEnabled")
    protected Boolean isAccessRecommendationEnabled;

    @JsonProperty("isApprovalJustificationRequired")
    protected Boolean isApprovalJustificationRequired;

    @JsonProperty("isEnabled")
    protected Boolean isEnabled;

    @JsonProperty("recurrenceType")
    protected String recurrenceType;

    @JsonProperty("reviewers")
    protected List<UserSet> reviewers;

    @JsonProperty("reviewers@nextLink")
    protected String reviewersNextLink;

    @JsonProperty("reviewerType")
    protected String reviewerType;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    protected AssignmentReviewSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.assignmentReviewSettings";
    }

    @Property(name="accessReviewTimeoutBehavior")
    @JsonIgnore
    public Optional<AccessReviewTimeoutBehavior> getAccessReviewTimeoutBehavior() {
        return Optional.ofNullable(accessReviewTimeoutBehavior);
    }

    public AssignmentReviewSettings withAccessReviewTimeoutBehavior(AccessReviewTimeoutBehavior accessReviewTimeoutBehavior) {
        AssignmentReviewSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentReviewSettings");
        _x.accessReviewTimeoutBehavior = accessReviewTimeoutBehavior;
        return _x;
    }

    @Property(name="durationInDays")
    @JsonIgnore
    public Optional<Integer> getDurationInDays() {
        return Optional.ofNullable(durationInDays);
    }

    public AssignmentReviewSettings withDurationInDays(Integer durationInDays) {
        AssignmentReviewSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentReviewSettings");
        _x.durationInDays = durationInDays;
        return _x;
    }

    @Property(name="isAccessRecommendationEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsAccessRecommendationEnabled() {
        return Optional.ofNullable(isAccessRecommendationEnabled);
    }

    public AssignmentReviewSettings withIsAccessRecommendationEnabled(Boolean isAccessRecommendationEnabled) {
        AssignmentReviewSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentReviewSettings");
        _x.isAccessRecommendationEnabled = isAccessRecommendationEnabled;
        return _x;
    }

    @Property(name="isApprovalJustificationRequired")
    @JsonIgnore
    public Optional<Boolean> getIsApprovalJustificationRequired() {
        return Optional.ofNullable(isApprovalJustificationRequired);
    }

    public AssignmentReviewSettings withIsApprovalJustificationRequired(Boolean isApprovalJustificationRequired) {
        AssignmentReviewSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentReviewSettings");
        _x.isApprovalJustificationRequired = isApprovalJustificationRequired;
        return _x;
    }

    @Property(name="isEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsEnabled() {
        return Optional.ofNullable(isEnabled);
    }

    public AssignmentReviewSettings withIsEnabled(Boolean isEnabled) {
        AssignmentReviewSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentReviewSettings");
        _x.isEnabled = isEnabled;
        return _x;
    }

    @Property(name="recurrenceType")
    @JsonIgnore
    public Optional<String> getRecurrenceType() {
        return Optional.ofNullable(recurrenceType);
    }

    public AssignmentReviewSettings withRecurrenceType(String recurrenceType) {
        AssignmentReviewSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentReviewSettings");
        _x.recurrenceType = recurrenceType;
        return _x;
    }

    @Property(name="reviewers")
    @JsonIgnore
    public CollectionPage<UserSet> getReviewers() {
        return new CollectionPage<UserSet>(contextPath, UserSet.class, this.reviewers, Optional.ofNullable(reviewersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="reviewers")
    @JsonIgnore
    public CollectionPage<UserSet> getReviewers(HttpRequestOptions options) {
        return new CollectionPage<UserSet>(contextPath, UserSet.class, this.reviewers, Optional.ofNullable(reviewersNextLink), Collections.emptyList(), options);
    }

    @Property(name="reviewerType")
    @JsonIgnore
    public Optional<String> getReviewerType() {
        return Optional.ofNullable(reviewerType);
    }

    public AssignmentReviewSettings withReviewerType(String reviewerType) {
        AssignmentReviewSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentReviewSettings");
        _x.reviewerType = reviewerType;
        return _x;
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public AssignmentReviewSettings withStartDateTime(OffsetDateTime startDateTime) {
        AssignmentReviewSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentReviewSettings");
        _x.startDateTime = startDateTime;
        return _x;
    }

    public AssignmentReviewSettings withUnmappedField(String name, Object value) {
        AssignmentReviewSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AccessReviewTimeoutBehavior accessReviewTimeoutBehavior;
        private Integer durationInDays;
        private Boolean isAccessRecommendationEnabled;
        private Boolean isApprovalJustificationRequired;
        private Boolean isEnabled;
        private String recurrenceType;
        private List<UserSet> reviewers;
        private String reviewersNextLink;
        private String reviewerType;
        private OffsetDateTime startDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder accessReviewTimeoutBehavior(AccessReviewTimeoutBehavior accessReviewTimeoutBehavior) {
            this.accessReviewTimeoutBehavior = accessReviewTimeoutBehavior;
            this.changedFields = changedFields.add("accessReviewTimeoutBehavior");
            return this;
        }

        public Builder durationInDays(Integer durationInDays) {
            this.durationInDays = durationInDays;
            this.changedFields = changedFields.add("durationInDays");
            return this;
        }

        public Builder isAccessRecommendationEnabled(Boolean isAccessRecommendationEnabled) {
            this.isAccessRecommendationEnabled = isAccessRecommendationEnabled;
            this.changedFields = changedFields.add("isAccessRecommendationEnabled");
            return this;
        }

        public Builder isApprovalJustificationRequired(Boolean isApprovalJustificationRequired) {
            this.isApprovalJustificationRequired = isApprovalJustificationRequired;
            this.changedFields = changedFields.add("isApprovalJustificationRequired");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.changedFields = changedFields.add("isEnabled");
            return this;
        }

        public Builder recurrenceType(String recurrenceType) {
            this.recurrenceType = recurrenceType;
            this.changedFields = changedFields.add("recurrenceType");
            return this;
        }

        public Builder reviewers(List<UserSet> reviewers) {
            this.reviewers = reviewers;
            this.changedFields = changedFields.add("reviewers");
            return this;
        }

        public Builder reviewers(UserSet... reviewers) {
            return reviewers(Arrays.asList(reviewers));
        }

        public Builder reviewersNextLink(String reviewersNextLink) {
            this.reviewersNextLink = reviewersNextLink;
            this.changedFields = changedFields.add("reviewers");
            return this;
        }

        public Builder reviewerType(String reviewerType) {
            this.reviewerType = reviewerType;
            this.changedFields = changedFields.add("reviewerType");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public AssignmentReviewSettings build() {
            AssignmentReviewSettings _x = new AssignmentReviewSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.assignmentReviewSettings";
            _x.accessReviewTimeoutBehavior = accessReviewTimeoutBehavior;
            _x.durationInDays = durationInDays;
            _x.isAccessRecommendationEnabled = isAccessRecommendationEnabled;
            _x.isApprovalJustificationRequired = isApprovalJustificationRequired;
            _x.isEnabled = isEnabled;
            _x.recurrenceType = recurrenceType;
            _x.reviewers = reviewers;
            _x.reviewersNextLink = reviewersNextLink;
            _x.reviewerType = reviewerType;
            _x.startDateTime = startDateTime;
            return _x;
        }
    }

    private AssignmentReviewSettings _copy() {
        AssignmentReviewSettings _x = new AssignmentReviewSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.accessReviewTimeoutBehavior = accessReviewTimeoutBehavior;
        _x.durationInDays = durationInDays;
        _x.isAccessRecommendationEnabled = isAccessRecommendationEnabled;
        _x.isApprovalJustificationRequired = isApprovalJustificationRequired;
        _x.isEnabled = isEnabled;
        _x.recurrenceType = recurrenceType;
        _x.reviewers = reviewers;
        _x.reviewerType = reviewerType;
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AssignmentReviewSettings[");
        b.append("accessReviewTimeoutBehavior=");
        b.append(this.accessReviewTimeoutBehavior);
        b.append(", ");
        b.append("durationInDays=");
        b.append(this.durationInDays);
        b.append(", ");
        b.append("isAccessRecommendationEnabled=");
        b.append(this.isAccessRecommendationEnabled);
        b.append(", ");
        b.append("isApprovalJustificationRequired=");
        b.append(this.isApprovalJustificationRequired);
        b.append(", ");
        b.append("isEnabled=");
        b.append(this.isEnabled);
        b.append(", ");
        b.append("recurrenceType=");
        b.append(this.recurrenceType);
        b.append(", ");
        b.append("reviewers=");
        b.append(this.reviewers);
        b.append(", ");
        b.append("reviewerType=");
        b.append(this.reviewerType);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
