package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AssignmentFilterEvaluationResult;
import odata.msgraph.client.beta.enums.DeviceAndAppManagementAssignmentFilterType;


/**
 * <i>“Represents the filter type and evalaution result of the filter.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "assignmentFilterType", 
    "evaluationResult"})
@JsonInclude(Include.NON_NULL)
public class AssignmentFilterTypeAndEvaluationResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("assignmentFilterType")
    protected DeviceAndAppManagementAssignmentFilterType assignmentFilterType;

    @JsonProperty("evaluationResult")
    protected AssignmentFilterEvaluationResult evaluationResult;

    protected AssignmentFilterTypeAndEvaluationResult() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.assignmentFilterTypeAndEvaluationResult";
    }

    /**
     * <i>“Represents the filter type.”</i>
     * 
     * @return property assignmentFilterType
     */
    @Property(name="assignmentFilterType")
    @JsonIgnore
    public Optional<DeviceAndAppManagementAssignmentFilterType> getAssignmentFilterType() {
        return Optional.ofNullable(assignmentFilterType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * assignmentFilterType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Represents the filter type.”</i>
     * 
     * @param assignmentFilterType
     *            new value of {@code assignmentFilterType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assignmentFilterType} field changed
     */
    public AssignmentFilterTypeAndEvaluationResult withAssignmentFilterType(DeviceAndAppManagementAssignmentFilterType assignmentFilterType) {
        AssignmentFilterTypeAndEvaluationResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentFilterTypeAndEvaluationResult");
        _x.assignmentFilterType = assignmentFilterType;
        return _x;
    }

    /**
     * <i>“Represents the evalaution result of the filter.”</i>
     * 
     * @return property evaluationResult
     */
    @Property(name="evaluationResult")
    @JsonIgnore
    public Optional<AssignmentFilterEvaluationResult> getEvaluationResult() {
        return Optional.ofNullable(evaluationResult);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code evaluationResult}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Represents the evalaution result of the filter.”</i>
     * 
     * @param evaluationResult
     *            new value of {@code evaluationResult} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code evaluationResult} field changed
     */
    public AssignmentFilterTypeAndEvaluationResult withEvaluationResult(AssignmentFilterEvaluationResult evaluationResult) {
        AssignmentFilterTypeAndEvaluationResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentFilterTypeAndEvaluationResult");
        _x.evaluationResult = evaluationResult;
        return _x;
    }

    public AssignmentFilterTypeAndEvaluationResult withUnmappedField(String name, Object value) {
        AssignmentFilterTypeAndEvaluationResult _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DeviceAndAppManagementAssignmentFilterType assignmentFilterType;
        private AssignmentFilterEvaluationResult evaluationResult;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Represents the filter type.”</i>
         * 
         * @param assignmentFilterType
         *            value of {@code assignmentFilterType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignmentFilterType(DeviceAndAppManagementAssignmentFilterType assignmentFilterType) {
            this.assignmentFilterType = assignmentFilterType;
            this.changedFields = changedFields.add("assignmentFilterType");
            return this;
        }

        /**
         * <i>“Represents the evalaution result of the filter.”</i>
         * 
         * @param evaluationResult
         *            value of {@code evaluationResult} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder evaluationResult(AssignmentFilterEvaluationResult evaluationResult) {
            this.evaluationResult = evaluationResult;
            this.changedFields = changedFields.add("evaluationResult");
            return this;
        }

        public AssignmentFilterTypeAndEvaluationResult build() {
            AssignmentFilterTypeAndEvaluationResult _x = new AssignmentFilterTypeAndEvaluationResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.assignmentFilterTypeAndEvaluationResult";
            _x.assignmentFilterType = assignmentFilterType;
            _x.evaluationResult = evaluationResult;
            return _x;
        }
    }

    private AssignmentFilterTypeAndEvaluationResult _copy() {
        AssignmentFilterTypeAndEvaluationResult _x = new AssignmentFilterTypeAndEvaluationResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.assignmentFilterType = assignmentFilterType;
        _x.evaluationResult = evaluationResult;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AssignmentFilterTypeAndEvaluationResult[");
        b.append("assignmentFilterType=");
        b.append(this.assignmentFilterType);
        b.append(", ");
        b.append("evaluationResult=");
        b.append(this.evaluationResult);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
