package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AssignmentFilterOperator;


/**
 * <i>“Represents the information about the property which is supported in crafting the
 * rule of AssignmentFilter.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "dataType", 
    "isCollection", 
    "name", 
    "propertyRegexConstraint", 
    "supportedOperators", 
    "supportedValues"})
@JsonInclude(Include.NON_NULL)
public class AssignmentFilterSupportedProperty implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("dataType")
    protected String dataType;

    @JsonProperty("isCollection")
    protected Boolean isCollection;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("propertyRegexConstraint")
    protected String propertyRegexConstraint;

    @JsonProperty("supportedOperators")
    protected List<AssignmentFilterOperator> supportedOperators;

    @JsonProperty("supportedOperators@nextLink")
    protected String supportedOperatorsNextLink;

    @JsonProperty("supportedValues")
    protected List<String> supportedValues;

    @JsonProperty("supportedValues@nextLink")
    protected String supportedValuesNextLink;

    protected AssignmentFilterSupportedProperty() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.assignmentFilterSupportedProperty";
    }

    /**
     * <i>“The data type of the property.”</i>
     * 
     * @return property dataType
     */
    @Property(name="dataType")
    @JsonIgnore
    public Optional<String> getDataType() {
        return Optional.ofNullable(dataType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code dataType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The data type of the property.”</i>
     * 
     * @param dataType
     *            new value of {@code dataType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dataType} field changed
     */
    public AssignmentFilterSupportedProperty withDataType(String dataType) {
        AssignmentFilterSupportedProperty _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentFilterSupportedProperty");
        _x.dataType = dataType;
        return _x;
    }

    /**
     * <i>“Indicates whether the property is a collection type or not.”</i>
     * 
     * @return property isCollection
     */
    @Property(name="isCollection")
    @JsonIgnore
    public Optional<Boolean> getIsCollection() {
        return Optional.ofNullable(isCollection);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isCollection}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether the property is a collection type or not.”</i>
     * 
     * @param isCollection
     *            new value of {@code isCollection} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isCollection} field changed
     */
    public AssignmentFilterSupportedProperty withIsCollection(Boolean isCollection) {
        AssignmentFilterSupportedProperty _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentFilterSupportedProperty");
        _x.isCollection = isCollection;
        return _x;
    }

    /**
     * <i>“Name of the property.”</i>
     * 
     * @return property name
     */
    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code name} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Name of the property.”</i>
     * 
     * @param name
     *            new value of {@code name} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code name} field changed
     */
    public AssignmentFilterSupportedProperty withName(String name) {
        AssignmentFilterSupportedProperty _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentFilterSupportedProperty");
        _x.name = name;
        return _x;
    }

    /**
     * <i>“Regex string to do validation on the property value.”</i>
     * 
     * @return property propertyRegexConstraint
     */
    @Property(name="propertyRegexConstraint")
    @JsonIgnore
    public Optional<String> getPropertyRegexConstraint() {
        return Optional.ofNullable(propertyRegexConstraint);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * propertyRegexConstraint} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Regex string to do validation on the property value.”</i>
     * 
     * @param propertyRegexConstraint
     *            new value of {@code propertyRegexConstraint} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code propertyRegexConstraint} field changed
     */
    public AssignmentFilterSupportedProperty withPropertyRegexConstraint(String propertyRegexConstraint) {
        AssignmentFilterSupportedProperty _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentFilterSupportedProperty");
        _x.propertyRegexConstraint = propertyRegexConstraint;
        return _x;
    }

    /**
     * <i>“List of all supported operators on this property.”</i>
     * 
     * @return property supportedOperators
     */
    @Property(name="supportedOperators")
    @JsonIgnore
    public CollectionPage<AssignmentFilterOperator> getSupportedOperators() {
        return new CollectionPage<AssignmentFilterOperator>(contextPath, AssignmentFilterOperator.class, this.supportedOperators, Optional.ofNullable(supportedOperatorsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of all supported operators on this property.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property supportedOperators
     */
    @Property(name="supportedOperators")
    @JsonIgnore
    public CollectionPage<AssignmentFilterOperator> getSupportedOperators(HttpRequestOptions options) {
        return new CollectionPage<AssignmentFilterOperator>(contextPath, AssignmentFilterOperator.class, this.supportedOperators, Optional.ofNullable(supportedOperatorsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“List of all supported values for this propery, empty if everything is supported.”</i>
     * 
     * @return property supportedValues
     */
    @Property(name="supportedValues")
    @JsonIgnore
    public CollectionPage<String> getSupportedValues() {
        return new CollectionPage<String>(contextPath, String.class, this.supportedValues, Optional.ofNullable(supportedValuesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of all supported values for this propery, empty if everything is supported.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property supportedValues
     */
    @Property(name="supportedValues")
    @JsonIgnore
    public CollectionPage<String> getSupportedValues(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.supportedValues, Optional.ofNullable(supportedValuesNextLink), Collections.emptyList(), options);
    }

    public AssignmentFilterSupportedProperty withUnmappedField(String name, Object value) {
        AssignmentFilterSupportedProperty _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String dataType;
        private Boolean isCollection;
        private String name;
        private String propertyRegexConstraint;
        private List<AssignmentFilterOperator> supportedOperators;
        private String supportedOperatorsNextLink;
        private List<String> supportedValues;
        private String supportedValuesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The data type of the property.”</i>
         * 
         * @param dataType
         *            value of {@code dataType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dataType(String dataType) {
            this.dataType = dataType;
            this.changedFields = changedFields.add("dataType");
            return this;
        }

        /**
         * <i>“Indicates whether the property is a collection type or not.”</i>
         * 
         * @param isCollection
         *            value of {@code isCollection} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isCollection(Boolean isCollection) {
            this.isCollection = isCollection;
            this.changedFields = changedFields.add("isCollection");
            return this;
        }

        /**
         * <i>“Name of the property.”</i>
         * 
         * @param name
         *            value of {@code name} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        /**
         * <i>“Regex string to do validation on the property value.”</i>
         * 
         * @param propertyRegexConstraint
         *            value of {@code propertyRegexConstraint} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder propertyRegexConstraint(String propertyRegexConstraint) {
            this.propertyRegexConstraint = propertyRegexConstraint;
            this.changedFields = changedFields.add("propertyRegexConstraint");
            return this;
        }

        /**
         * <i>“List of all supported operators on this property.”</i>
         * 
         * @param supportedOperators
         *            value of {@code supportedOperators} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supportedOperators(List<AssignmentFilterOperator> supportedOperators) {
            this.supportedOperators = supportedOperators;
            this.changedFields = changedFields.add("supportedOperators");
            return this;
        }

        /**
         * <i>“List of all supported operators on this property.”</i>
         * 
         * @param supportedOperators
         *            value of {@code supportedOperators} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supportedOperators(AssignmentFilterOperator... supportedOperators) {
            return supportedOperators(Arrays.asList(supportedOperators));
        }

        /**
         * <i>“List of all supported operators on this property.”</i>
         * 
         * @param supportedOperatorsNextLink
         *            value of {@code supportedOperators@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supportedOperatorsNextLink(String supportedOperatorsNextLink) {
            this.supportedOperatorsNextLink = supportedOperatorsNextLink;
            this.changedFields = changedFields.add("supportedOperators");
            return this;
        }

        /**
         * <i>“List of all supported values for this propery, empty if everything is supported.”</i>
         * 
         * @param supportedValues
         *            value of {@code supportedValues} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supportedValues(List<String> supportedValues) {
            this.supportedValues = supportedValues;
            this.changedFields = changedFields.add("supportedValues");
            return this;
        }

        /**
         * <i>“List of all supported values for this propery, empty if everything is supported.”</i>
         * 
         * @param supportedValues
         *            value of {@code supportedValues} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supportedValues(String... supportedValues) {
            return supportedValues(Arrays.asList(supportedValues));
        }

        /**
         * <i>“List of all supported values for this propery, empty if everything is supported.”</i>
         * 
         * @param supportedValuesNextLink
         *            value of {@code supportedValues@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supportedValuesNextLink(String supportedValuesNextLink) {
            this.supportedValuesNextLink = supportedValuesNextLink;
            this.changedFields = changedFields.add("supportedValues");
            return this;
        }

        public AssignmentFilterSupportedProperty build() {
            AssignmentFilterSupportedProperty _x = new AssignmentFilterSupportedProperty();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.assignmentFilterSupportedProperty";
            _x.dataType = dataType;
            _x.isCollection = isCollection;
            _x.name = name;
            _x.propertyRegexConstraint = propertyRegexConstraint;
            _x.supportedOperators = supportedOperators;
            _x.supportedOperatorsNextLink = supportedOperatorsNextLink;
            _x.supportedValues = supportedValues;
            _x.supportedValuesNextLink = supportedValuesNextLink;
            return _x;
        }
    }

    private AssignmentFilterSupportedProperty _copy() {
        AssignmentFilterSupportedProperty _x = new AssignmentFilterSupportedProperty();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.dataType = dataType;
        _x.isCollection = isCollection;
        _x.name = name;
        _x.propertyRegexConstraint = propertyRegexConstraint;
        _x.supportedOperators = supportedOperators;
        _x.supportedValues = supportedValues;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AssignmentFilterSupportedProperty[");
        b.append("dataType=");
        b.append(this.dataType);
        b.append(", ");
        b.append("isCollection=");
        b.append(this.isCollection);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("propertyRegexConstraint=");
        b.append(this.propertyRegexConstraint);
        b.append(", ");
        b.append("supportedOperators=");
        b.append(this.supportedOperators);
        b.append(", ");
        b.append("supportedValues=");
        b.append(this.supportedValues);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
