package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AssignmentFilterEvaluationResult;
import odata.msgraph.client.beta.enums.DeviceAndAppManagementAssignmentFilterType;
import odata.msgraph.client.beta.enums.DevicePlatformType;


/**
 * <i>“Represent result summary for assignment filter evaluation”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "assignmentFilterDisplayName", 
    "assignmentFilterId", 
    "assignmentFilterLastModifiedDateTime", 
    "assignmentFilterPlatform", 
    "assignmentFilterType", 
    "assignmentFilterTypeAndEvaluationResults", 
    "evaluationDateTime", 
    "evaluationResult"})
@JsonInclude(Include.NON_NULL)
public class AssignmentFilterEvaluationSummary implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("assignmentFilterDisplayName")
    protected String assignmentFilterDisplayName;

    @JsonProperty("assignmentFilterId")
    protected String assignmentFilterId;

    @JsonProperty("assignmentFilterLastModifiedDateTime")
    protected OffsetDateTime assignmentFilterLastModifiedDateTime;

    @JsonProperty("assignmentFilterPlatform")
    protected DevicePlatformType assignmentFilterPlatform;

    @JsonProperty("assignmentFilterType")
    protected DeviceAndAppManagementAssignmentFilterType assignmentFilterType;

    @JsonProperty("assignmentFilterTypeAndEvaluationResults")
    protected List<AssignmentFilterTypeAndEvaluationResult> assignmentFilterTypeAndEvaluationResults;

    @JsonProperty("assignmentFilterTypeAndEvaluationResults@nextLink")
    protected String assignmentFilterTypeAndEvaluationResultsNextLink;

    @JsonProperty("evaluationDateTime")
    protected OffsetDateTime evaluationDateTime;

    @JsonProperty("evaluationResult")
    protected AssignmentFilterEvaluationResult evaluationResult;

    protected AssignmentFilterEvaluationSummary() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.assignmentFilterEvaluationSummary";
    }

    /**
     * <i>“The admin defined name for assignment filter.”</i>
     * 
     * @return property assignmentFilterDisplayName
     */
    @Property(name="assignmentFilterDisplayName")
    @JsonIgnore
    public Optional<String> getAssignmentFilterDisplayName() {
        return Optional.ofNullable(assignmentFilterDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * assignmentFilterDisplayName} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The admin defined name for assignment filter.”</i>
     * 
     * @param assignmentFilterDisplayName
     *            new value of {@code assignmentFilterDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assignmentFilterDisplayName} field changed
     */
    public AssignmentFilterEvaluationSummary withAssignmentFilterDisplayName(String assignmentFilterDisplayName) {
        AssignmentFilterEvaluationSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentFilterEvaluationSummary");
        _x.assignmentFilterDisplayName = assignmentFilterDisplayName;
        return _x;
    }

    /**
     * <i>“Unique identifier for the assignment filter object”</i>
     * 
     * @return property assignmentFilterId
     */
    @Property(name="assignmentFilterId")
    @JsonIgnore
    public Optional<String> getAssignmentFilterId() {
        return Optional.ofNullable(assignmentFilterId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * assignmentFilterId} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Unique identifier for the assignment filter object”</i>
     * 
     * @param assignmentFilterId
     *            new value of {@code assignmentFilterId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assignmentFilterId} field changed
     */
    public AssignmentFilterEvaluationSummary withAssignmentFilterId(String assignmentFilterId) {
        AssignmentFilterEvaluationSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentFilterEvaluationSummary");
        _x.assignmentFilterId = assignmentFilterId;
        return _x;
    }

    /**
     * <i>“The time the assignment filter was last modified.”</i>
     * 
     * @return property assignmentFilterLastModifiedDateTime
     */
    @Property(name="assignmentFilterLastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getAssignmentFilterLastModifiedDateTime() {
        return Optional.ofNullable(assignmentFilterLastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * assignmentFilterLastModifiedDateTime} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The time the assignment filter was last modified.”</i>
     * 
     * @param assignmentFilterLastModifiedDateTime
     *            new value of {@code assignmentFilterLastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assignmentFilterLastModifiedDateTime} field changed
     */
    public AssignmentFilterEvaluationSummary withAssignmentFilterLastModifiedDateTime(OffsetDateTime assignmentFilterLastModifiedDateTime) {
        AssignmentFilterEvaluationSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentFilterEvaluationSummary");
        _x.assignmentFilterLastModifiedDateTime = assignmentFilterLastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“The platform for which this assignment filter is created.”</i>
     * 
     * @return property assignmentFilterPlatform
     */
    @Property(name="assignmentFilterPlatform")
    @JsonIgnore
    public Optional<DevicePlatformType> getAssignmentFilterPlatform() {
        return Optional.ofNullable(assignmentFilterPlatform);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * assignmentFilterPlatform} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The platform for which this assignment filter is created.”</i>
     * 
     * @param assignmentFilterPlatform
     *            new value of {@code assignmentFilterPlatform} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assignmentFilterPlatform} field changed
     */
    public AssignmentFilterEvaluationSummary withAssignmentFilterPlatform(DevicePlatformType assignmentFilterPlatform) {
        AssignmentFilterEvaluationSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentFilterEvaluationSummary");
        _x.assignmentFilterPlatform = assignmentFilterPlatform;
        return _x;
    }

    /**
     * <i>“Indicate filter type either include or exclude.”</i>
     * 
     * @return property assignmentFilterType
     */
    @Property(name="assignmentFilterType")
    @JsonIgnore
    public Optional<DeviceAndAppManagementAssignmentFilterType> getAssignmentFilterType() {
        return Optional.ofNullable(assignmentFilterType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * assignmentFilterType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicate filter type either include or exclude.”</i>
     * 
     * @param assignmentFilterType
     *            new value of {@code assignmentFilterType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assignmentFilterType} field changed
     */
    public AssignmentFilterEvaluationSummary withAssignmentFilterType(DeviceAndAppManagementAssignmentFilterType assignmentFilterType) {
        AssignmentFilterEvaluationSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentFilterEvaluationSummary");
        _x.assignmentFilterType = assignmentFilterType;
        return _x;
    }

    /**
     * <i>“A collection of filter types and their corresponding evaluation results.”</i>
     * 
     * @return property assignmentFilterTypeAndEvaluationResults
     */
    @Property(name="assignmentFilterTypeAndEvaluationResults")
    @JsonIgnore
    public CollectionPage<AssignmentFilterTypeAndEvaluationResult> getAssignmentFilterTypeAndEvaluationResults() {
        return new CollectionPage<AssignmentFilterTypeAndEvaluationResult>(contextPath, AssignmentFilterTypeAndEvaluationResult.class, this.assignmentFilterTypeAndEvaluationResults, Optional.ofNullable(assignmentFilterTypeAndEvaluationResultsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“A collection of filter types and their corresponding evaluation results.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property assignmentFilterTypeAndEvaluationResults
     */
    @Property(name="assignmentFilterTypeAndEvaluationResults")
    @JsonIgnore
    public CollectionPage<AssignmentFilterTypeAndEvaluationResult> getAssignmentFilterTypeAndEvaluationResults(HttpRequestOptions options) {
        return new CollectionPage<AssignmentFilterTypeAndEvaluationResult>(contextPath, AssignmentFilterTypeAndEvaluationResult.class, this.assignmentFilterTypeAndEvaluationResults, Optional.ofNullable(assignmentFilterTypeAndEvaluationResultsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The time assignment filter was evaluated.”</i>
     * 
     * @return property evaluationDateTime
     */
    @Property(name="evaluationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEvaluationDateTime() {
        return Optional.ofNullable(evaluationDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * evaluationDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The time assignment filter was evaluated.”</i>
     * 
     * @param evaluationDateTime
     *            new value of {@code evaluationDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code evaluationDateTime} field changed
     */
    public AssignmentFilterEvaluationSummary withEvaluationDateTime(OffsetDateTime evaluationDateTime) {
        AssignmentFilterEvaluationSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentFilterEvaluationSummary");
        _x.evaluationDateTime = evaluationDateTime;
        return _x;
    }

    /**
     * <i>“Assignment filter evaluation result.”</i>
     * 
     * @return property evaluationResult
     */
    @Property(name="evaluationResult")
    @JsonIgnore
    public Optional<AssignmentFilterEvaluationResult> getEvaluationResult() {
        return Optional.ofNullable(evaluationResult);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code evaluationResult}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Assignment filter evaluation result.”</i>
     * 
     * @param evaluationResult
     *            new value of {@code evaluationResult} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code evaluationResult} field changed
     */
    public AssignmentFilterEvaluationSummary withEvaluationResult(AssignmentFilterEvaluationResult evaluationResult) {
        AssignmentFilterEvaluationSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentFilterEvaluationSummary");
        _x.evaluationResult = evaluationResult;
        return _x;
    }

    public AssignmentFilterEvaluationSummary withUnmappedField(String name, Object value) {
        AssignmentFilterEvaluationSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String assignmentFilterDisplayName;
        private String assignmentFilterId;
        private OffsetDateTime assignmentFilterLastModifiedDateTime;
        private DevicePlatformType assignmentFilterPlatform;
        private DeviceAndAppManagementAssignmentFilterType assignmentFilterType;
        private List<AssignmentFilterTypeAndEvaluationResult> assignmentFilterTypeAndEvaluationResults;
        private String assignmentFilterTypeAndEvaluationResultsNextLink;
        private OffsetDateTime evaluationDateTime;
        private AssignmentFilterEvaluationResult evaluationResult;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The admin defined name for assignment filter.”</i>
         * 
         * @param assignmentFilterDisplayName
         *            value of {@code assignmentFilterDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignmentFilterDisplayName(String assignmentFilterDisplayName) {
            this.assignmentFilterDisplayName = assignmentFilterDisplayName;
            this.changedFields = changedFields.add("assignmentFilterDisplayName");
            return this;
        }

        /**
         * <i>“Unique identifier for the assignment filter object”</i>
         * 
         * @param assignmentFilterId
         *            value of {@code assignmentFilterId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignmentFilterId(String assignmentFilterId) {
            this.assignmentFilterId = assignmentFilterId;
            this.changedFields = changedFields.add("assignmentFilterId");
            return this;
        }

        /**
         * <i>“The time the assignment filter was last modified.”</i>
         * 
         * @param assignmentFilterLastModifiedDateTime
         *            value of {@code assignmentFilterLastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignmentFilterLastModifiedDateTime(OffsetDateTime assignmentFilterLastModifiedDateTime) {
            this.assignmentFilterLastModifiedDateTime = assignmentFilterLastModifiedDateTime;
            this.changedFields = changedFields.add("assignmentFilterLastModifiedDateTime");
            return this;
        }

        /**
         * <i>“The platform for which this assignment filter is created.”</i>
         * 
         * @param assignmentFilterPlatform
         *            value of {@code assignmentFilterPlatform} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignmentFilterPlatform(DevicePlatformType assignmentFilterPlatform) {
            this.assignmentFilterPlatform = assignmentFilterPlatform;
            this.changedFields = changedFields.add("assignmentFilterPlatform");
            return this;
        }

        /**
         * <i>“Indicate filter type either include or exclude.”</i>
         * 
         * @param assignmentFilterType
         *            value of {@code assignmentFilterType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignmentFilterType(DeviceAndAppManagementAssignmentFilterType assignmentFilterType) {
            this.assignmentFilterType = assignmentFilterType;
            this.changedFields = changedFields.add("assignmentFilterType");
            return this;
        }

        /**
         * <i>“A collection of filter types and their corresponding evaluation results.”</i>
         * 
         * @param assignmentFilterTypeAndEvaluationResults
         *            value of {@code assignmentFilterTypeAndEvaluationResults} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignmentFilterTypeAndEvaluationResults(List<AssignmentFilterTypeAndEvaluationResult> assignmentFilterTypeAndEvaluationResults) {
            this.assignmentFilterTypeAndEvaluationResults = assignmentFilterTypeAndEvaluationResults;
            this.changedFields = changedFields.add("assignmentFilterTypeAndEvaluationResults");
            return this;
        }

        /**
         * <i>“A collection of filter types and their corresponding evaluation results.”</i>
         * 
         * @param assignmentFilterTypeAndEvaluationResults
         *            value of {@code assignmentFilterTypeAndEvaluationResults} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignmentFilterTypeAndEvaluationResults(AssignmentFilterTypeAndEvaluationResult... assignmentFilterTypeAndEvaluationResults) {
            return assignmentFilterTypeAndEvaluationResults(Arrays.asList(assignmentFilterTypeAndEvaluationResults));
        }

        /**
         * <i>“A collection of filter types and their corresponding evaluation results.”</i>
         * 
         * @param assignmentFilterTypeAndEvaluationResultsNextLink
         *            value of {@code assignmentFilterTypeAndEvaluationResults@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignmentFilterTypeAndEvaluationResultsNextLink(String assignmentFilterTypeAndEvaluationResultsNextLink) {
            this.assignmentFilterTypeAndEvaluationResultsNextLink = assignmentFilterTypeAndEvaluationResultsNextLink;
            this.changedFields = changedFields.add("assignmentFilterTypeAndEvaluationResults");
            return this;
        }

        /**
         * <i>“The time assignment filter was evaluated.”</i>
         * 
         * @param evaluationDateTime
         *            value of {@code evaluationDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder evaluationDateTime(OffsetDateTime evaluationDateTime) {
            this.evaluationDateTime = evaluationDateTime;
            this.changedFields = changedFields.add("evaluationDateTime");
            return this;
        }

        /**
         * <i>“Assignment filter evaluation result.”</i>
         * 
         * @param evaluationResult
         *            value of {@code evaluationResult} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder evaluationResult(AssignmentFilterEvaluationResult evaluationResult) {
            this.evaluationResult = evaluationResult;
            this.changedFields = changedFields.add("evaluationResult");
            return this;
        }

        public AssignmentFilterEvaluationSummary build() {
            AssignmentFilterEvaluationSummary _x = new AssignmentFilterEvaluationSummary();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.assignmentFilterEvaluationSummary";
            _x.assignmentFilterDisplayName = assignmentFilterDisplayName;
            _x.assignmentFilterId = assignmentFilterId;
            _x.assignmentFilterLastModifiedDateTime = assignmentFilterLastModifiedDateTime;
            _x.assignmentFilterPlatform = assignmentFilterPlatform;
            _x.assignmentFilterType = assignmentFilterType;
            _x.assignmentFilterTypeAndEvaluationResults = assignmentFilterTypeAndEvaluationResults;
            _x.assignmentFilterTypeAndEvaluationResultsNextLink = assignmentFilterTypeAndEvaluationResultsNextLink;
            _x.evaluationDateTime = evaluationDateTime;
            _x.evaluationResult = evaluationResult;
            return _x;
        }
    }

    private AssignmentFilterEvaluationSummary _copy() {
        AssignmentFilterEvaluationSummary _x = new AssignmentFilterEvaluationSummary();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.assignmentFilterDisplayName = assignmentFilterDisplayName;
        _x.assignmentFilterId = assignmentFilterId;
        _x.assignmentFilterLastModifiedDateTime = assignmentFilterLastModifiedDateTime;
        _x.assignmentFilterPlatform = assignmentFilterPlatform;
        _x.assignmentFilterType = assignmentFilterType;
        _x.assignmentFilterTypeAndEvaluationResults = assignmentFilterTypeAndEvaluationResults;
        _x.evaluationDateTime = evaluationDateTime;
        _x.evaluationResult = evaluationResult;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AssignmentFilterEvaluationSummary[");
        b.append("assignmentFilterDisplayName=");
        b.append(this.assignmentFilterDisplayName);
        b.append(", ");
        b.append("assignmentFilterId=");
        b.append(this.assignmentFilterId);
        b.append(", ");
        b.append("assignmentFilterLastModifiedDateTime=");
        b.append(this.assignmentFilterLastModifiedDateTime);
        b.append(", ");
        b.append("assignmentFilterPlatform=");
        b.append(this.assignmentFilterPlatform);
        b.append(", ");
        b.append("assignmentFilterType=");
        b.append(this.assignmentFilterType);
        b.append(", ");
        b.append("assignmentFilterTypeAndEvaluationResults=");
        b.append(this.assignmentFilterTypeAndEvaluationResults);
        b.append(", ");
        b.append("evaluationDateTime=");
        b.append(this.evaluationDateTime);
        b.append(", ");
        b.append("evaluationResult=");
        b.append(this.evaluationResult);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
