package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "assignedUserCount", 
    "completedUserCount", 
    "displayName"})
@JsonInclude(Include.NON_NULL)
public class AssignedTrainingInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("assignedUserCount")
    protected Integer assignedUserCount;

    @JsonProperty("completedUserCount")
    protected Integer completedUserCount;

    @JsonProperty("displayName")
    protected String displayName;

    protected AssignedTrainingInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.assignedTrainingInfo";
    }

    @Property(name="assignedUserCount")
    @JsonIgnore
    public Optional<Integer> getAssignedUserCount() {
        return Optional.ofNullable(assignedUserCount);
    }

    public AssignedTrainingInfo withAssignedUserCount(Integer assignedUserCount) {
        AssignedTrainingInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignedTrainingInfo");
        _x.assignedUserCount = assignedUserCount;
        return _x;
    }

    @Property(name="completedUserCount")
    @JsonIgnore
    public Optional<Integer> getCompletedUserCount() {
        return Optional.ofNullable(completedUserCount);
    }

    public AssignedTrainingInfo withCompletedUserCount(Integer completedUserCount) {
        AssignedTrainingInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignedTrainingInfo");
        _x.completedUserCount = completedUserCount;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public AssignedTrainingInfo withDisplayName(String displayName) {
        AssignedTrainingInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignedTrainingInfo");
        _x.displayName = displayName;
        return _x;
    }

    public AssignedTrainingInfo withUnmappedField(String name, Object value) {
        AssignedTrainingInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer assignedUserCount;
        private Integer completedUserCount;
        private String displayName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder assignedUserCount(Integer assignedUserCount) {
            this.assignedUserCount = assignedUserCount;
            this.changedFields = changedFields.add("assignedUserCount");
            return this;
        }

        public Builder completedUserCount(Integer completedUserCount) {
            this.completedUserCount = completedUserCount;
            this.changedFields = changedFields.add("completedUserCount");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public AssignedTrainingInfo build() {
            AssignedTrainingInfo _x = new AssignedTrainingInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.assignedTrainingInfo";
            _x.assignedUserCount = assignedUserCount;
            _x.completedUserCount = completedUserCount;
            _x.displayName = displayName;
            return _x;
        }
    }

    private AssignedTrainingInfo _copy() {
        AssignedTrainingInfo _x = new AssignedTrainingInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.assignedUserCount = assignedUserCount;
        _x.completedUserCount = completedUserCount;
        _x.displayName = displayName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AssignedTrainingInfo[");
        b.append("assignedUserCount=");
        b.append(this.assignedUserCount);
        b.append(", ");
        b.append("completedUserCount=");
        b.append(this.completedUserCount);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
