package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.PrintJobProcessingState;

@JsonPropertyOrder({
    "@odata.type", 
    "acquiredByPrinter", 
    "acquiredDateTime", 
    "blackAndWhitePageCount", 
    "colorPageCount", 
    "completionDateTime", 
    "copiesPrinted", 
    "createdBy", 
    "createdDateTime", 
    "duplexPageCount", 
    "id", 
    "pageCount", 
    "printerId", 
    "processingState", 
    "simplexPageCount"})
@JsonInclude(Include.NON_NULL)
public class ArchivedPrintJob implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("acquiredByPrinter")
    protected Boolean acquiredByPrinter;

    @JsonProperty("acquiredDateTime")
    protected OffsetDateTime acquiredDateTime;

    @JsonProperty("blackAndWhitePageCount")
    protected Integer blackAndWhitePageCount;

    @JsonProperty("colorPageCount")
    protected Integer colorPageCount;

    @JsonProperty("completionDateTime")
    protected OffsetDateTime completionDateTime;

    @JsonProperty("copiesPrinted")
    protected Integer copiesPrinted;

    @JsonProperty("createdBy")
    protected UserIdentity createdBy;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("duplexPageCount")
    protected Integer duplexPageCount;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("pageCount")
    protected Integer pageCount;

    @JsonProperty("printerId")
    protected String printerId;

    @JsonProperty("processingState")
    protected PrintJobProcessingState processingState;

    @JsonProperty("simplexPageCount")
    protected Integer simplexPageCount;

    protected ArchivedPrintJob() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.archivedPrintJob";
    }

    @Property(name="acquiredByPrinter")
    @JsonIgnore
    public Optional<Boolean> getAcquiredByPrinter() {
        return Optional.ofNullable(acquiredByPrinter);
    }

    public ArchivedPrintJob withAcquiredByPrinter(Boolean acquiredByPrinter) {
        ArchivedPrintJob _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.archivedPrintJob");
        _x.acquiredByPrinter = acquiredByPrinter;
        return _x;
    }

    @Property(name="acquiredDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getAcquiredDateTime() {
        return Optional.ofNullable(acquiredDateTime);
    }

    public ArchivedPrintJob withAcquiredDateTime(OffsetDateTime acquiredDateTime) {
        ArchivedPrintJob _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.archivedPrintJob");
        _x.acquiredDateTime = acquiredDateTime;
        return _x;
    }

    @Property(name="blackAndWhitePageCount")
    @JsonIgnore
    public Optional<Integer> getBlackAndWhitePageCount() {
        return Optional.ofNullable(blackAndWhitePageCount);
    }

    public ArchivedPrintJob withBlackAndWhitePageCount(Integer blackAndWhitePageCount) {
        ArchivedPrintJob _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.archivedPrintJob");
        _x.blackAndWhitePageCount = blackAndWhitePageCount;
        return _x;
    }

    @Property(name="colorPageCount")
    @JsonIgnore
    public Optional<Integer> getColorPageCount() {
        return Optional.ofNullable(colorPageCount);
    }

    public ArchivedPrintJob withColorPageCount(Integer colorPageCount) {
        ArchivedPrintJob _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.archivedPrintJob");
        _x.colorPageCount = colorPageCount;
        return _x;
    }

    @Property(name="completionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCompletionDateTime() {
        return Optional.ofNullable(completionDateTime);
    }

    public ArchivedPrintJob withCompletionDateTime(OffsetDateTime completionDateTime) {
        ArchivedPrintJob _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.archivedPrintJob");
        _x.completionDateTime = completionDateTime;
        return _x;
    }

    @Property(name="copiesPrinted")
    @JsonIgnore
    public Optional<Integer> getCopiesPrinted() {
        return Optional.ofNullable(copiesPrinted);
    }

    public ArchivedPrintJob withCopiesPrinted(Integer copiesPrinted) {
        ArchivedPrintJob _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.archivedPrintJob");
        _x.copiesPrinted = copiesPrinted;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<UserIdentity> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public ArchivedPrintJob withCreatedBy(UserIdentity createdBy) {
        ArchivedPrintJob _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.archivedPrintJob");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public ArchivedPrintJob withCreatedDateTime(OffsetDateTime createdDateTime) {
        ArchivedPrintJob _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.archivedPrintJob");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="duplexPageCount")
    @JsonIgnore
    public Optional<Integer> getDuplexPageCount() {
        return Optional.ofNullable(duplexPageCount);
    }

    public ArchivedPrintJob withDuplexPageCount(Integer duplexPageCount) {
        ArchivedPrintJob _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.archivedPrintJob");
        _x.duplexPageCount = duplexPageCount;
        return _x;
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public ArchivedPrintJob withId(String id) {
        ArchivedPrintJob _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.archivedPrintJob");
        _x.id = id;
        return _x;
    }

    @Property(name="pageCount")
    @JsonIgnore
    public Optional<Integer> getPageCount() {
        return Optional.ofNullable(pageCount);
    }

    public ArchivedPrintJob withPageCount(Integer pageCount) {
        ArchivedPrintJob _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.archivedPrintJob");
        _x.pageCount = pageCount;
        return _x;
    }

    @Property(name="printerId")
    @JsonIgnore
    public Optional<String> getPrinterId() {
        return Optional.ofNullable(printerId);
    }

    public ArchivedPrintJob withPrinterId(String printerId) {
        ArchivedPrintJob _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.archivedPrintJob");
        _x.printerId = printerId;
        return _x;
    }

    @Property(name="processingState")
    @JsonIgnore
    public Optional<PrintJobProcessingState> getProcessingState() {
        return Optional.ofNullable(processingState);
    }

    public ArchivedPrintJob withProcessingState(PrintJobProcessingState processingState) {
        ArchivedPrintJob _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.archivedPrintJob");
        _x.processingState = processingState;
        return _x;
    }

    @Property(name="simplexPageCount")
    @JsonIgnore
    public Optional<Integer> getSimplexPageCount() {
        return Optional.ofNullable(simplexPageCount);
    }

    public ArchivedPrintJob withSimplexPageCount(Integer simplexPageCount) {
        ArchivedPrintJob _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.archivedPrintJob");
        _x.simplexPageCount = simplexPageCount;
        return _x;
    }

    public ArchivedPrintJob withUnmappedField(String name, Object value) {
        ArchivedPrintJob _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean acquiredByPrinter;
        private OffsetDateTime acquiredDateTime;
        private Integer blackAndWhitePageCount;
        private Integer colorPageCount;
        private OffsetDateTime completionDateTime;
        private Integer copiesPrinted;
        private UserIdentity createdBy;
        private OffsetDateTime createdDateTime;
        private Integer duplexPageCount;
        private String id;
        private Integer pageCount;
        private String printerId;
        private PrintJobProcessingState processingState;
        private Integer simplexPageCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder acquiredByPrinter(Boolean acquiredByPrinter) {
            this.acquiredByPrinter = acquiredByPrinter;
            this.changedFields = changedFields.add("acquiredByPrinter");
            return this;
        }

        public Builder acquiredDateTime(OffsetDateTime acquiredDateTime) {
            this.acquiredDateTime = acquiredDateTime;
            this.changedFields = changedFields.add("acquiredDateTime");
            return this;
        }

        public Builder blackAndWhitePageCount(Integer blackAndWhitePageCount) {
            this.blackAndWhitePageCount = blackAndWhitePageCount;
            this.changedFields = changedFields.add("blackAndWhitePageCount");
            return this;
        }

        public Builder colorPageCount(Integer colorPageCount) {
            this.colorPageCount = colorPageCount;
            this.changedFields = changedFields.add("colorPageCount");
            return this;
        }

        public Builder completionDateTime(OffsetDateTime completionDateTime) {
            this.completionDateTime = completionDateTime;
            this.changedFields = changedFields.add("completionDateTime");
            return this;
        }

        public Builder copiesPrinted(Integer copiesPrinted) {
            this.copiesPrinted = copiesPrinted;
            this.changedFields = changedFields.add("copiesPrinted");
            return this;
        }

        public Builder createdBy(UserIdentity createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder duplexPageCount(Integer duplexPageCount) {
            this.duplexPageCount = duplexPageCount;
            this.changedFields = changedFields.add("duplexPageCount");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder pageCount(Integer pageCount) {
            this.pageCount = pageCount;
            this.changedFields = changedFields.add("pageCount");
            return this;
        }

        public Builder printerId(String printerId) {
            this.printerId = printerId;
            this.changedFields = changedFields.add("printerId");
            return this;
        }

        public Builder processingState(PrintJobProcessingState processingState) {
            this.processingState = processingState;
            this.changedFields = changedFields.add("processingState");
            return this;
        }

        public Builder simplexPageCount(Integer simplexPageCount) {
            this.simplexPageCount = simplexPageCount;
            this.changedFields = changedFields.add("simplexPageCount");
            return this;
        }

        public ArchivedPrintJob build() {
            ArchivedPrintJob _x = new ArchivedPrintJob();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.archivedPrintJob";
            _x.acquiredByPrinter = acquiredByPrinter;
            _x.acquiredDateTime = acquiredDateTime;
            _x.blackAndWhitePageCount = blackAndWhitePageCount;
            _x.colorPageCount = colorPageCount;
            _x.completionDateTime = completionDateTime;
            _x.copiesPrinted = copiesPrinted;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.duplexPageCount = duplexPageCount;
            _x.id = id;
            _x.pageCount = pageCount;
            _x.printerId = printerId;
            _x.processingState = processingState;
            _x.simplexPageCount = simplexPageCount;
            return _x;
        }
    }

    private ArchivedPrintJob _copy() {
        ArchivedPrintJob _x = new ArchivedPrintJob();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.acquiredByPrinter = acquiredByPrinter;
        _x.acquiredDateTime = acquiredDateTime;
        _x.blackAndWhitePageCount = blackAndWhitePageCount;
        _x.colorPageCount = colorPageCount;
        _x.completionDateTime = completionDateTime;
        _x.copiesPrinted = copiesPrinted;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.duplexPageCount = duplexPageCount;
        _x.id = id;
        _x.pageCount = pageCount;
        _x.printerId = printerId;
        _x.processingState = processingState;
        _x.simplexPageCount = simplexPageCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ArchivedPrintJob[");
        b.append("acquiredByPrinter=");
        b.append(this.acquiredByPrinter);
        b.append(", ");
        b.append("acquiredDateTime=");
        b.append(this.acquiredDateTime);
        b.append(", ");
        b.append("blackAndWhitePageCount=");
        b.append(this.blackAndWhitePageCount);
        b.append(", ");
        b.append("colorPageCount=");
        b.append(this.colorPageCount);
        b.append(", ");
        b.append("completionDateTime=");
        b.append(this.completionDateTime);
        b.append(", ");
        b.append("copiesPrinted=");
        b.append(this.copiesPrinted);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("duplexPageCount=");
        b.append(this.duplexPageCount);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("pageCount=");
        b.append(this.pageCount);
        b.append(", ");
        b.append("printerId=");
        b.append(this.printerId);
        b.append(", ");
        b.append("processingState=");
        b.append(this.processingState);
        b.append(", ");
        b.append("simplexPageCount=");
        b.append(this.simplexPageCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
