package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AppliedConditionalAccessPolicyResult;
import odata.msgraph.client.beta.enums.ConditionalAccessConditions;

@JsonPropertyOrder({
    "@odata.type", 
    "authenticationStrength", 
    "conditionsNotSatisfied", 
    "conditionsSatisfied", 
    "displayName", 
    "enforcedGrantControls", 
    "enforcedSessionControls", 
    "excludeRulesSatisfied", 
    "id", 
    "includeRulesSatisfied", 
    "result"})
@JsonInclude(Include.NON_NULL)
public class AppliedConditionalAccessPolicy implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("authenticationStrength")
    protected AuthenticationStrength authenticationStrength;

    @JsonProperty("conditionsNotSatisfied")
    protected ConditionalAccessConditions conditionsNotSatisfied;

    @JsonProperty("conditionsSatisfied")
    protected ConditionalAccessConditions conditionsSatisfied;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("enforcedGrantControls")
    protected List<String> enforcedGrantControls;

    @JsonProperty("enforcedGrantControls@nextLink")
    protected String enforcedGrantControlsNextLink;

    @JsonProperty("enforcedSessionControls")
    protected List<String> enforcedSessionControls;

    @JsonProperty("enforcedSessionControls@nextLink")
    protected String enforcedSessionControlsNextLink;

    @JsonProperty("excludeRulesSatisfied")
    protected List<ConditionalAccessRuleSatisfied> excludeRulesSatisfied;

    @JsonProperty("excludeRulesSatisfied@nextLink")
    protected String excludeRulesSatisfiedNextLink;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("includeRulesSatisfied")
    protected List<ConditionalAccessRuleSatisfied> includeRulesSatisfied;

    @JsonProperty("includeRulesSatisfied@nextLink")
    protected String includeRulesSatisfiedNextLink;

    @JsonProperty("result")
    protected AppliedConditionalAccessPolicyResult result;

    protected AppliedConditionalAccessPolicy() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.appliedConditionalAccessPolicy";
    }

    @Property(name="authenticationStrength")
    @JsonIgnore
    public Optional<AuthenticationStrength> getAuthenticationStrength() {
        return Optional.ofNullable(authenticationStrength);
    }

    public AppliedConditionalAccessPolicy withAuthenticationStrength(AuthenticationStrength authenticationStrength) {
        AppliedConditionalAccessPolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appliedConditionalAccessPolicy");
        _x.authenticationStrength = authenticationStrength;
        return _x;
    }

    @Property(name="conditionsNotSatisfied")
    @JsonIgnore
    public Optional<ConditionalAccessConditions> getConditionsNotSatisfied() {
        return Optional.ofNullable(conditionsNotSatisfied);
    }

    public AppliedConditionalAccessPolicy withConditionsNotSatisfied(ConditionalAccessConditions conditionsNotSatisfied) {
        AppliedConditionalAccessPolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appliedConditionalAccessPolicy");
        _x.conditionsNotSatisfied = conditionsNotSatisfied;
        return _x;
    }

    @Property(name="conditionsSatisfied")
    @JsonIgnore
    public Optional<ConditionalAccessConditions> getConditionsSatisfied() {
        return Optional.ofNullable(conditionsSatisfied);
    }

    public AppliedConditionalAccessPolicy withConditionsSatisfied(ConditionalAccessConditions conditionsSatisfied) {
        AppliedConditionalAccessPolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appliedConditionalAccessPolicy");
        _x.conditionsSatisfied = conditionsSatisfied;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public AppliedConditionalAccessPolicy withDisplayName(String displayName) {
        AppliedConditionalAccessPolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appliedConditionalAccessPolicy");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="enforcedGrantControls")
    @JsonIgnore
    public CollectionPage<String> getEnforcedGrantControls() {
        return new CollectionPage<String>(contextPath, String.class, this.enforcedGrantControls, Optional.ofNullable(enforcedGrantControlsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="enforcedGrantControls")
    @JsonIgnore
    public CollectionPage<String> getEnforcedGrantControls(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.enforcedGrantControls, Optional.ofNullable(enforcedGrantControlsNextLink), Collections.emptyList(), options);
    }

    @Property(name="enforcedSessionControls")
    @JsonIgnore
    public CollectionPage<String> getEnforcedSessionControls() {
        return new CollectionPage<String>(contextPath, String.class, this.enforcedSessionControls, Optional.ofNullable(enforcedSessionControlsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="enforcedSessionControls")
    @JsonIgnore
    public CollectionPage<String> getEnforcedSessionControls(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.enforcedSessionControls, Optional.ofNullable(enforcedSessionControlsNextLink), Collections.emptyList(), options);
    }

    @Property(name="excludeRulesSatisfied")
    @JsonIgnore
    public CollectionPage<ConditionalAccessRuleSatisfied> getExcludeRulesSatisfied() {
        return new CollectionPage<ConditionalAccessRuleSatisfied>(contextPath, ConditionalAccessRuleSatisfied.class, this.excludeRulesSatisfied, Optional.ofNullable(excludeRulesSatisfiedNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="excludeRulesSatisfied")
    @JsonIgnore
    public CollectionPage<ConditionalAccessRuleSatisfied> getExcludeRulesSatisfied(HttpRequestOptions options) {
        return new CollectionPage<ConditionalAccessRuleSatisfied>(contextPath, ConditionalAccessRuleSatisfied.class, this.excludeRulesSatisfied, Optional.ofNullable(excludeRulesSatisfiedNextLink), Collections.emptyList(), options);
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public AppliedConditionalAccessPolicy withId(String id) {
        AppliedConditionalAccessPolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appliedConditionalAccessPolicy");
        _x.id = id;
        return _x;
    }

    @Property(name="includeRulesSatisfied")
    @JsonIgnore
    public CollectionPage<ConditionalAccessRuleSatisfied> getIncludeRulesSatisfied() {
        return new CollectionPage<ConditionalAccessRuleSatisfied>(contextPath, ConditionalAccessRuleSatisfied.class, this.includeRulesSatisfied, Optional.ofNullable(includeRulesSatisfiedNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="includeRulesSatisfied")
    @JsonIgnore
    public CollectionPage<ConditionalAccessRuleSatisfied> getIncludeRulesSatisfied(HttpRequestOptions options) {
        return new CollectionPage<ConditionalAccessRuleSatisfied>(contextPath, ConditionalAccessRuleSatisfied.class, this.includeRulesSatisfied, Optional.ofNullable(includeRulesSatisfiedNextLink), Collections.emptyList(), options);
    }

    @Property(name="result")
    @JsonIgnore
    public Optional<AppliedConditionalAccessPolicyResult> getResult() {
        return Optional.ofNullable(result);
    }

    public AppliedConditionalAccessPolicy withResult(AppliedConditionalAccessPolicyResult result) {
        AppliedConditionalAccessPolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appliedConditionalAccessPolicy");
        _x.result = result;
        return _x;
    }

    public AppliedConditionalAccessPolicy withUnmappedField(String name, Object value) {
        AppliedConditionalAccessPolicy _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AuthenticationStrength authenticationStrength;
        private ConditionalAccessConditions conditionsNotSatisfied;
        private ConditionalAccessConditions conditionsSatisfied;
        private String displayName;
        private List<String> enforcedGrantControls;
        private String enforcedGrantControlsNextLink;
        private List<String> enforcedSessionControls;
        private String enforcedSessionControlsNextLink;
        private List<ConditionalAccessRuleSatisfied> excludeRulesSatisfied;
        private String excludeRulesSatisfiedNextLink;
        private String id;
        private List<ConditionalAccessRuleSatisfied> includeRulesSatisfied;
        private String includeRulesSatisfiedNextLink;
        private AppliedConditionalAccessPolicyResult result;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder authenticationStrength(AuthenticationStrength authenticationStrength) {
            this.authenticationStrength = authenticationStrength;
            this.changedFields = changedFields.add("authenticationStrength");
            return this;
        }

        public Builder conditionsNotSatisfied(ConditionalAccessConditions conditionsNotSatisfied) {
            this.conditionsNotSatisfied = conditionsNotSatisfied;
            this.changedFields = changedFields.add("conditionsNotSatisfied");
            return this;
        }

        public Builder conditionsSatisfied(ConditionalAccessConditions conditionsSatisfied) {
            this.conditionsSatisfied = conditionsSatisfied;
            this.changedFields = changedFields.add("conditionsSatisfied");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder enforcedGrantControls(List<String> enforcedGrantControls) {
            this.enforcedGrantControls = enforcedGrantControls;
            this.changedFields = changedFields.add("enforcedGrantControls");
            return this;
        }

        public Builder enforcedGrantControls(String... enforcedGrantControls) {
            return enforcedGrantControls(Arrays.asList(enforcedGrantControls));
        }

        public Builder enforcedGrantControlsNextLink(String enforcedGrantControlsNextLink) {
            this.enforcedGrantControlsNextLink = enforcedGrantControlsNextLink;
            this.changedFields = changedFields.add("enforcedGrantControls");
            return this;
        }

        public Builder enforcedSessionControls(List<String> enforcedSessionControls) {
            this.enforcedSessionControls = enforcedSessionControls;
            this.changedFields = changedFields.add("enforcedSessionControls");
            return this;
        }

        public Builder enforcedSessionControls(String... enforcedSessionControls) {
            return enforcedSessionControls(Arrays.asList(enforcedSessionControls));
        }

        public Builder enforcedSessionControlsNextLink(String enforcedSessionControlsNextLink) {
            this.enforcedSessionControlsNextLink = enforcedSessionControlsNextLink;
            this.changedFields = changedFields.add("enforcedSessionControls");
            return this;
        }

        public Builder excludeRulesSatisfied(List<ConditionalAccessRuleSatisfied> excludeRulesSatisfied) {
            this.excludeRulesSatisfied = excludeRulesSatisfied;
            this.changedFields = changedFields.add("excludeRulesSatisfied");
            return this;
        }

        public Builder excludeRulesSatisfied(ConditionalAccessRuleSatisfied... excludeRulesSatisfied) {
            return excludeRulesSatisfied(Arrays.asList(excludeRulesSatisfied));
        }

        public Builder excludeRulesSatisfiedNextLink(String excludeRulesSatisfiedNextLink) {
            this.excludeRulesSatisfiedNextLink = excludeRulesSatisfiedNextLink;
            this.changedFields = changedFields.add("excludeRulesSatisfied");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder includeRulesSatisfied(List<ConditionalAccessRuleSatisfied> includeRulesSatisfied) {
            this.includeRulesSatisfied = includeRulesSatisfied;
            this.changedFields = changedFields.add("includeRulesSatisfied");
            return this;
        }

        public Builder includeRulesSatisfied(ConditionalAccessRuleSatisfied... includeRulesSatisfied) {
            return includeRulesSatisfied(Arrays.asList(includeRulesSatisfied));
        }

        public Builder includeRulesSatisfiedNextLink(String includeRulesSatisfiedNextLink) {
            this.includeRulesSatisfiedNextLink = includeRulesSatisfiedNextLink;
            this.changedFields = changedFields.add("includeRulesSatisfied");
            return this;
        }

        public Builder result(AppliedConditionalAccessPolicyResult result) {
            this.result = result;
            this.changedFields = changedFields.add("result");
            return this;
        }

        public AppliedConditionalAccessPolicy build() {
            AppliedConditionalAccessPolicy _x = new AppliedConditionalAccessPolicy();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.appliedConditionalAccessPolicy";
            _x.authenticationStrength = authenticationStrength;
            _x.conditionsNotSatisfied = conditionsNotSatisfied;
            _x.conditionsSatisfied = conditionsSatisfied;
            _x.displayName = displayName;
            _x.enforcedGrantControls = enforcedGrantControls;
            _x.enforcedGrantControlsNextLink = enforcedGrantControlsNextLink;
            _x.enforcedSessionControls = enforcedSessionControls;
            _x.enforcedSessionControlsNextLink = enforcedSessionControlsNextLink;
            _x.excludeRulesSatisfied = excludeRulesSatisfied;
            _x.excludeRulesSatisfiedNextLink = excludeRulesSatisfiedNextLink;
            _x.id = id;
            _x.includeRulesSatisfied = includeRulesSatisfied;
            _x.includeRulesSatisfiedNextLink = includeRulesSatisfiedNextLink;
            _x.result = result;
            return _x;
        }
    }

    private AppliedConditionalAccessPolicy _copy() {
        AppliedConditionalAccessPolicy _x = new AppliedConditionalAccessPolicy();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.authenticationStrength = authenticationStrength;
        _x.conditionsNotSatisfied = conditionsNotSatisfied;
        _x.conditionsSatisfied = conditionsSatisfied;
        _x.displayName = displayName;
        _x.enforcedGrantControls = enforcedGrantControls;
        _x.enforcedSessionControls = enforcedSessionControls;
        _x.excludeRulesSatisfied = excludeRulesSatisfied;
        _x.id = id;
        _x.includeRulesSatisfied = includeRulesSatisfied;
        _x.result = result;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppliedConditionalAccessPolicy[");
        b.append("authenticationStrength=");
        b.append(this.authenticationStrength);
        b.append(", ");
        b.append("conditionsNotSatisfied=");
        b.append(this.conditionsNotSatisfied);
        b.append(", ");
        b.append("conditionsSatisfied=");
        b.append(this.conditionsSatisfied);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("enforcedGrantControls=");
        b.append(this.enforcedGrantControls);
        b.append(", ");
        b.append("enforcedSessionControls=");
        b.append(this.enforcedSessionControls);
        b.append(", ");
        b.append("excludeRulesSatisfied=");
        b.append(this.excludeRulesSatisfied);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("includeRulesSatisfied=");
        b.append(this.includeRulesSatisfied);
        b.append(", ");
        b.append("result=");
        b.append(this.result);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
