package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "allowedMemberTypes", 
    "description", 
    "displayName", 
    "id", 
    "isEnabled", 
    "origin", 
    "value"})
@JsonInclude(Include.NON_NULL)
public class AppRole implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("allowedMemberTypes")
    protected List<String> allowedMemberTypes;

    @JsonProperty("allowedMemberTypes@nextLink")
    protected String allowedMemberTypesNextLink;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("id")
    protected UUID id;

    @JsonProperty("isEnabled")
    protected Boolean isEnabled;

    @JsonProperty("origin")
    protected String origin;

    @JsonProperty("value")
    protected String value;

    protected AppRole() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.appRole";
    }

    @Property(name="allowedMemberTypes")
    @JsonIgnore
    public CollectionPage<String> getAllowedMemberTypes() {
        return new CollectionPage<String>(contextPath, String.class, this.allowedMemberTypes, Optional.ofNullable(allowedMemberTypesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="allowedMemberTypes")
    @JsonIgnore
    public CollectionPage<String> getAllowedMemberTypes(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.allowedMemberTypes, Optional.ofNullable(allowedMemberTypesNextLink), Collections.emptyList(), options);
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public AppRole withDescription(String description) {
        AppRole _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appRole");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public AppRole withDisplayName(String displayName) {
        AppRole _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appRole");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<UUID> getId() {
        return Optional.ofNullable(id);
    }

    public AppRole withId(UUID id) {
        AppRole _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appRole");
        _x.id = id;
        return _x;
    }

    @Property(name="isEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsEnabled() {
        return Optional.ofNullable(isEnabled);
    }

    public AppRole withIsEnabled(Boolean isEnabled) {
        AppRole _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appRole");
        _x.isEnabled = isEnabled;
        return _x;
    }

    @Property(name="origin")
    @JsonIgnore
    public Optional<String> getOrigin() {
        return Optional.ofNullable(origin);
    }

    public AppRole withOrigin(String origin) {
        AppRole _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appRole");
        _x.origin = origin;
        return _x;
    }

    @Property(name="value")
    @JsonIgnore
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    public AppRole withValue(String value) {
        AppRole _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appRole");
        _x.value = value;
        return _x;
    }

    public AppRole withUnmappedField(String name, Object value) {
        AppRole _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> allowedMemberTypes;
        private String allowedMemberTypesNextLink;
        private String description;
        private String displayName;
        private UUID id;
        private Boolean isEnabled;
        private String origin;
        private String value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder allowedMemberTypes(List<String> allowedMemberTypes) {
            this.allowedMemberTypes = allowedMemberTypes;
            this.changedFields = changedFields.add("allowedMemberTypes");
            return this;
        }

        public Builder allowedMemberTypes(String... allowedMemberTypes) {
            return allowedMemberTypes(Arrays.asList(allowedMemberTypes));
        }

        public Builder allowedMemberTypesNextLink(String allowedMemberTypesNextLink) {
            this.allowedMemberTypesNextLink = allowedMemberTypesNextLink;
            this.changedFields = changedFields.add("allowedMemberTypes");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder id(UUID id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.changedFields = changedFields.add("isEnabled");
            return this;
        }

        public Builder origin(String origin) {
            this.origin = origin;
            this.changedFields = changedFields.add("origin");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.changedFields = changedFields.add("value");
            return this;
        }

        public AppRole build() {
            AppRole _x = new AppRole();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.appRole";
            _x.allowedMemberTypes = allowedMemberTypes;
            _x.allowedMemberTypesNextLink = allowedMemberTypesNextLink;
            _x.description = description;
            _x.displayName = displayName;
            _x.id = id;
            _x.isEnabled = isEnabled;
            _x.origin = origin;
            _x.value = value;
            return _x;
        }
    }

    private AppRole _copy() {
        AppRole _x = new AppRole();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.allowedMemberTypes = allowedMemberTypes;
        _x.description = description;
        _x.displayName = displayName;
        _x.id = id;
        _x.isEnabled = isEnabled;
        _x.origin = origin;
        _x.value = value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppRole[");
        b.append("allowedMemberTypes=");
        b.append(this.allowedMemberTypes);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("isEnabled=");
        b.append(this.isEnabled);
        b.append(", ");
        b.append("origin=");
        b.append(this.origin);
        b.append(", ");
        b.append("value=");
        b.append(this.value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
