package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "acceptMappedClaims", 
    "knownClientApplications", 
    "oauth2PermissionScopes", 
    "preAuthorizedApplications", 
    "requestedAccessTokenVersion"})
@JsonInclude(Include.NON_NULL)
public class ApiApplication implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("acceptMappedClaims")
    protected Boolean acceptMappedClaims;

    @JsonProperty("knownClientApplications")
    protected List<UUID> knownClientApplications;

    @JsonProperty("knownClientApplications@nextLink")
    protected String knownClientApplicationsNextLink;

    @JsonProperty("oauth2PermissionScopes")
    protected List<PermissionScope> oauth2PermissionScopes;

    @JsonProperty("oauth2PermissionScopes@nextLink")
    protected String oauth2PermissionScopesNextLink;

    @JsonProperty("preAuthorizedApplications")
    protected List<PreAuthorizedApplication> preAuthorizedApplications;

    @JsonProperty("preAuthorizedApplications@nextLink")
    protected String preAuthorizedApplicationsNextLink;

    @JsonProperty("requestedAccessTokenVersion")
    protected Integer requestedAccessTokenVersion;

    protected ApiApplication() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.apiApplication";
    }

    @Property(name="acceptMappedClaims")
    @JsonIgnore
    public Optional<Boolean> getAcceptMappedClaims() {
        return Optional.ofNullable(acceptMappedClaims);
    }

    public ApiApplication withAcceptMappedClaims(Boolean acceptMappedClaims) {
        ApiApplication _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.apiApplication");
        _x.acceptMappedClaims = acceptMappedClaims;
        return _x;
    }

    @Property(name="knownClientApplications")
    @JsonIgnore
    public CollectionPage<UUID> getKnownClientApplications() {
        return new CollectionPage<UUID>(contextPath, UUID.class, this.knownClientApplications, Optional.ofNullable(knownClientApplicationsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="knownClientApplications")
    @JsonIgnore
    public CollectionPage<UUID> getKnownClientApplications(HttpRequestOptions options) {
        return new CollectionPage<UUID>(contextPath, UUID.class, this.knownClientApplications, Optional.ofNullable(knownClientApplicationsNextLink), Collections.emptyList(), options);
    }

    @Property(name="oauth2PermissionScopes")
    @JsonIgnore
    public CollectionPage<PermissionScope> getOauth2PermissionScopes() {
        return new CollectionPage<PermissionScope>(contextPath, PermissionScope.class, this.oauth2PermissionScopes, Optional.ofNullable(oauth2PermissionScopesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="oauth2PermissionScopes")
    @JsonIgnore
    public CollectionPage<PermissionScope> getOauth2PermissionScopes(HttpRequestOptions options) {
        return new CollectionPage<PermissionScope>(contextPath, PermissionScope.class, this.oauth2PermissionScopes, Optional.ofNullable(oauth2PermissionScopesNextLink), Collections.emptyList(), options);
    }

    @Property(name="preAuthorizedApplications")
    @JsonIgnore
    public CollectionPage<PreAuthorizedApplication> getPreAuthorizedApplications() {
        return new CollectionPage<PreAuthorizedApplication>(contextPath, PreAuthorizedApplication.class, this.preAuthorizedApplications, Optional.ofNullable(preAuthorizedApplicationsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="preAuthorizedApplications")
    @JsonIgnore
    public CollectionPage<PreAuthorizedApplication> getPreAuthorizedApplications(HttpRequestOptions options) {
        return new CollectionPage<PreAuthorizedApplication>(contextPath, PreAuthorizedApplication.class, this.preAuthorizedApplications, Optional.ofNullable(preAuthorizedApplicationsNextLink), Collections.emptyList(), options);
    }

    @Property(name="requestedAccessTokenVersion")
    @JsonIgnore
    public Optional<Integer> getRequestedAccessTokenVersion() {
        return Optional.ofNullable(requestedAccessTokenVersion);
    }

    public ApiApplication withRequestedAccessTokenVersion(Integer requestedAccessTokenVersion) {
        ApiApplication _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.apiApplication");
        _x.requestedAccessTokenVersion = requestedAccessTokenVersion;
        return _x;
    }

    public ApiApplication withUnmappedField(String name, Object value) {
        ApiApplication _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean acceptMappedClaims;
        private List<UUID> knownClientApplications;
        private String knownClientApplicationsNextLink;
        private List<PermissionScope> oauth2PermissionScopes;
        private String oauth2PermissionScopesNextLink;
        private List<PreAuthorizedApplication> preAuthorizedApplications;
        private String preAuthorizedApplicationsNextLink;
        private Integer requestedAccessTokenVersion;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder acceptMappedClaims(Boolean acceptMappedClaims) {
            this.acceptMappedClaims = acceptMappedClaims;
            this.changedFields = changedFields.add("acceptMappedClaims");
            return this;
        }

        public Builder knownClientApplications(List<UUID> knownClientApplications) {
            this.knownClientApplications = knownClientApplications;
            this.changedFields = changedFields.add("knownClientApplications");
            return this;
        }

        public Builder knownClientApplications(UUID... knownClientApplications) {
            return knownClientApplications(Arrays.asList(knownClientApplications));
        }

        public Builder knownClientApplicationsNextLink(String knownClientApplicationsNextLink) {
            this.knownClientApplicationsNextLink = knownClientApplicationsNextLink;
            this.changedFields = changedFields.add("knownClientApplications");
            return this;
        }

        public Builder oauth2PermissionScopes(List<PermissionScope> oauth2PermissionScopes) {
            this.oauth2PermissionScopes = oauth2PermissionScopes;
            this.changedFields = changedFields.add("oauth2PermissionScopes");
            return this;
        }

        public Builder oauth2PermissionScopes(PermissionScope... oauth2PermissionScopes) {
            return oauth2PermissionScopes(Arrays.asList(oauth2PermissionScopes));
        }

        public Builder oauth2PermissionScopesNextLink(String oauth2PermissionScopesNextLink) {
            this.oauth2PermissionScopesNextLink = oauth2PermissionScopesNextLink;
            this.changedFields = changedFields.add("oauth2PermissionScopes");
            return this;
        }

        public Builder preAuthorizedApplications(List<PreAuthorizedApplication> preAuthorizedApplications) {
            this.preAuthorizedApplications = preAuthorizedApplications;
            this.changedFields = changedFields.add("preAuthorizedApplications");
            return this;
        }

        public Builder preAuthorizedApplications(PreAuthorizedApplication... preAuthorizedApplications) {
            return preAuthorizedApplications(Arrays.asList(preAuthorizedApplications));
        }

        public Builder preAuthorizedApplicationsNextLink(String preAuthorizedApplicationsNextLink) {
            this.preAuthorizedApplicationsNextLink = preAuthorizedApplicationsNextLink;
            this.changedFields = changedFields.add("preAuthorizedApplications");
            return this;
        }

        public Builder requestedAccessTokenVersion(Integer requestedAccessTokenVersion) {
            this.requestedAccessTokenVersion = requestedAccessTokenVersion;
            this.changedFields = changedFields.add("requestedAccessTokenVersion");
            return this;
        }

        public ApiApplication build() {
            ApiApplication _x = new ApiApplication();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.apiApplication";
            _x.acceptMappedClaims = acceptMappedClaims;
            _x.knownClientApplications = knownClientApplications;
            _x.knownClientApplicationsNextLink = knownClientApplicationsNextLink;
            _x.oauth2PermissionScopes = oauth2PermissionScopes;
            _x.oauth2PermissionScopesNextLink = oauth2PermissionScopesNextLink;
            _x.preAuthorizedApplications = preAuthorizedApplications;
            _x.preAuthorizedApplicationsNextLink = preAuthorizedApplicationsNextLink;
            _x.requestedAccessTokenVersion = requestedAccessTokenVersion;
            return _x;
        }
    }

    private ApiApplication _copy() {
        ApiApplication _x = new ApiApplication();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.acceptMappedClaims = acceptMappedClaims;
        _x.knownClientApplications = knownClientApplications;
        _x.oauth2PermissionScopes = oauth2PermissionScopes;
        _x.preAuthorizedApplications = preAuthorizedApplications;
        _x.requestedAccessTokenVersion = requestedAccessTokenVersion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ApiApplication[");
        b.append("acceptMappedClaims=");
        b.append(this.acceptMappedClaims);
        b.append(", ");
        b.append("knownClientApplications=");
        b.append(this.knownClientApplications);
        b.append(", ");
        b.append("oauth2PermissionScopes=");
        b.append(this.oauth2PermissionScopes);
        b.append(", ");
        b.append("preAuthorizedApplications=");
        b.append(this.preAuthorizedApplications);
        b.append(", ");
        b.append("requestedAccessTokenVersion=");
        b.append(this.requestedAccessTokenVersion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
