package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“The identifier for an Android app.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "packageId"})
@JsonInclude(Include.NON_NULL)
public class AndroidMobileAppIdentifier extends MobileAppIdentifier implements ODataType {

    @JsonProperty("packageId")
    protected String packageId;

    protected AndroidMobileAppIdentifier() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidMobileAppIdentifier";
    }

    /**
     * <i>“The identifier for an app, as specified in the play store.”</i>
     * 
     * @return property packageId
     */
    @Property(name="packageId")
    @JsonIgnore
    public Optional<String> getPackageId() {
        return Optional.ofNullable(packageId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code packageId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The identifier for an app, as specified in the play store.”</i>
     * 
     * @param packageId
     *            new value of {@code packageId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code packageId} field changed
     */
    public AndroidMobileAppIdentifier withPackageId(String packageId) {
        AndroidMobileAppIdentifier _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidMobileAppIdentifier");
        _x.packageId = packageId;
        return _x;
    }

    public AndroidMobileAppIdentifier withUnmappedField(String name, Object value) {
        AndroidMobileAppIdentifier _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidMobileAppIdentifier() {
        return new Builder();
    }

    public static final class Builder {
        private String packageId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The identifier for an app, as specified in the play store.”</i>
         * 
         * @param packageId
         *            value of {@code packageId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder packageId(String packageId) {
            this.packageId = packageId;
            this.changedFields = changedFields.add("packageId");
            return this;
        }

        public AndroidMobileAppIdentifier build() {
            AndroidMobileAppIdentifier _x = new AndroidMobileAppIdentifier();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.androidMobileAppIdentifier";
            _x.packageId = packageId;
            return _x;
        }
    }

    private AndroidMobileAppIdentifier _copy() {
        AndroidMobileAppIdentifier _x = new AndroidMobileAppIdentifier();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.packageId = packageId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidMobileAppIdentifier[");
        b.append("packageId=");
        b.append(this.packageId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
