package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“A reference to folder containing apps and weblinks on the Managed Home Screen”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "folderIdentifier", 
    "folderName"})
@JsonInclude(Include.NON_NULL)
public class AndroidDeviceOwnerKioskModeManagedFolderReference extends AndroidDeviceOwnerKioskModeHomeScreenItem implements ODataType {

    @JsonProperty("folderIdentifier")
    protected String folderIdentifier;

    @JsonProperty("folderName")
    protected String folderName;

    protected AndroidDeviceOwnerKioskModeManagedFolderReference() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidDeviceOwnerKioskModeManagedFolderReference";
    }

    /**
     * <i>“Unique identifier for the folder”</i>
     * 
     * @return property folderIdentifier
     */
    @Property(name="folderIdentifier")
    @JsonIgnore
    public Optional<String> getFolderIdentifier() {
        return Optional.ofNullable(folderIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code folderIdentifier}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Unique identifier for the folder”</i>
     * 
     * @param folderIdentifier
     *            new value of {@code folderIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code folderIdentifier} field changed
     */
    public AndroidDeviceOwnerKioskModeManagedFolderReference withFolderIdentifier(String folderIdentifier) {
        AndroidDeviceOwnerKioskModeManagedFolderReference _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerKioskModeManagedFolderReference");
        _x.folderIdentifier = folderIdentifier;
        return _x;
    }

    /**
     * <i>“Name of the folder”</i>
     * 
     * @return property folderName
     */
    @Property(name="folderName")
    @JsonIgnore
    public Optional<String> getFolderName() {
        return Optional.ofNullable(folderName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code folderName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Name of the folder”</i>
     * 
     * @param folderName
     *            new value of {@code folderName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code folderName} field changed
     */
    public AndroidDeviceOwnerKioskModeManagedFolderReference withFolderName(String folderName) {
        AndroidDeviceOwnerKioskModeManagedFolderReference _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerKioskModeManagedFolderReference");
        _x.folderName = folderName;
        return _x;
    }

    public AndroidDeviceOwnerKioskModeManagedFolderReference withUnmappedField(String name, Object value) {
        AndroidDeviceOwnerKioskModeManagedFolderReference _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidDeviceOwnerKioskModeManagedFolderReference() {
        return new Builder();
    }

    public static final class Builder {
        private String folderIdentifier;
        private String folderName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Unique identifier for the folder”</i>
         * 
         * @param folderIdentifier
         *            value of {@code folderIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder folderIdentifier(String folderIdentifier) {
            this.folderIdentifier = folderIdentifier;
            this.changedFields = changedFields.add("folderIdentifier");
            return this;
        }

        /**
         * <i>“Name of the folder”</i>
         * 
         * @param folderName
         *            value of {@code folderName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder folderName(String folderName) {
            this.folderName = folderName;
            this.changedFields = changedFields.add("folderName");
            return this;
        }

        public AndroidDeviceOwnerKioskModeManagedFolderReference build() {
            AndroidDeviceOwnerKioskModeManagedFolderReference _x = new AndroidDeviceOwnerKioskModeManagedFolderReference();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.androidDeviceOwnerKioskModeManagedFolderReference";
            _x.folderIdentifier = folderIdentifier;
            _x.folderName = folderName;
            return _x;
        }
    }

    private AndroidDeviceOwnerKioskModeManagedFolderReference _copy() {
        AndroidDeviceOwnerKioskModeManagedFolderReference _x = new AndroidDeviceOwnerKioskModeManagedFolderReference();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.folderIdentifier = folderIdentifier;
        _x.folderName = folderName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidDeviceOwnerKioskModeManagedFolderReference[");
        b.append("folderIdentifier=");
        b.append(this.folderIdentifier);
        b.append(", ");
        b.append("folderName=");
        b.append(this.folderName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
