package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“An item in the list of app positions that sets the order of items on the Managed
 * Home Screen”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "item", 
    "position"})
@JsonInclude(Include.NON_NULL)
public class AndroidDeviceOwnerKioskModeAppPositionItem implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("item")
    protected AndroidDeviceOwnerKioskModeHomeScreenItem item;

    @JsonProperty("position")
    protected Integer position;

    protected AndroidDeviceOwnerKioskModeAppPositionItem() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidDeviceOwnerKioskModeAppPositionItem";
    }

    /**
     * <i>“Item to be arranged”</i>
     * 
     * @return property item
     */
    @Property(name="item")
    @JsonIgnore
    public Optional<AndroidDeviceOwnerKioskModeHomeScreenItem> getItem() {
        return Optional.ofNullable(item);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code item} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Item to be arranged”</i>
     * 
     * @param item
     *            new value of {@code item} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code item} field changed
     */
    public AndroidDeviceOwnerKioskModeAppPositionItem withItem(AndroidDeviceOwnerKioskModeHomeScreenItem item) {
        AndroidDeviceOwnerKioskModeAppPositionItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerKioskModeAppPositionItem");
        _x.item = item;
        return _x;
    }

    /**
     * <i>“Position of the item on the grid. Valid values 0 to 9999999”</i>
     * 
     * @return property position
     */
    @Property(name="position")
    @JsonIgnore
    public Optional<Integer> getPosition() {
        return Optional.ofNullable(position);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code position} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Position of the item on the grid. Valid values 0 to 9999999”</i>
     * 
     * @param position
     *            new value of {@code position} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code position} field changed
     */
    public AndroidDeviceOwnerKioskModeAppPositionItem withPosition(Integer position) {
        AndroidDeviceOwnerKioskModeAppPositionItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerKioskModeAppPositionItem");
        _x.position = position;
        return _x;
    }

    public AndroidDeviceOwnerKioskModeAppPositionItem withUnmappedField(String name, Object value) {
        AndroidDeviceOwnerKioskModeAppPositionItem _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AndroidDeviceOwnerKioskModeHomeScreenItem item;
        private Integer position;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Item to be arranged”</i>
         * 
         * @param item
         *            value of {@code item} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder item(AndroidDeviceOwnerKioskModeHomeScreenItem item) {
            this.item = item;
            this.changedFields = changedFields.add("item");
            return this;
        }

        /**
         * <i>“Position of the item on the grid. Valid values 0 to 9999999”</i>
         * 
         * @param position
         *            value of {@code position} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder position(Integer position) {
            this.position = position;
            this.changedFields = changedFields.add("position");
            return this;
        }

        public AndroidDeviceOwnerKioskModeAppPositionItem build() {
            AndroidDeviceOwnerKioskModeAppPositionItem _x = new AndroidDeviceOwnerKioskModeAppPositionItem();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.androidDeviceOwnerKioskModeAppPositionItem";
            _x.item = item;
            _x.position = position;
            return _x;
        }
    }

    private AndroidDeviceOwnerKioskModeAppPositionItem _copy() {
        AndroidDeviceOwnerKioskModeAppPositionItem _x = new AndroidDeviceOwnerKioskModeAppPositionItem();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.item = item;
        _x.position = position;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidDeviceOwnerKioskModeAppPositionItem[");
        b.append("item=");
        b.append(this.item);
        b.append(", ");
        b.append("position=");
        b.append(this.position);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
