package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“An application on the Android Device Owner Managed Home Screen”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "className", 
    "package"})
@JsonInclude(Include.NON_NULL)
public class AndroidDeviceOwnerKioskModeApp extends AndroidDeviceOwnerKioskModeFolderItem implements ODataType {

    @JsonProperty("className")
    protected String className;

    @JsonProperty("package")
    protected String package_;

    protected AndroidDeviceOwnerKioskModeApp() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidDeviceOwnerKioskModeApp";
    }

    /**
     * <i>“Class name of application”</i>
     * 
     * @return property className
     */
    @Property(name="className")
    @JsonIgnore
    public Optional<String> getClassName() {
        return Optional.ofNullable(className);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code className} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Class name of application”</i>
     * 
     * @param className
     *            new value of {@code className} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code className} field changed
     */
    public AndroidDeviceOwnerKioskModeApp withClassName(String className) {
        AndroidDeviceOwnerKioskModeApp _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerKioskModeApp");
        _x.className = className;
        return _x;
    }

    /**
     * <i>“Package name of application”</i>
     * 
     * @return property package
     */
    @Property(name="package")
    @JsonIgnore
    public Optional<String> getPackage() {
        return Optional.ofNullable(package_);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code package} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Package name of application”</i>
     * 
     * @param package_
     *            new value of {@code package} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code package} field changed
     */
    public AndroidDeviceOwnerKioskModeApp withPackage(String package_) {
        AndroidDeviceOwnerKioskModeApp _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerKioskModeApp");
        _x.package_ = package_;
        return _x;
    }

    public AndroidDeviceOwnerKioskModeApp withUnmappedField(String name, Object value) {
        AndroidDeviceOwnerKioskModeApp _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidDeviceOwnerKioskModeApp() {
        return new Builder();
    }

    public static final class Builder {
        private String className;
        private String package_;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Class name of application”</i>
         * 
         * @param className
         *            value of {@code className} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder className(String className) {
            this.className = className;
            this.changedFields = changedFields.add("className");
            return this;
        }

        /**
         * <i>“Package name of application”</i>
         * 
         * @param package_
         *            value of {@code package} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder package_(String package_) {
            this.package_ = package_;
            this.changedFields = changedFields.add("package");
            return this;
        }

        public AndroidDeviceOwnerKioskModeApp build() {
            AndroidDeviceOwnerKioskModeApp _x = new AndroidDeviceOwnerKioskModeApp();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.androidDeviceOwnerKioskModeApp";
            _x.className = className;
            _x.package_ = package_;
            return _x;
        }
    }

    private AndroidDeviceOwnerKioskModeApp _copy() {
        AndroidDeviceOwnerKioskModeApp _x = new AndroidDeviceOwnerKioskModeApp();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.className = className;
        _x.package_ = package_;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidDeviceOwnerKioskModeApp[");
        b.append("className=");
        b.append(this.className);
        b.append(", ");
        b.append("package=");
        b.append(this.package_);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
