package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Android Device Owner Global Proxy Direct.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "excludedHosts", 
    "host", 
    "port"})
@JsonInclude(Include.NON_NULL)
public class AndroidDeviceOwnerGlobalProxyDirect extends AndroidDeviceOwnerGlobalProxy implements ODataType {

    @JsonProperty("excludedHosts")
    protected List<String> excludedHosts;

    @JsonProperty("excludedHosts@nextLink")
    protected String excludedHostsNextLink;

    @JsonProperty("host")
    protected String host;

    @JsonProperty("port")
    protected Integer port;

    protected AndroidDeviceOwnerGlobalProxyDirect() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidDeviceOwnerGlobalProxyDirect";
    }

    /**
     * <i>“The excluded hosts”</i>
     * 
     * @return property excludedHosts
     */
    @Property(name="excludedHosts")
    @JsonIgnore
    public CollectionPage<String> getExcludedHosts() {
        return new CollectionPage<String>(contextPath, String.class, this.excludedHosts, Optional.ofNullable(excludedHostsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“The excluded hosts”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property excludedHosts
     */
    @Property(name="excludedHosts")
    @JsonIgnore
    public CollectionPage<String> getExcludedHosts(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.excludedHosts, Optional.ofNullable(excludedHostsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The host name”</i>
     * 
     * @return property host
     */
    @Property(name="host")
    @JsonIgnore
    public Optional<String> getHost() {
        return Optional.ofNullable(host);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code host} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The host name”</i>
     * 
     * @param host
     *            new value of {@code host} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code host} field changed
     */
    public AndroidDeviceOwnerGlobalProxyDirect withHost(String host) {
        AndroidDeviceOwnerGlobalProxyDirect _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGlobalProxyDirect");
        _x.host = host;
        return _x;
    }

    /**
     * <i>“The port”</i>
     * 
     * @return property port
     */
    @Property(name="port")
    @JsonIgnore
    public Optional<Integer> getPort() {
        return Optional.ofNullable(port);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code port} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The port”</i>
     * 
     * @param port
     *            new value of {@code port} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code port} field changed
     */
    public AndroidDeviceOwnerGlobalProxyDirect withPort(Integer port) {
        AndroidDeviceOwnerGlobalProxyDirect _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGlobalProxyDirect");
        _x.port = port;
        return _x;
    }

    public AndroidDeviceOwnerGlobalProxyDirect withUnmappedField(String name, Object value) {
        AndroidDeviceOwnerGlobalProxyDirect _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidDeviceOwnerGlobalProxyDirect() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> excludedHosts;
        private String excludedHostsNextLink;
        private String host;
        private Integer port;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The excluded hosts”</i>
         * 
         * @param excludedHosts
         *            value of {@code excludedHosts} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder excludedHosts(List<String> excludedHosts) {
            this.excludedHosts = excludedHosts;
            this.changedFields = changedFields.add("excludedHosts");
            return this;
        }

        /**
         * <i>“The excluded hosts”</i>
         * 
         * @param excludedHosts
         *            value of {@code excludedHosts} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder excludedHosts(String... excludedHosts) {
            return excludedHosts(Arrays.asList(excludedHosts));
        }

        /**
         * <i>“The excluded hosts”</i>
         * 
         * @param excludedHostsNextLink
         *            value of {@code excludedHosts@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder excludedHostsNextLink(String excludedHostsNextLink) {
            this.excludedHostsNextLink = excludedHostsNextLink;
            this.changedFields = changedFields.add("excludedHosts");
            return this;
        }

        /**
         * <i>“The host name”</i>
         * 
         * @param host
         *            value of {@code host} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder host(String host) {
            this.host = host;
            this.changedFields = changedFields.add("host");
            return this;
        }

        /**
         * <i>“The port”</i>
         * 
         * @param port
         *            value of {@code port} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder port(Integer port) {
            this.port = port;
            this.changedFields = changedFields.add("port");
            return this;
        }

        public AndroidDeviceOwnerGlobalProxyDirect build() {
            AndroidDeviceOwnerGlobalProxyDirect _x = new AndroidDeviceOwnerGlobalProxyDirect();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.androidDeviceOwnerGlobalProxyDirect";
            _x.excludedHosts = excludedHosts;
            _x.excludedHostsNextLink = excludedHostsNextLink;
            _x.host = host;
            _x.port = port;
            return _x;
        }
    }

    private AndroidDeviceOwnerGlobalProxyDirect _copy() {
        AndroidDeviceOwnerGlobalProxyDirect _x = new AndroidDeviceOwnerGlobalProxyDirect();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.excludedHosts = excludedHosts;
        _x.host = host;
        _x.port = port;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidDeviceOwnerGlobalProxyDirect[");
        b.append("excludedHosts=");
        b.append(this.excludedHosts);
        b.append(", ");
        b.append("host=");
        b.append(this.host);
        b.append(", ");
        b.append("port=");
        b.append(this.port);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
