package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Android Device Owner Global Proxy Auto Config.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "proxyAutoConfigURL"})
@JsonInclude(Include.NON_NULL)
public class AndroidDeviceOwnerGlobalProxyAutoConfig extends AndroidDeviceOwnerGlobalProxy implements ODataType {

    @JsonProperty("proxyAutoConfigURL")
    protected String proxyAutoConfigURL;

    protected AndroidDeviceOwnerGlobalProxyAutoConfig() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidDeviceOwnerGlobalProxyAutoConfig";
    }

    /**
     * <i>“The proxy auto-config URL”</i>
     * 
     * @return property proxyAutoConfigURL
     */
    @Property(name="proxyAutoConfigURL")
    @JsonIgnore
    public Optional<String> getProxyAutoConfigURL() {
        return Optional.ofNullable(proxyAutoConfigURL);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * proxyAutoConfigURL} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The proxy auto-config URL”</i>
     * 
     * @param proxyAutoConfigURL
     *            new value of {@code proxyAutoConfigURL} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code proxyAutoConfigURL} field changed
     */
    public AndroidDeviceOwnerGlobalProxyAutoConfig withProxyAutoConfigURL(String proxyAutoConfigURL) {
        AndroidDeviceOwnerGlobalProxyAutoConfig _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGlobalProxyAutoConfig");
        _x.proxyAutoConfigURL = proxyAutoConfigURL;
        return _x;
    }

    public AndroidDeviceOwnerGlobalProxyAutoConfig withUnmappedField(String name, Object value) {
        AndroidDeviceOwnerGlobalProxyAutoConfig _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidDeviceOwnerGlobalProxyAutoConfig() {
        return new Builder();
    }

    public static final class Builder {
        private String proxyAutoConfigURL;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The proxy auto-config URL”</i>
         * 
         * @param proxyAutoConfigURL
         *            value of {@code proxyAutoConfigURL} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder proxyAutoConfigURL(String proxyAutoConfigURL) {
            this.proxyAutoConfigURL = proxyAutoConfigURL;
            this.changedFields = changedFields.add("proxyAutoConfigURL");
            return this;
        }

        public AndroidDeviceOwnerGlobalProxyAutoConfig build() {
            AndroidDeviceOwnerGlobalProxyAutoConfig _x = new AndroidDeviceOwnerGlobalProxyAutoConfig();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.androidDeviceOwnerGlobalProxyAutoConfig";
            _x.proxyAutoConfigURL = proxyAutoConfigURL;
            return _x;
        }
    }

    private AndroidDeviceOwnerGlobalProxyAutoConfig _copy() {
        AndroidDeviceOwnerGlobalProxyAutoConfig _x = new AndroidDeviceOwnerGlobalProxyAutoConfig();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.proxyAutoConfigURL = proxyAutoConfigURL;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidDeviceOwnerGlobalProxyAutoConfig[");
        b.append("proxyAutoConfigURL=");
        b.append(this.proxyAutoConfigURL);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
