package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.SearchAlterationType;

@JsonPropertyOrder({
    "@odata.type", 
    "originalQueryString", 
    "queryAlteration", 
    "queryAlterationType"})
@JsonInclude(Include.NON_NULL)
public class AlterationResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("originalQueryString")
    protected String originalQueryString;

    @JsonProperty("queryAlteration")
    protected SearchAlteration queryAlteration;

    @JsonProperty("queryAlterationType")
    protected SearchAlterationType queryAlterationType;

    protected AlterationResponse() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.alterationResponse";
    }

    @Property(name="originalQueryString")
    @JsonIgnore
    public Optional<String> getOriginalQueryString() {
        return Optional.ofNullable(originalQueryString);
    }

    public AlterationResponse withOriginalQueryString(String originalQueryString) {
        AlterationResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alterationResponse");
        _x.originalQueryString = originalQueryString;
        return _x;
    }

    @Property(name="queryAlteration")
    @JsonIgnore
    public Optional<SearchAlteration> getQueryAlteration() {
        return Optional.ofNullable(queryAlteration);
    }

    public AlterationResponse withQueryAlteration(SearchAlteration queryAlteration) {
        AlterationResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alterationResponse");
        _x.queryAlteration = queryAlteration;
        return _x;
    }

    @Property(name="queryAlterationType")
    @JsonIgnore
    public Optional<SearchAlterationType> getQueryAlterationType() {
        return Optional.ofNullable(queryAlterationType);
    }

    public AlterationResponse withQueryAlterationType(SearchAlterationType queryAlterationType) {
        AlterationResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alterationResponse");
        _x.queryAlterationType = queryAlterationType;
        return _x;
    }

    public AlterationResponse withUnmappedField(String name, Object value) {
        AlterationResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String originalQueryString;
        private SearchAlteration queryAlteration;
        private SearchAlterationType queryAlterationType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder originalQueryString(String originalQueryString) {
            this.originalQueryString = originalQueryString;
            this.changedFields = changedFields.add("originalQueryString");
            return this;
        }

        public Builder queryAlteration(SearchAlteration queryAlteration) {
            this.queryAlteration = queryAlteration;
            this.changedFields = changedFields.add("queryAlteration");
            return this;
        }

        public Builder queryAlterationType(SearchAlterationType queryAlterationType) {
            this.queryAlterationType = queryAlterationType;
            this.changedFields = changedFields.add("queryAlterationType");
            return this;
        }

        public AlterationResponse build() {
            AlterationResponse _x = new AlterationResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.alterationResponse";
            _x.originalQueryString = originalQueryString;
            _x.queryAlteration = queryAlteration;
            _x.queryAlterationType = queryAlterationType;
            return _x;
        }
    }

    private AlterationResponse _copy() {
        AlterationResponse _x = new AlterationResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.originalQueryString = originalQueryString;
        _x.queryAlteration = queryAlteration;
        _x.queryAlterationType = queryAlterationType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AlterationResponse[");
        b.append("originalQueryString=");
        b.append(this.originalQueryString);
        b.append(", ");
        b.append("queryAlteration=");
        b.append(this.queryAlteration);
        b.append(", ");
        b.append("queryAlterationType=");
        b.append(this.queryAlterationType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
