package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "bucketDefinition", 
    "field", 
    "size"})
@JsonInclude(Include.NON_NULL)
public class AggregationOption implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("bucketDefinition")
    protected BucketAggregationDefinition bucketDefinition;

    @JsonProperty("field")
    protected String field;

    @JsonProperty("size")
    protected Integer size;

    protected AggregationOption() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.aggregationOption";
    }

    @Property(name="bucketDefinition")
    @JsonIgnore
    public Optional<BucketAggregationDefinition> getBucketDefinition() {
        return Optional.ofNullable(bucketDefinition);
    }

    public AggregationOption withBucketDefinition(BucketAggregationDefinition bucketDefinition) {
        AggregationOption _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.aggregationOption");
        _x.bucketDefinition = bucketDefinition;
        return _x;
    }

    @Property(name="field")
    @JsonIgnore
    public Optional<String> getField() {
        return Optional.ofNullable(field);
    }

    public AggregationOption withField(String field) {
        AggregationOption _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.aggregationOption");
        _x.field = field;
        return _x;
    }

    @Property(name="size")
    @JsonIgnore
    public Optional<Integer> getSize() {
        return Optional.ofNullable(size);
    }

    public AggregationOption withSize(Integer size) {
        AggregationOption _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.aggregationOption");
        _x.size = size;
        return _x;
    }

    public AggregationOption withUnmappedField(String name, Object value) {
        AggregationOption _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private BucketAggregationDefinition bucketDefinition;
        private String field;
        private Integer size;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder bucketDefinition(BucketAggregationDefinition bucketDefinition) {
            this.bucketDefinition = bucketDefinition;
            this.changedFields = changedFields.add("bucketDefinition");
            return this;
        }

        public Builder field(String field) {
            this.field = field;
            this.changedFields = changedFields.add("field");
            return this;
        }

        public Builder size(Integer size) {
            this.size = size;
            this.changedFields = changedFields.add("size");
            return this;
        }

        public AggregationOption build() {
            AggregationOption _x = new AggregationOption();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.aggregationOption";
            _x.bucketDefinition = bucketDefinition;
            _x.field = field;
            _x.size = size;
            return _x;
        }
    }

    private AggregationOption _copy() {
        AggregationOption _x = new AggregationOption();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.bucketDefinition = bucketDefinition;
        _x.field = field;
        _x.size = size;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AggregationOption[");
        b.append("bucketDefinition=");
        b.append(this.bucketDefinition);
        b.append(", ");
        b.append("field=");
        b.append(this.field);
        b.append(", ");
        b.append("size=");
        b.append(this.size);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
