package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.Alignment;

@JsonPropertyOrder({
    "@odata.type", 
    "alignment", 
    "margin"})
@JsonInclude(Include.NON_NULL)
public class AddFooter extends MarkContent implements ODataType {

    @JsonProperty("alignment")
    protected Alignment alignment;

    @JsonProperty("margin")
    protected Integer margin;

    protected AddFooter() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.addFooter";
    }

    @Property(name="alignment")
    @JsonIgnore
    public Optional<Alignment> getAlignment() {
        return Optional.ofNullable(alignment);
    }

    public AddFooter withAlignment(Alignment alignment) {
        AddFooter _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.addFooter");
        _x.alignment = alignment;
        return _x;
    }

    @Property(name="margin")
    @JsonIgnore
    public Optional<Integer> getMargin() {
        return Optional.ofNullable(margin);
    }

    public AddFooter withMargin(Integer margin) {
        AddFooter _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.addFooter");
        _x.margin = margin;
        return _x;
    }

    public AddFooter withUnmappedField(String name, Object value) {
        AddFooter _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAddFooter() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String fontColor;
        private Long fontSize;
        private String text;
        private Alignment alignment;
        private Integer margin;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder fontColor(String fontColor) {
            this.fontColor = fontColor;
            this.changedFields = changedFields.add("fontColor");
            return this;
        }

        public Builder fontSize(Long fontSize) {
            this.fontSize = fontSize;
            this.changedFields = changedFields.add("fontSize");
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            this.changedFields = changedFields.add("text");
            return this;
        }

        public Builder alignment(Alignment alignment) {
            this.alignment = alignment;
            this.changedFields = changedFields.add("alignment");
            return this;
        }

        public Builder margin(Integer margin) {
            this.margin = margin;
            this.changedFields = changedFields.add("margin");
            return this;
        }

        public AddFooter build() {
            AddFooter _x = new AddFooter();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.addFooter";
            _x.name = name;
            _x.fontColor = fontColor;
            _x.fontSize = fontSize;
            _x.text = text;
            _x.alignment = alignment;
            _x.margin = margin;
            return _x;
        }
    }

    private AddFooter _copy() {
        AddFooter _x = new AddFooter();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.name = name;
        _x.fontColor = fontColor;
        _x.fontSize = fontSize;
        _x.text = text;
        _x.alignment = alignment;
        _x.margin = margin;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AddFooter[");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("fontColor=");
        b.append(this.fontColor);
        b.append(", ");
        b.append("fontSize=");
        b.append(this.fontSize);
        b.append(", ");
        b.append("text=");
        b.append(this.text);
        b.append(", ");
        b.append("alignment=");
        b.append(this.alignment);
        b.append(", ");
        b.append("margin=");
        b.append(this.margin);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
