package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ActionState;


/**
 * <i>“Activate device eSIM action result”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "carrierUrl"})
@JsonInclude(Include.NON_NULL)
public class ActivateDeviceEsimActionResult extends DeviceActionResult implements ODataType {

    @JsonProperty("carrierUrl")
    protected String carrierUrl;

    protected ActivateDeviceEsimActionResult() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.activateDeviceEsimActionResult";
    }

    /**
     * <i>“Carrier Url to activate the device eSIM”</i>
     * 
     * @return property carrierUrl
     */
    @Property(name="carrierUrl")
    @JsonIgnore
    public Optional<String> getCarrierUrl() {
        return Optional.ofNullable(carrierUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code carrierUrl} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Carrier Url to activate the device eSIM”</i>
     * 
     * @param carrierUrl
     *            new value of {@code carrierUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code carrierUrl} field changed
     */
    public ActivateDeviceEsimActionResult withCarrierUrl(String carrierUrl) {
        ActivateDeviceEsimActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.activateDeviceEsimActionResult");
        _x.carrierUrl = carrierUrl;
        return _x;
    }

    public ActivateDeviceEsimActionResult withUnmappedField(String name, Object value) {
        ActivateDeviceEsimActionResult _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderActivateDeviceEsimActionResult() {
        return new Builder();
    }

    public static final class Builder {
        private String actionName;
        private ActionState actionState;
        private OffsetDateTime lastUpdatedDateTime;
        private OffsetDateTime startDateTime;
        private String carrierUrl;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder actionName(String actionName) {
            this.actionName = actionName;
            this.changedFields = changedFields.add("actionName");
            return this;
        }

        public Builder actionState(ActionState actionState) {
            this.actionState = actionState;
            this.changedFields = changedFields.add("actionState");
            return this;
        }

        public Builder lastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            this.changedFields = changedFields.add("lastUpdatedDateTime");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        /**
         * <i>“Carrier Url to activate the device eSIM”</i>
         * 
         * @param carrierUrl
         *            value of {@code carrierUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder carrierUrl(String carrierUrl) {
            this.carrierUrl = carrierUrl;
            this.changedFields = changedFields.add("carrierUrl");
            return this;
        }

        public ActivateDeviceEsimActionResult build() {
            ActivateDeviceEsimActionResult _x = new ActivateDeviceEsimActionResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.activateDeviceEsimActionResult";
            _x.actionName = actionName;
            _x.actionState = actionState;
            _x.lastUpdatedDateTime = lastUpdatedDateTime;
            _x.startDateTime = startDateTime;
            _x.carrierUrl = carrierUrl;
            return _x;
        }
    }

    private ActivateDeviceEsimActionResult _copy() {
        ActivateDeviceEsimActionResult _x = new ActivateDeviceEsimActionResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.actionName = actionName;
        _x.actionState = actionState;
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        _x.startDateTime = startDateTime;
        _x.carrierUrl = carrierUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ActivateDeviceEsimActionResult[");
        b.append("actionName=");
        b.append(this.actionName);
        b.append(", ");
        b.append("actionState=");
        b.append(this.actionState);
        b.append(", ");
        b.append("lastUpdatedDateTime=");
        b.append(this.lastUpdatedDateTime);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("carrierUrl=");
        b.append(this.carrierUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
