package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "actionUrl", 
    "stepNumber", 
    "text"})
@JsonInclude(Include.NON_NULL)
public class ActionStep implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("actionUrl")
    protected ActionUrl actionUrl;

    @JsonProperty("stepNumber")
    protected Long stepNumber;

    @JsonProperty("text")
    protected String text;

    protected ActionStep() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.actionStep";
    }

    @Property(name="actionUrl")
    @JsonIgnore
    public Optional<ActionUrl> getActionUrl() {
        return Optional.ofNullable(actionUrl);
    }

    public ActionStep withActionUrl(ActionUrl actionUrl) {
        ActionStep _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.actionStep");
        _x.actionUrl = actionUrl;
        return _x;
    }

    @Property(name="stepNumber")
    @JsonIgnore
    public Optional<Long> getStepNumber() {
        return Optional.ofNullable(stepNumber);
    }

    public ActionStep withStepNumber(Long stepNumber) {
        ActionStep _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.actionStep");
        _x.stepNumber = stepNumber;
        return _x;
    }

    @Property(name="text")
    @JsonIgnore
    public Optional<String> getText() {
        return Optional.ofNullable(text);
    }

    public ActionStep withText(String text) {
        ActionStep _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.actionStep");
        _x.text = text;
        return _x;
    }

    public ActionStep withUnmappedField(String name, Object value) {
        ActionStep _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ActionUrl actionUrl;
        private Long stepNumber;
        private String text;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder actionUrl(ActionUrl actionUrl) {
            this.actionUrl = actionUrl;
            this.changedFields = changedFields.add("actionUrl");
            return this;
        }

        public Builder stepNumber(Long stepNumber) {
            this.stepNumber = stepNumber;
            this.changedFields = changedFields.add("stepNumber");
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            this.changedFields = changedFields.add("text");
            return this;
        }

        public ActionStep build() {
            ActionStep _x = new ActionStep();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.actionStep";
            _x.actionUrl = actionUrl;
            _x.stepNumber = stepNumber;
            _x.text = text;
            return _x;
        }
    }

    private ActionStep _copy() {
        ActionStep _x = new ActionStep();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.actionUrl = actionUrl;
        _x.stepNumber = stepNumber;
        _x.text = text;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ActionStep[");
        b.append("actionUrl=");
        b.append(this.actionUrl);
        b.append(", ");
        b.append("stepNumber=");
        b.append(this.stepNumber);
        b.append(", ");
        b.append("text=");
        b.append(this.text);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
