package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "decisionsThatWillMoveToNextStage", 
    "dependsOn", 
    "durationInDays", 
    "fallbackReviewers", 
    "recommendationInsightSettings", 
    "recommendationLookBackDuration", 
    "recommendationsEnabled", 
    "reviewers", 
    "stageId"})
@JsonInclude(Include.NON_NULL)
public class AccessReviewStageSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("decisionsThatWillMoveToNextStage")
    protected List<String> decisionsThatWillMoveToNextStage;

    @JsonProperty("decisionsThatWillMoveToNextStage@nextLink")
    protected String decisionsThatWillMoveToNextStageNextLink;

    @JsonProperty("dependsOn")
    protected List<String> dependsOn;

    @JsonProperty("dependsOn@nextLink")
    protected String dependsOnNextLink;

    @JsonProperty("durationInDays")
    protected Integer durationInDays;

    @JsonProperty("fallbackReviewers")
    protected List<AccessReviewReviewerScope> fallbackReviewers;

    @JsonProperty("fallbackReviewers@nextLink")
    protected String fallbackReviewersNextLink;

    @JsonProperty("recommendationInsightSettings")
    protected List<AccessReviewRecommendationInsightSetting> recommendationInsightSettings;

    @JsonProperty("recommendationInsightSettings@nextLink")
    protected String recommendationInsightSettingsNextLink;

    @JsonProperty("recommendationLookBackDuration")
    protected Duration recommendationLookBackDuration;

    @JsonProperty("recommendationsEnabled")
    protected Boolean recommendationsEnabled;

    @JsonProperty("reviewers")
    protected List<AccessReviewReviewerScope> reviewers;

    @JsonProperty("reviewers@nextLink")
    protected String reviewersNextLink;

    @JsonProperty("stageId")
    protected String stageId;

    protected AccessReviewStageSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessReviewStageSettings";
    }

    @Property(name="decisionsThatWillMoveToNextStage")
    @JsonIgnore
    public CollectionPage<String> getDecisionsThatWillMoveToNextStage() {
        return new CollectionPage<String>(contextPath, String.class, this.decisionsThatWillMoveToNextStage, Optional.ofNullable(decisionsThatWillMoveToNextStageNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="decisionsThatWillMoveToNextStage")
    @JsonIgnore
    public CollectionPage<String> getDecisionsThatWillMoveToNextStage(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.decisionsThatWillMoveToNextStage, Optional.ofNullable(decisionsThatWillMoveToNextStageNextLink), Collections.emptyList(), options);
    }

    @Property(name="dependsOn")
    @JsonIgnore
    public CollectionPage<String> getDependsOn() {
        return new CollectionPage<String>(contextPath, String.class, this.dependsOn, Optional.ofNullable(dependsOnNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="dependsOn")
    @JsonIgnore
    public CollectionPage<String> getDependsOn(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.dependsOn, Optional.ofNullable(dependsOnNextLink), Collections.emptyList(), options);
    }

    @Property(name="durationInDays")
    @JsonIgnore
    public Optional<Integer> getDurationInDays() {
        return Optional.ofNullable(durationInDays);
    }

    public AccessReviewStageSettings withDurationInDays(Integer durationInDays) {
        AccessReviewStageSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewStageSettings");
        _x.durationInDays = durationInDays;
        return _x;
    }

    @Property(name="fallbackReviewers")
    @JsonIgnore
    public CollectionPage<AccessReviewReviewerScope> getFallbackReviewers() {
        return new CollectionPage<AccessReviewReviewerScope>(contextPath, AccessReviewReviewerScope.class, this.fallbackReviewers, Optional.ofNullable(fallbackReviewersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="fallbackReviewers")
    @JsonIgnore
    public CollectionPage<AccessReviewReviewerScope> getFallbackReviewers(HttpRequestOptions options) {
        return new CollectionPage<AccessReviewReviewerScope>(contextPath, AccessReviewReviewerScope.class, this.fallbackReviewers, Optional.ofNullable(fallbackReviewersNextLink), Collections.emptyList(), options);
    }

    @Property(name="recommendationInsightSettings")
    @JsonIgnore
    public CollectionPage<AccessReviewRecommendationInsightSetting> getRecommendationInsightSettings() {
        return new CollectionPage<AccessReviewRecommendationInsightSetting>(contextPath, AccessReviewRecommendationInsightSetting.class, this.recommendationInsightSettings, Optional.ofNullable(recommendationInsightSettingsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="recommendationInsightSettings")
    @JsonIgnore
    public CollectionPage<AccessReviewRecommendationInsightSetting> getRecommendationInsightSettings(HttpRequestOptions options) {
        return new CollectionPage<AccessReviewRecommendationInsightSetting>(contextPath, AccessReviewRecommendationInsightSetting.class, this.recommendationInsightSettings, Optional.ofNullable(recommendationInsightSettingsNextLink), Collections.emptyList(), options);
    }

    @Property(name="recommendationLookBackDuration")
    @JsonIgnore
    public Optional<Duration> getRecommendationLookBackDuration() {
        return Optional.ofNullable(recommendationLookBackDuration);
    }

    public AccessReviewStageSettings withRecommendationLookBackDuration(Duration recommendationLookBackDuration) {
        AccessReviewStageSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewStageSettings");
        _x.recommendationLookBackDuration = recommendationLookBackDuration;
        return _x;
    }

    @Property(name="recommendationsEnabled")
    @JsonIgnore
    public Optional<Boolean> getRecommendationsEnabled() {
        return Optional.ofNullable(recommendationsEnabled);
    }

    public AccessReviewStageSettings withRecommendationsEnabled(Boolean recommendationsEnabled) {
        AccessReviewStageSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewStageSettings");
        _x.recommendationsEnabled = recommendationsEnabled;
        return _x;
    }

    @Property(name="reviewers")
    @JsonIgnore
    public CollectionPage<AccessReviewReviewerScope> getReviewers() {
        return new CollectionPage<AccessReviewReviewerScope>(contextPath, AccessReviewReviewerScope.class, this.reviewers, Optional.ofNullable(reviewersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="reviewers")
    @JsonIgnore
    public CollectionPage<AccessReviewReviewerScope> getReviewers(HttpRequestOptions options) {
        return new CollectionPage<AccessReviewReviewerScope>(contextPath, AccessReviewReviewerScope.class, this.reviewers, Optional.ofNullable(reviewersNextLink), Collections.emptyList(), options);
    }

    @Property(name="stageId")
    @JsonIgnore
    public Optional<String> getStageId() {
        return Optional.ofNullable(stageId);
    }

    public AccessReviewStageSettings withStageId(String stageId) {
        AccessReviewStageSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewStageSettings");
        _x.stageId = stageId;
        return _x;
    }

    public AccessReviewStageSettings withUnmappedField(String name, Object value) {
        AccessReviewStageSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> decisionsThatWillMoveToNextStage;
        private String decisionsThatWillMoveToNextStageNextLink;
        private List<String> dependsOn;
        private String dependsOnNextLink;
        private Integer durationInDays;
        private List<AccessReviewReviewerScope> fallbackReviewers;
        private String fallbackReviewersNextLink;
        private List<AccessReviewRecommendationInsightSetting> recommendationInsightSettings;
        private String recommendationInsightSettingsNextLink;
        private Duration recommendationLookBackDuration;
        private Boolean recommendationsEnabled;
        private List<AccessReviewReviewerScope> reviewers;
        private String reviewersNextLink;
        private String stageId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder decisionsThatWillMoveToNextStage(List<String> decisionsThatWillMoveToNextStage) {
            this.decisionsThatWillMoveToNextStage = decisionsThatWillMoveToNextStage;
            this.changedFields = changedFields.add("decisionsThatWillMoveToNextStage");
            return this;
        }

        public Builder decisionsThatWillMoveToNextStage(String... decisionsThatWillMoveToNextStage) {
            return decisionsThatWillMoveToNextStage(Arrays.asList(decisionsThatWillMoveToNextStage));
        }

        public Builder decisionsThatWillMoveToNextStageNextLink(String decisionsThatWillMoveToNextStageNextLink) {
            this.decisionsThatWillMoveToNextStageNextLink = decisionsThatWillMoveToNextStageNextLink;
            this.changedFields = changedFields.add("decisionsThatWillMoveToNextStage");
            return this;
        }

        public Builder dependsOn(List<String> dependsOn) {
            this.dependsOn = dependsOn;
            this.changedFields = changedFields.add("dependsOn");
            return this;
        }

        public Builder dependsOn(String... dependsOn) {
            return dependsOn(Arrays.asList(dependsOn));
        }

        public Builder dependsOnNextLink(String dependsOnNextLink) {
            this.dependsOnNextLink = dependsOnNextLink;
            this.changedFields = changedFields.add("dependsOn");
            return this;
        }

        public Builder durationInDays(Integer durationInDays) {
            this.durationInDays = durationInDays;
            this.changedFields = changedFields.add("durationInDays");
            return this;
        }

        public Builder fallbackReviewers(List<AccessReviewReviewerScope> fallbackReviewers) {
            this.fallbackReviewers = fallbackReviewers;
            this.changedFields = changedFields.add("fallbackReviewers");
            return this;
        }

        public Builder fallbackReviewers(AccessReviewReviewerScope... fallbackReviewers) {
            return fallbackReviewers(Arrays.asList(fallbackReviewers));
        }

        public Builder fallbackReviewersNextLink(String fallbackReviewersNextLink) {
            this.fallbackReviewersNextLink = fallbackReviewersNextLink;
            this.changedFields = changedFields.add("fallbackReviewers");
            return this;
        }

        public Builder recommendationInsightSettings(List<AccessReviewRecommendationInsightSetting> recommendationInsightSettings) {
            this.recommendationInsightSettings = recommendationInsightSettings;
            this.changedFields = changedFields.add("recommendationInsightSettings");
            return this;
        }

        public Builder recommendationInsightSettings(AccessReviewRecommendationInsightSetting... recommendationInsightSettings) {
            return recommendationInsightSettings(Arrays.asList(recommendationInsightSettings));
        }

        public Builder recommendationInsightSettingsNextLink(String recommendationInsightSettingsNextLink) {
            this.recommendationInsightSettingsNextLink = recommendationInsightSettingsNextLink;
            this.changedFields = changedFields.add("recommendationInsightSettings");
            return this;
        }

        public Builder recommendationLookBackDuration(Duration recommendationLookBackDuration) {
            this.recommendationLookBackDuration = recommendationLookBackDuration;
            this.changedFields = changedFields.add("recommendationLookBackDuration");
            return this;
        }

        public Builder recommendationsEnabled(Boolean recommendationsEnabled) {
            this.recommendationsEnabled = recommendationsEnabled;
            this.changedFields = changedFields.add("recommendationsEnabled");
            return this;
        }

        public Builder reviewers(List<AccessReviewReviewerScope> reviewers) {
            this.reviewers = reviewers;
            this.changedFields = changedFields.add("reviewers");
            return this;
        }

        public Builder reviewers(AccessReviewReviewerScope... reviewers) {
            return reviewers(Arrays.asList(reviewers));
        }

        public Builder reviewersNextLink(String reviewersNextLink) {
            this.reviewersNextLink = reviewersNextLink;
            this.changedFields = changedFields.add("reviewers");
            return this;
        }

        public Builder stageId(String stageId) {
            this.stageId = stageId;
            this.changedFields = changedFields.add("stageId");
            return this;
        }

        public AccessReviewStageSettings build() {
            AccessReviewStageSettings _x = new AccessReviewStageSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessReviewStageSettings";
            _x.decisionsThatWillMoveToNextStage = decisionsThatWillMoveToNextStage;
            _x.decisionsThatWillMoveToNextStageNextLink = decisionsThatWillMoveToNextStageNextLink;
            _x.dependsOn = dependsOn;
            _x.dependsOnNextLink = dependsOnNextLink;
            _x.durationInDays = durationInDays;
            _x.fallbackReviewers = fallbackReviewers;
            _x.fallbackReviewersNextLink = fallbackReviewersNextLink;
            _x.recommendationInsightSettings = recommendationInsightSettings;
            _x.recommendationInsightSettingsNextLink = recommendationInsightSettingsNextLink;
            _x.recommendationLookBackDuration = recommendationLookBackDuration;
            _x.recommendationsEnabled = recommendationsEnabled;
            _x.reviewers = reviewers;
            _x.reviewersNextLink = reviewersNextLink;
            _x.stageId = stageId;
            return _x;
        }
    }

    private AccessReviewStageSettings _copy() {
        AccessReviewStageSettings _x = new AccessReviewStageSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.decisionsThatWillMoveToNextStage = decisionsThatWillMoveToNextStage;
        _x.dependsOn = dependsOn;
        _x.durationInDays = durationInDays;
        _x.fallbackReviewers = fallbackReviewers;
        _x.recommendationInsightSettings = recommendationInsightSettings;
        _x.recommendationLookBackDuration = recommendationLookBackDuration;
        _x.recommendationsEnabled = recommendationsEnabled;
        _x.reviewers = reviewers;
        _x.stageId = stageId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessReviewStageSettings[");
        b.append("decisionsThatWillMoveToNextStage=");
        b.append(this.decisionsThatWillMoveToNextStage);
        b.append(", ");
        b.append("dependsOn=");
        b.append(this.dependsOn);
        b.append(", ");
        b.append("durationInDays=");
        b.append(this.durationInDays);
        b.append(", ");
        b.append("fallbackReviewers=");
        b.append(this.fallbackReviewers);
        b.append(", ");
        b.append("recommendationInsightSettings=");
        b.append(this.recommendationInsightSettings);
        b.append(", ");
        b.append("recommendationLookBackDuration=");
        b.append(this.recommendationLookBackDuration);
        b.append(", ");
        b.append("recommendationsEnabled=");
        b.append(this.recommendationsEnabled);
        b.append(", ");
        b.append("reviewers=");
        b.append(this.reviewers);
        b.append(", ");
        b.append("stageId=");
        b.append(this.stageId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
