package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "appId", 
    "servicePrincipalDisplayName", 
    "servicePrincipalId"})
@JsonInclude(Include.NON_NULL)
public class AccessReviewInstanceDecisionItemServicePrincipalTarget extends AccessReviewInstanceDecisionItemTarget implements ODataType {

    @JsonProperty("appId")
    protected String appId;

    @JsonProperty("servicePrincipalDisplayName")
    protected String servicePrincipalDisplayName;

    @JsonProperty("servicePrincipalId")
    protected String servicePrincipalId;

    protected AccessReviewInstanceDecisionItemServicePrincipalTarget() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessReviewInstanceDecisionItemServicePrincipalTarget";
    }

    @Property(name="appId")
    @JsonIgnore
    public Optional<String> getAppId() {
        return Optional.ofNullable(appId);
    }

    public AccessReviewInstanceDecisionItemServicePrincipalTarget withAppId(String appId) {
        AccessReviewInstanceDecisionItemServicePrincipalTarget _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItemServicePrincipalTarget");
        _x.appId = appId;
        return _x;
    }

    @Property(name="servicePrincipalDisplayName")
    @JsonIgnore
    public Optional<String> getServicePrincipalDisplayName() {
        return Optional.ofNullable(servicePrincipalDisplayName);
    }

    public AccessReviewInstanceDecisionItemServicePrincipalTarget withServicePrincipalDisplayName(String servicePrincipalDisplayName) {
        AccessReviewInstanceDecisionItemServicePrincipalTarget _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItemServicePrincipalTarget");
        _x.servicePrincipalDisplayName = servicePrincipalDisplayName;
        return _x;
    }

    @Property(name="servicePrincipalId")
    @JsonIgnore
    public Optional<String> getServicePrincipalId() {
        return Optional.ofNullable(servicePrincipalId);
    }

    public AccessReviewInstanceDecisionItemServicePrincipalTarget withServicePrincipalId(String servicePrincipalId) {
        AccessReviewInstanceDecisionItemServicePrincipalTarget _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItemServicePrincipalTarget");
        _x.servicePrincipalId = servicePrincipalId;
        return _x;
    }

    public AccessReviewInstanceDecisionItemServicePrincipalTarget withUnmappedField(String name, Object value) {
        AccessReviewInstanceDecisionItemServicePrincipalTarget _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessReviewInstanceDecisionItemServicePrincipalTarget() {
        return new Builder();
    }

    public static final class Builder {
        private String appId;
        private String servicePrincipalDisplayName;
        private String servicePrincipalId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder appId(String appId) {
            this.appId = appId;
            this.changedFields = changedFields.add("appId");
            return this;
        }

        public Builder servicePrincipalDisplayName(String servicePrincipalDisplayName) {
            this.servicePrincipalDisplayName = servicePrincipalDisplayName;
            this.changedFields = changedFields.add("servicePrincipalDisplayName");
            return this;
        }

        public Builder servicePrincipalId(String servicePrincipalId) {
            this.servicePrincipalId = servicePrincipalId;
            this.changedFields = changedFields.add("servicePrincipalId");
            return this;
        }

        public AccessReviewInstanceDecisionItemServicePrincipalTarget build() {
            AccessReviewInstanceDecisionItemServicePrincipalTarget _x = new AccessReviewInstanceDecisionItemServicePrincipalTarget();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessReviewInstanceDecisionItemServicePrincipalTarget";
            _x.appId = appId;
            _x.servicePrincipalDisplayName = servicePrincipalDisplayName;
            _x.servicePrincipalId = servicePrincipalId;
            return _x;
        }
    }

    private AccessReviewInstanceDecisionItemServicePrincipalTarget _copy() {
        AccessReviewInstanceDecisionItemServicePrincipalTarget _x = new AccessReviewInstanceDecisionItemServicePrincipalTarget();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.appId = appId;
        _x.servicePrincipalDisplayName = servicePrincipalDisplayName;
        _x.servicePrincipalId = servicePrincipalId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessReviewInstanceDecisionItemServicePrincipalTarget[");
        b.append("appId=");
        b.append(this.appId);
        b.append(", ");
        b.append("servicePrincipalDisplayName=");
        b.append(this.servicePrincipalDisplayName);
        b.append(", ");
        b.append("servicePrincipalId=");
        b.append(this.servicePrincipalId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
