package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "scope"})
@JsonInclude(Include.NON_NULL)
public class AccessReviewInstanceDecisionItemAzureRoleResource extends AccessReviewInstanceDecisionItemResource implements ODataType {

    @JsonProperty("scope")
    protected AccessReviewInstanceDecisionItemResource scope;

    protected AccessReviewInstanceDecisionItemAzureRoleResource() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessReviewInstanceDecisionItemAzureRoleResource";
    }

    @Property(name="scope")
    @JsonIgnore
    public Optional<AccessReviewInstanceDecisionItemResource> getScope() {
        return Optional.ofNullable(scope);
    }

    public AccessReviewInstanceDecisionItemAzureRoleResource withScope(AccessReviewInstanceDecisionItemResource scope) {
        AccessReviewInstanceDecisionItemAzureRoleResource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItemAzureRoleResource");
        _x.scope = scope;
        return _x;
    }

    public AccessReviewInstanceDecisionItemAzureRoleResource withUnmappedField(String name, Object value) {
        AccessReviewInstanceDecisionItemAzureRoleResource _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessReviewInstanceDecisionItemAzureRoleResource() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private String id;
        private String type;
        private AccessReviewInstanceDecisionItemResource scope;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder scope(AccessReviewInstanceDecisionItemResource scope) {
            this.scope = scope;
            this.changedFields = changedFields.add("scope");
            return this;
        }

        public AccessReviewInstanceDecisionItemAzureRoleResource build() {
            AccessReviewInstanceDecisionItemAzureRoleResource _x = new AccessReviewInstanceDecisionItemAzureRoleResource();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessReviewInstanceDecisionItemAzureRoleResource";
            _x.displayName = displayName;
            _x.id = id;
            _x.type = type;
            _x.scope = scope;
            return _x;
        }
    }

    private AccessReviewInstanceDecisionItemAzureRoleResource _copy() {
        AccessReviewInstanceDecisionItemAzureRoleResource _x = new AccessReviewInstanceDecisionItemAzureRoleResource();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.id = id;
        _x.type = type;
        _x.scope = scope;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessReviewInstanceDecisionItemAzureRoleResource[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("scope=");
        b.append(this.scope);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
