package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "attributeDestination", 
    "attributeName", 
    "attributeSource", 
    "id", 
    "isEditable", 
    "isPersistedOnAssignmentRemoval"})
@JsonInclude(Include.NON_NULL)
public class AccessPackageResourceAttribute implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("attributeDestination")
    protected AccessPackageResourceAttributeDestination attributeDestination;

    @JsonProperty("attributeName")
    protected String attributeName;

    @JsonProperty("attributeSource")
    protected AccessPackageResourceAttributeSource attributeSource;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("isEditable")
    protected Boolean isEditable;

    @JsonProperty("isPersistedOnAssignmentRemoval")
    protected Boolean isPersistedOnAssignmentRemoval;

    protected AccessPackageResourceAttribute() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessPackageResourceAttribute";
    }

    @Property(name="attributeDestination")
    @JsonIgnore
    public Optional<AccessPackageResourceAttributeDestination> getAttributeDestination() {
        return Optional.ofNullable(attributeDestination);
    }

    public AccessPackageResourceAttribute withAttributeDestination(AccessPackageResourceAttributeDestination attributeDestination) {
        AccessPackageResourceAttribute _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceAttribute");
        _x.attributeDestination = attributeDestination;
        return _x;
    }

    @Property(name="attributeName")
    @JsonIgnore
    public Optional<String> getAttributeName() {
        return Optional.ofNullable(attributeName);
    }

    public AccessPackageResourceAttribute withAttributeName(String attributeName) {
        AccessPackageResourceAttribute _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceAttribute");
        _x.attributeName = attributeName;
        return _x;
    }

    @Property(name="attributeSource")
    @JsonIgnore
    public Optional<AccessPackageResourceAttributeSource> getAttributeSource() {
        return Optional.ofNullable(attributeSource);
    }

    public AccessPackageResourceAttribute withAttributeSource(AccessPackageResourceAttributeSource attributeSource) {
        AccessPackageResourceAttribute _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceAttribute");
        _x.attributeSource = attributeSource;
        return _x;
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public AccessPackageResourceAttribute withId(String id) {
        AccessPackageResourceAttribute _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceAttribute");
        _x.id = id;
        return _x;
    }

    @Property(name="isEditable")
    @JsonIgnore
    public Optional<Boolean> getIsEditable() {
        return Optional.ofNullable(isEditable);
    }

    public AccessPackageResourceAttribute withIsEditable(Boolean isEditable) {
        AccessPackageResourceAttribute _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceAttribute");
        _x.isEditable = isEditable;
        return _x;
    }

    @Property(name="isPersistedOnAssignmentRemoval")
    @JsonIgnore
    public Optional<Boolean> getIsPersistedOnAssignmentRemoval() {
        return Optional.ofNullable(isPersistedOnAssignmentRemoval);
    }

    public AccessPackageResourceAttribute withIsPersistedOnAssignmentRemoval(Boolean isPersistedOnAssignmentRemoval) {
        AccessPackageResourceAttribute _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceAttribute");
        _x.isPersistedOnAssignmentRemoval = isPersistedOnAssignmentRemoval;
        return _x;
    }

    public AccessPackageResourceAttribute withUnmappedField(String name, Object value) {
        AccessPackageResourceAttribute _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AccessPackageResourceAttributeDestination attributeDestination;
        private String attributeName;
        private AccessPackageResourceAttributeSource attributeSource;
        private String id;
        private Boolean isEditable;
        private Boolean isPersistedOnAssignmentRemoval;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder attributeDestination(AccessPackageResourceAttributeDestination attributeDestination) {
            this.attributeDestination = attributeDestination;
            this.changedFields = changedFields.add("attributeDestination");
            return this;
        }

        public Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            this.changedFields = changedFields.add("attributeName");
            return this;
        }

        public Builder attributeSource(AccessPackageResourceAttributeSource attributeSource) {
            this.attributeSource = attributeSource;
            this.changedFields = changedFields.add("attributeSource");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder isEditable(Boolean isEditable) {
            this.isEditable = isEditable;
            this.changedFields = changedFields.add("isEditable");
            return this;
        }

        public Builder isPersistedOnAssignmentRemoval(Boolean isPersistedOnAssignmentRemoval) {
            this.isPersistedOnAssignmentRemoval = isPersistedOnAssignmentRemoval;
            this.changedFields = changedFields.add("isPersistedOnAssignmentRemoval");
            return this;
        }

        public AccessPackageResourceAttribute build() {
            AccessPackageResourceAttribute _x = new AccessPackageResourceAttribute();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessPackageResourceAttribute";
            _x.attributeDestination = attributeDestination;
            _x.attributeName = attributeName;
            _x.attributeSource = attributeSource;
            _x.id = id;
            _x.isEditable = isEditable;
            _x.isPersistedOnAssignmentRemoval = isPersistedOnAssignmentRemoval;
            return _x;
        }
    }

    private AccessPackageResourceAttribute _copy() {
        AccessPackageResourceAttribute _x = new AccessPackageResourceAttribute();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.attributeDestination = attributeDestination;
        _x.attributeName = attributeName;
        _x.attributeSource = attributeSource;
        _x.id = id;
        _x.isEditable = isEditable;
        _x.isPersistedOnAssignmentRemoval = isPersistedOnAssignmentRemoval;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessPackageResourceAttribute[");
        b.append("attributeDestination=");
        b.append(this.attributeDestination);
        b.append(", ");
        b.append("attributeName=");
        b.append(this.attributeName);
        b.append(", ");
        b.append("attributeSource=");
        b.append(this.attributeSource);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("isEditable=");
        b.append(this.isEditable);
        b.append(", ");
        b.append("isPersistedOnAssignmentRemoval=");
        b.append(this.isPersistedOnAssignmentRemoval);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
