package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "id", 
    "isAnswerEditable", 
    "isRequired", 
    "sequence", 
    "text"})
@JsonInclude(Include.NON_NULL)
public class AccessPackageQuestion implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("isAnswerEditable")
    protected Boolean isAnswerEditable;

    @JsonProperty("isRequired")
    protected Boolean isRequired;

    @JsonProperty("sequence")
    protected Integer sequence;

    @JsonProperty("text")
    protected AccessPackageLocalizedContent text;

    protected AccessPackageQuestion() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessPackageQuestion";
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public AccessPackageQuestion withId(String id) {
        AccessPackageQuestion _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageQuestion");
        _x.id = id;
        return _x;
    }

    @Property(name="isAnswerEditable")
    @JsonIgnore
    public Optional<Boolean> getIsAnswerEditable() {
        return Optional.ofNullable(isAnswerEditable);
    }

    public AccessPackageQuestion withIsAnswerEditable(Boolean isAnswerEditable) {
        AccessPackageQuestion _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageQuestion");
        _x.isAnswerEditable = isAnswerEditable;
        return _x;
    }

    @Property(name="isRequired")
    @JsonIgnore
    public Optional<Boolean> getIsRequired() {
        return Optional.ofNullable(isRequired);
    }

    public AccessPackageQuestion withIsRequired(Boolean isRequired) {
        AccessPackageQuestion _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageQuestion");
        _x.isRequired = isRequired;
        return _x;
    }

    @Property(name="sequence")
    @JsonIgnore
    public Optional<Integer> getSequence() {
        return Optional.ofNullable(sequence);
    }

    public AccessPackageQuestion withSequence(Integer sequence) {
        AccessPackageQuestion _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageQuestion");
        _x.sequence = sequence;
        return _x;
    }

    @Property(name="text")
    @JsonIgnore
    public Optional<AccessPackageLocalizedContent> getText() {
        return Optional.ofNullable(text);
    }

    public AccessPackageQuestion withText(AccessPackageLocalizedContent text) {
        AccessPackageQuestion _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageQuestion");
        _x.text = text;
        return _x;
    }

    public AccessPackageQuestion withUnmappedField(String name, Object value) {
        AccessPackageQuestion _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    private AccessPackageQuestion _copy() {
        AccessPackageQuestion _x = new AccessPackageQuestion();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.isAnswerEditable = isAnswerEditable;
        _x.isRequired = isRequired;
        _x.sequence = sequence;
        _x.text = text;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessPackageQuestion[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("isAnswerEditable=");
        b.append(this.isAnswerEditable);
        b.append(", ");
        b.append("isRequired=");
        b.append(this.isRequired);
        b.append(", ");
        b.append("sequence=");
        b.append(this.sequence);
        b.append(", ");
        b.append("text=");
        b.append(this.text);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
