package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "languageCode", 
    "text"})
@JsonInclude(Include.NON_NULL)
public class AccessPackageLocalizedText implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("languageCode")
    protected String languageCode;

    @JsonProperty("text")
    protected String text;

    protected AccessPackageLocalizedText() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessPackageLocalizedText";
    }

    @Property(name="languageCode")
    @JsonIgnore
    public Optional<String> getLanguageCode() {
        return Optional.ofNullable(languageCode);
    }

    public AccessPackageLocalizedText withLanguageCode(String languageCode) {
        AccessPackageLocalizedText _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageLocalizedText");
        _x.languageCode = languageCode;
        return _x;
    }

    @Property(name="text")
    @JsonIgnore
    public Optional<String> getText() {
        return Optional.ofNullable(text);
    }

    public AccessPackageLocalizedText withText(String text) {
        AccessPackageLocalizedText _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageLocalizedText");
        _x.text = text;
        return _x;
    }

    public AccessPackageLocalizedText withUnmappedField(String name, Object value) {
        AccessPackageLocalizedText _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String languageCode;
        private String text;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            this.changedFields = changedFields.add("languageCode");
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            this.changedFields = changedFields.add("text");
            return this;
        }

        public AccessPackageLocalizedText build() {
            AccessPackageLocalizedText _x = new AccessPackageLocalizedText();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.accessPackageLocalizedText";
            _x.languageCode = languageCode;
            _x.text = text;
            return _x;
        }
    }

    private AccessPackageLocalizedText _copy() {
        AccessPackageLocalizedText _x = new AccessPackageLocalizedText();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.languageCode = languageCode;
        _x.text = text;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessPackageLocalizedText[");
        b.append("languageCode=");
        b.append(this.languageCode);
        b.append(", ");
        b.append("text=");
        b.append(this.text);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
