package odata.msgraph.client.beta.callRecords.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ServiceRole implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("customBot")
    CUSTOM_BOT("customBot", "1"),

    @JsonProperty("skypeForBusinessMicrosoftTeamsGateway")
    SKYPE_FOR_BUSINESS_MICROSOFT_TEAMS_GATEWAY("skypeForBusinessMicrosoftTeamsGateway", "2"),

    @JsonProperty("skypeForBusinessAudioVideoMcu")
    SKYPE_FOR_BUSINESS_AUDIO_VIDEO_MCU("skypeForBusinessAudioVideoMcu", "3"),

    @JsonProperty("skypeForBusinessApplicationSharingMcu")
    SKYPE_FOR_BUSINESS_APPLICATION_SHARING_MCU("skypeForBusinessApplicationSharingMcu", "4"),

    @JsonProperty("skypeForBusinessCallQueues")
    SKYPE_FOR_BUSINESS_CALL_QUEUES("skypeForBusinessCallQueues", "5"),

    @JsonProperty("skypeForBusinessAutoAttendant")
    SKYPE_FOR_BUSINESS_AUTO_ATTENDANT("skypeForBusinessAutoAttendant", "6"),

    @JsonProperty("mediationServer")
    MEDIATION_SERVER("mediationServer", "7"),

    @JsonProperty("mediationServerCloudConnectorEdition")
    MEDIATION_SERVER_CLOUD_CONNECTOR_EDITION("mediationServerCloudConnectorEdition", "8"),

    @JsonProperty("exchangeUnifiedMessagingService")
    EXCHANGE_UNIFIED_MESSAGING_SERVICE("exchangeUnifiedMessagingService", "9"),

    @JsonProperty("mediaController")
    MEDIA_CONTROLLER("mediaController", "10"),

    @JsonProperty("conferencingAnnouncementService")
    CONFERENCING_ANNOUNCEMENT_SERVICE("conferencingAnnouncementService", "11"),

    @JsonProperty("conferencingAttendant")
    CONFERENCING_ATTENDANT("conferencingAttendant", "12"),

    @JsonProperty("audioTeleconferencerController")
    AUDIO_TELECONFERENCER_CONTROLLER("audioTeleconferencerController", "13"),

    @JsonProperty("skypeForBusinessUnifiedCommunicationApplicationPlatform")
    SKYPE_FOR_BUSINESS_UNIFIED_COMMUNICATION_APPLICATION_PLATFORM("skypeForBusinessUnifiedCommunicationApplicationPlatform", "14"),

    @JsonProperty("responseGroupServiceAnnouncementService")
    RESPONSE_GROUP_SERVICE_ANNOUNCEMENT_SERVICE("responseGroupServiceAnnouncementService", "15"),

    @JsonProperty("gateway")
    GATEWAY("gateway", "16"),

    @JsonProperty("skypeTranslator")
    SKYPE_TRANSLATOR("skypeTranslator", "17"),

    @JsonProperty("skypeForBusinessAttendant")
    SKYPE_FOR_BUSINESS_ATTENDANT("skypeForBusinessAttendant", "18"),

    @JsonProperty("responseGroupService")
    RESPONSE_GROUP_SERVICE("responseGroupService", "19"),

    @JsonProperty("voicemail")
    VOICEMAIL("voicemail", "20"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "21");

    private final String name;
    private final String value;

    private ServiceRole(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
