package odata.msgraph.client.beta.callRecords.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.callRecords.entity.Session;
import odata.msgraph.client.beta.callRecords.entity.collection.request.SegmentCollectionRequest;

@JsonIgnoreType
public class SessionRequest extends EntityRequest<Session> {

    public SessionRequest(ContextPath contextPath, Optional<Object> value) {
        super(Session.class, contextPath, value, false);
    }

    public SegmentRequest segments(String id) {
        return new SegmentRequest(contextPath.addSegment("segments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SegmentCollectionRequest segments() {
        return new SegmentCollectionRequest(
                        contextPath.addSegment("segments"), Optional.empty());
    }

}
