package odata.msgraph.client.beta.callRecords.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.callRecords.entity.Session;
import odata.msgraph.client.beta.callRecords.entity.request.SegmentRequest;
import odata.msgraph.client.beta.callRecords.entity.request.SessionRequest;

public class SessionCollectionRequest extends CollectionPageEntityRequest<Session, SessionRequest>{

    protected ContextPath contextPath;

    public SessionCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Session.class, cp -> new SessionRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SegmentRequest segments(String id) {
        return new SegmentRequest(contextPath.addSegment("segments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SegmentCollectionRequest segments() {
        return new SegmentCollectionRequest(contextPath.addSegment("segments"), Optional.empty());
    }

}
