package odata.msgraph.client.beta.callRecords.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.callRecords.complex.DirectRoutingLogRow;
import odata.msgraph.client.beta.callRecords.complex.PstnCallLogRow;
import odata.msgraph.client.beta.callRecords.entity.CallRecord;
import odata.msgraph.client.beta.callRecords.entity.request.CallRecordRequest;
import odata.msgraph.client.beta.callRecords.entity.request.SessionRequest;

public class CallRecordCollectionRequest extends CollectionPageEntityRequest<CallRecord, CallRecordRequest>{

    protected ContextPath contextPath;

    public CallRecordCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, CallRecord.class, cp -> new CallRecordRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SessionRequest sessions(String id) {
        return new SessionRequest(contextPath.addSegment("sessions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SessionCollectionRequest sessions() {
        return new SessionCollectionRequest(contextPath.addSegment("sessions"), Optional.empty());
    }

    @Function(name = "getDirectRoutingCalls")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DirectRoutingLogRow> getDirectRoutingCalls(OffsetDateTime fromDateTime, OffsetDateTime toDateTime) {
        Preconditions.checkNotNull(fromDateTime, "fromDateTime cannot be null");
        Preconditions.checkNotNull(toDateTime, "toDateTime cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("fromDateTime", "Edm.DateTimeOffset", fromDateTime)
            .put("toDateTime", "Edm.DateTimeOffset", toDateTime)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.callRecords.getDirectRoutingCalls"), DirectRoutingLogRow.class, _parameters);
    }

    @Function(name = "getPstnCalls")
    @JsonIgnore
    public CollectionPageNonEntityRequest<PstnCallLogRow> getPstnCalls(OffsetDateTime fromDateTime, OffsetDateTime toDateTime) {
        Preconditions.checkNotNull(fromDateTime, "fromDateTime cannot be null");
        Preconditions.checkNotNull(toDateTime, "toDateTime cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("fromDateTime", "Edm.DateTimeOffset", fromDateTime)
            .put("toDateTime", "Edm.DateTimeOffset", toDateTime)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.callRecords.getPstnCalls"), PstnCallLogRow.class, _parameters);
    }

}
