package odata.msgraph.client.beta.callRecords.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.callRecords.complex.Endpoint;
import odata.msgraph.client.beta.callRecords.complex.FailureInfo;
import odata.msgraph.client.beta.callRecords.complex.Media;
import odata.msgraph.client.beta.entity.Entity;

@JsonPropertyOrder({
    "@odata.type", 
    "callee", 
    "caller", 
    "endDateTime", 
    "failureInfo", 
    "media", 
    "startDateTime"})
@JsonInclude(Include.NON_NULL)
public class Segment extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.callRecords.segment";
    }

    @JsonProperty("callee")
    protected Endpoint callee;

    @JsonProperty("caller")
    protected Endpoint caller;

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("failureInfo")
    protected FailureInfo failureInfo;

    @JsonProperty("media")
    protected List<Media> media;

    @JsonProperty("media@nextLink")
    protected String mediaNextLink;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    protected Segment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSegment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Endpoint callee;
        private Endpoint caller;
        private OffsetDateTime endDateTime;
        private FailureInfo failureInfo;
        private List<Media> media;
        private String mediaNextLink;
        private OffsetDateTime startDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder callee(Endpoint callee) {
            this.callee = callee;
            this.changedFields = changedFields.add("callee");
            return this;
        }

        public Builder caller(Endpoint caller) {
            this.caller = caller;
            this.changedFields = changedFields.add("caller");
            return this;
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder failureInfo(FailureInfo failureInfo) {
            this.failureInfo = failureInfo;
            this.changedFields = changedFields.add("failureInfo");
            return this;
        }

        public Builder media(List<Media> media) {
            this.media = media;
            this.changedFields = changedFields.add("media");
            return this;
        }

        public Builder media(Media... media) {
            return media(Arrays.asList(media));
        }

        public Builder mediaNextLink(String mediaNextLink) {
            this.mediaNextLink = mediaNextLink;
            this.changedFields = changedFields.add("media");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Segment build() {
            Segment _x = new Segment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.callRecords.segment";
            _x.id = id;
            _x.callee = callee;
            _x.caller = caller;
            _x.endDateTime = endDateTime;
            _x.failureInfo = failureInfo;
            _x.media = media;
            _x.mediaNextLink = mediaNextLink;
            _x.startDateTime = startDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="callee")
    @JsonIgnore
    public Optional<Endpoint> getCallee() {
        return Optional.ofNullable(callee);
    }

    public Segment withCallee(Endpoint callee) {
        Segment _x = _copy();
        _x.changedFields = changedFields.add("callee");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.segment");
        _x.callee = callee;
        return _x;
    }

    @Property(name="caller")
    @JsonIgnore
    public Optional<Endpoint> getCaller() {
        return Optional.ofNullable(caller);
    }

    public Segment withCaller(Endpoint caller) {
        Segment _x = _copy();
        _x.changedFields = changedFields.add("caller");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.segment");
        _x.caller = caller;
        return _x;
    }

    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    public Segment withEndDateTime(OffsetDateTime endDateTime) {
        Segment _x = _copy();
        _x.changedFields = changedFields.add("endDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.segment");
        _x.endDateTime = endDateTime;
        return _x;
    }

    @Property(name="failureInfo")
    @JsonIgnore
    public Optional<FailureInfo> getFailureInfo() {
        return Optional.ofNullable(failureInfo);
    }

    public Segment withFailureInfo(FailureInfo failureInfo) {
        Segment _x = _copy();
        _x.changedFields = changedFields.add("failureInfo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.segment");
        _x.failureInfo = failureInfo;
        return _x;
    }

    @Property(name="media")
    @JsonIgnore
    public CollectionPage<Media> getMedia() {
        return new CollectionPage<Media>(contextPath, Media.class, this.media, Optional.ofNullable(mediaNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Segment withMedia(List<Media> media) {
        Segment _x = _copy();
        _x.changedFields = changedFields.add("media");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.segment");
        _x.media = media;
        return _x;
    }

    @Property(name="media")
    @JsonIgnore
    public CollectionPage<Media> getMedia(HttpRequestOptions options) {
        return new CollectionPage<Media>(contextPath, Media.class, this.media, Optional.ofNullable(mediaNextLink), Collections.emptyList(), options);
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public Segment withStartDateTime(OffsetDateTime startDateTime) {
        Segment _x = _copy();
        _x.changedFields = changedFields.add("startDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.segment");
        _x.startDateTime = startDateTime;
        return _x;
    }

    public Segment withUnmappedField(String name, Object value) {
        Segment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Segment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Segment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Segment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Segment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Segment _copy() {
        Segment _x = new Segment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.callee = callee;
        _x.caller = caller;
        _x.endDateTime = endDateTime;
        _x.failureInfo = failureInfo;
        _x.media = media;
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Segment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("callee=");
        b.append(this.callee);
        b.append(", ");
        b.append("caller=");
        b.append(this.caller);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("failureInfo=");
        b.append(this.failureInfo);
        b.append(", ");
        b.append("media=");
        b.append(this.media);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
