package odata.msgraph.client.beta.callRecords.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;

@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class ServiceEndpoint extends Endpoint implements ODataType {

    protected ServiceEndpoint() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.callRecords.serviceEndpoint";
    }

    public ServiceEndpoint withUnmappedField(String name, Object value) {
        ServiceEndpoint _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderServiceEndpoint() {
        return new Builder();
    }

    public static final class Builder {
        private UserAgent userAgent;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder userAgent(UserAgent userAgent) {
            this.userAgent = userAgent;
            this.changedFields = changedFields.add("userAgent");
            return this;
        }

        public ServiceEndpoint build() {
            ServiceEndpoint _x = new ServiceEndpoint();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.callRecords.serviceEndpoint";
            _x.userAgent = userAgent;
            return _x;
        }
    }

    private ServiceEndpoint _copy() {
        ServiceEndpoint _x = new ServiceEndpoint();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.userAgent = userAgent;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ServiceEndpoint[");
        b.append("userAgent=");
        b.append(this.userAgent);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
