package odata.msgraph.client.beta.callRecords.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.callRecords.enums.PstnCallDurationSource;

@JsonPropertyOrder({
    "@odata.type", 
    "callDurationSource", 
    "calleeNumber", 
    "callerNumber", 
    "callId", 
    "callType", 
    "charge", 
    "conferenceId", 
    "connectionCharge", 
    "currency", 
    "destinationContext", 
    "destinationName", 
    "duration", 
    "endDateTime", 
    "id", 
    "inventoryType", 
    "licenseCapability", 
    "operator", 
    "startDateTime", 
    "tenantCountryCode", 
    "usageCountryCode", 
    "userDisplayName", 
    "userId", 
    "userPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class PstnCallLogRow implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("callDurationSource")
    protected PstnCallDurationSource callDurationSource;

    @JsonProperty("calleeNumber")
    protected String calleeNumber;

    @JsonProperty("callerNumber")
    protected String callerNumber;

    @JsonProperty("callId")
    protected String callId;

    @JsonProperty("callType")
    protected String callType;

    @JsonProperty("charge")
    protected BigDecimal charge;

    @JsonProperty("conferenceId")
    protected String conferenceId;

    @JsonProperty("connectionCharge")
    protected BigDecimal connectionCharge;

    @JsonProperty("currency")
    protected String currency;

    @JsonProperty("destinationContext")
    protected String destinationContext;

    @JsonProperty("destinationName")
    protected String destinationName;

    @JsonProperty("duration")
    protected Integer duration;

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("inventoryType")
    protected String inventoryType;

    @JsonProperty("licenseCapability")
    protected String licenseCapability;

    @JsonProperty("operator")
    protected String operator;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("tenantCountryCode")
    protected String tenantCountryCode;

    @JsonProperty("usageCountryCode")
    protected String usageCountryCode;

    @JsonProperty("userDisplayName")
    protected String userDisplayName;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    protected PstnCallLogRow() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.callRecords.pstnCallLogRow";
    }

    @Property(name="callDurationSource")
    @JsonIgnore
    public Optional<PstnCallDurationSource> getCallDurationSource() {
        return Optional.ofNullable(callDurationSource);
    }

    public PstnCallLogRow withCallDurationSource(PstnCallDurationSource callDurationSource) {
        PstnCallLogRow _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.pstnCallLogRow");
        _x.callDurationSource = callDurationSource;
        return _x;
    }

    @Property(name="calleeNumber")
    @JsonIgnore
    public Optional<String> getCalleeNumber() {
        return Optional.ofNullable(calleeNumber);
    }

    public PstnCallLogRow withCalleeNumber(String calleeNumber) {
        PstnCallLogRow _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.pstnCallLogRow");
        _x.calleeNumber = calleeNumber;
        return _x;
    }

    @Property(name="callerNumber")
    @JsonIgnore
    public Optional<String> getCallerNumber() {
        return Optional.ofNullable(callerNumber);
    }

    public PstnCallLogRow withCallerNumber(String callerNumber) {
        PstnCallLogRow _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.pstnCallLogRow");
        _x.callerNumber = callerNumber;
        return _x;
    }

    @Property(name="callId")
    @JsonIgnore
    public Optional<String> getCallId() {
        return Optional.ofNullable(callId);
    }

    public PstnCallLogRow withCallId(String callId) {
        PstnCallLogRow _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.pstnCallLogRow");
        _x.callId = callId;
        return _x;
    }

    @Property(name="callType")
    @JsonIgnore
    public Optional<String> getCallType() {
        return Optional.ofNullable(callType);
    }

    public PstnCallLogRow withCallType(String callType) {
        PstnCallLogRow _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.pstnCallLogRow");
        _x.callType = callType;
        return _x;
    }

    @Property(name="charge")
    @JsonIgnore
    public Optional<BigDecimal> getCharge() {
        return Optional.ofNullable(charge);
    }

    public PstnCallLogRow withCharge(BigDecimal charge) {
        PstnCallLogRow _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.pstnCallLogRow");
        _x.charge = charge;
        return _x;
    }

    @Property(name="conferenceId")
    @JsonIgnore
    public Optional<String> getConferenceId() {
        return Optional.ofNullable(conferenceId);
    }

    public PstnCallLogRow withConferenceId(String conferenceId) {
        PstnCallLogRow _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.pstnCallLogRow");
        _x.conferenceId = conferenceId;
        return _x;
    }

    @Property(name="connectionCharge")
    @JsonIgnore
    public Optional<BigDecimal> getConnectionCharge() {
        return Optional.ofNullable(connectionCharge);
    }

    public PstnCallLogRow withConnectionCharge(BigDecimal connectionCharge) {
        PstnCallLogRow _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.pstnCallLogRow");
        _x.connectionCharge = connectionCharge;
        return _x;
    }

    @Property(name="currency")
    @JsonIgnore
    public Optional<String> getCurrency() {
        return Optional.ofNullable(currency);
    }

    public PstnCallLogRow withCurrency(String currency) {
        PstnCallLogRow _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.pstnCallLogRow");
        _x.currency = currency;
        return _x;
    }

    @Property(name="destinationContext")
    @JsonIgnore
    public Optional<String> getDestinationContext() {
        return Optional.ofNullable(destinationContext);
    }

    public PstnCallLogRow withDestinationContext(String destinationContext) {
        PstnCallLogRow _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.pstnCallLogRow");
        _x.destinationContext = destinationContext;
        return _x;
    }

    @Property(name="destinationName")
    @JsonIgnore
    public Optional<String> getDestinationName() {
        return Optional.ofNullable(destinationName);
    }

    public PstnCallLogRow withDestinationName(String destinationName) {
        PstnCallLogRow _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.pstnCallLogRow");
        _x.destinationName = destinationName;
        return _x;
    }

    @Property(name="duration")
    @JsonIgnore
    public Optional<Integer> getDuration() {
        return Optional.ofNullable(duration);
    }

    public PstnCallLogRow withDuration(Integer duration) {
        PstnCallLogRow _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.pstnCallLogRow");
        _x.duration = duration;
        return _x;
    }

    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    public PstnCallLogRow withEndDateTime(OffsetDateTime endDateTime) {
        PstnCallLogRow _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.pstnCallLogRow");
        _x.endDateTime = endDateTime;
        return _x;
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public PstnCallLogRow withId(String id) {
        PstnCallLogRow _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.pstnCallLogRow");
        _x.id = id;
        return _x;
    }

    @Property(name="inventoryType")
    @JsonIgnore
    public Optional<String> getInventoryType() {
        return Optional.ofNullable(inventoryType);
    }

    public PstnCallLogRow withInventoryType(String inventoryType) {
        PstnCallLogRow _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.pstnCallLogRow");
        _x.inventoryType = inventoryType;
        return _x;
    }

    @Property(name="licenseCapability")
    @JsonIgnore
    public Optional<String> getLicenseCapability() {
        return Optional.ofNullable(licenseCapability);
    }

    public PstnCallLogRow withLicenseCapability(String licenseCapability) {
        PstnCallLogRow _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.pstnCallLogRow");
        _x.licenseCapability = licenseCapability;
        return _x;
    }

    @Property(name="operator")
    @JsonIgnore
    public Optional<String> getOperator() {
        return Optional.ofNullable(operator);
    }

    public PstnCallLogRow withOperator(String operator) {
        PstnCallLogRow _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.pstnCallLogRow");
        _x.operator = operator;
        return _x;
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public PstnCallLogRow withStartDateTime(OffsetDateTime startDateTime) {
        PstnCallLogRow _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.pstnCallLogRow");
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Property(name="tenantCountryCode")
    @JsonIgnore
    public Optional<String> getTenantCountryCode() {
        return Optional.ofNullable(tenantCountryCode);
    }

    public PstnCallLogRow withTenantCountryCode(String tenantCountryCode) {
        PstnCallLogRow _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.pstnCallLogRow");
        _x.tenantCountryCode = tenantCountryCode;
        return _x;
    }

    @Property(name="usageCountryCode")
    @JsonIgnore
    public Optional<String> getUsageCountryCode() {
        return Optional.ofNullable(usageCountryCode);
    }

    public PstnCallLogRow withUsageCountryCode(String usageCountryCode) {
        PstnCallLogRow _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.pstnCallLogRow");
        _x.usageCountryCode = usageCountryCode;
        return _x;
    }

    @Property(name="userDisplayName")
    @JsonIgnore
    public Optional<String> getUserDisplayName() {
        return Optional.ofNullable(userDisplayName);
    }

    public PstnCallLogRow withUserDisplayName(String userDisplayName) {
        PstnCallLogRow _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.pstnCallLogRow");
        _x.userDisplayName = userDisplayName;
        return _x;
    }

    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    public PstnCallLogRow withUserId(String userId) {
        PstnCallLogRow _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.pstnCallLogRow");
        _x.userId = userId;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public PstnCallLogRow withUserPrincipalName(String userPrincipalName) {
        PstnCallLogRow _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.pstnCallLogRow");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    public PstnCallLogRow withUnmappedField(String name, Object value) {
        PstnCallLogRow _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private PstnCallDurationSource callDurationSource;
        private String calleeNumber;
        private String callerNumber;
        private String callId;
        private String callType;
        private BigDecimal charge;
        private String conferenceId;
        private BigDecimal connectionCharge;
        private String currency;
        private String destinationContext;
        private String destinationName;
        private Integer duration;
        private OffsetDateTime endDateTime;
        private String id;
        private String inventoryType;
        private String licenseCapability;
        private String operator;
        private OffsetDateTime startDateTime;
        private String tenantCountryCode;
        private String usageCountryCode;
        private String userDisplayName;
        private String userId;
        private String userPrincipalName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder callDurationSource(PstnCallDurationSource callDurationSource) {
            this.callDurationSource = callDurationSource;
            this.changedFields = changedFields.add("callDurationSource");
            return this;
        }

        public Builder calleeNumber(String calleeNumber) {
            this.calleeNumber = calleeNumber;
            this.changedFields = changedFields.add("calleeNumber");
            return this;
        }

        public Builder callerNumber(String callerNumber) {
            this.callerNumber = callerNumber;
            this.changedFields = changedFields.add("callerNumber");
            return this;
        }

        public Builder callId(String callId) {
            this.callId = callId;
            this.changedFields = changedFields.add("callId");
            return this;
        }

        public Builder callType(String callType) {
            this.callType = callType;
            this.changedFields = changedFields.add("callType");
            return this;
        }

        public Builder charge(BigDecimal charge) {
            this.charge = charge;
            this.changedFields = changedFields.add("charge");
            return this;
        }

        public Builder conferenceId(String conferenceId) {
            this.conferenceId = conferenceId;
            this.changedFields = changedFields.add("conferenceId");
            return this;
        }

        public Builder connectionCharge(BigDecimal connectionCharge) {
            this.connectionCharge = connectionCharge;
            this.changedFields = changedFields.add("connectionCharge");
            return this;
        }

        public Builder currency(String currency) {
            this.currency = currency;
            this.changedFields = changedFields.add("currency");
            return this;
        }

        public Builder destinationContext(String destinationContext) {
            this.destinationContext = destinationContext;
            this.changedFields = changedFields.add("destinationContext");
            return this;
        }

        public Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            this.changedFields = changedFields.add("destinationName");
            return this;
        }

        public Builder duration(Integer duration) {
            this.duration = duration;
            this.changedFields = changedFields.add("duration");
            return this;
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder inventoryType(String inventoryType) {
            this.inventoryType = inventoryType;
            this.changedFields = changedFields.add("inventoryType");
            return this;
        }

        public Builder licenseCapability(String licenseCapability) {
            this.licenseCapability = licenseCapability;
            this.changedFields = changedFields.add("licenseCapability");
            return this;
        }

        public Builder operator(String operator) {
            this.operator = operator;
            this.changedFields = changedFields.add("operator");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder tenantCountryCode(String tenantCountryCode) {
            this.tenantCountryCode = tenantCountryCode;
            this.changedFields = changedFields.add("tenantCountryCode");
            return this;
        }

        public Builder usageCountryCode(String usageCountryCode) {
            this.usageCountryCode = usageCountryCode;
            this.changedFields = changedFields.add("usageCountryCode");
            return this;
        }

        public Builder userDisplayName(String userDisplayName) {
            this.userDisplayName = userDisplayName;
            this.changedFields = changedFields.add("userDisplayName");
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public PstnCallLogRow build() {
            PstnCallLogRow _x = new PstnCallLogRow();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.callRecords.pstnCallLogRow";
            _x.callDurationSource = callDurationSource;
            _x.calleeNumber = calleeNumber;
            _x.callerNumber = callerNumber;
            _x.callId = callId;
            _x.callType = callType;
            _x.charge = charge;
            _x.conferenceId = conferenceId;
            _x.connectionCharge = connectionCharge;
            _x.currency = currency;
            _x.destinationContext = destinationContext;
            _x.destinationName = destinationName;
            _x.duration = duration;
            _x.endDateTime = endDateTime;
            _x.id = id;
            _x.inventoryType = inventoryType;
            _x.licenseCapability = licenseCapability;
            _x.operator = operator;
            _x.startDateTime = startDateTime;
            _x.tenantCountryCode = tenantCountryCode;
            _x.usageCountryCode = usageCountryCode;
            _x.userDisplayName = userDisplayName;
            _x.userId = userId;
            _x.userPrincipalName = userPrincipalName;
            return _x;
        }
    }

    private PstnCallLogRow _copy() {
        PstnCallLogRow _x = new PstnCallLogRow();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.callDurationSource = callDurationSource;
        _x.calleeNumber = calleeNumber;
        _x.callerNumber = callerNumber;
        _x.callId = callId;
        _x.callType = callType;
        _x.charge = charge;
        _x.conferenceId = conferenceId;
        _x.connectionCharge = connectionCharge;
        _x.currency = currency;
        _x.destinationContext = destinationContext;
        _x.destinationName = destinationName;
        _x.duration = duration;
        _x.endDateTime = endDateTime;
        _x.id = id;
        _x.inventoryType = inventoryType;
        _x.licenseCapability = licenseCapability;
        _x.operator = operator;
        _x.startDateTime = startDateTime;
        _x.tenantCountryCode = tenantCountryCode;
        _x.usageCountryCode = usageCountryCode;
        _x.userDisplayName = userDisplayName;
        _x.userId = userId;
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PstnCallLogRow[");
        b.append("callDurationSource=");
        b.append(this.callDurationSource);
        b.append(", ");
        b.append("calleeNumber=");
        b.append(this.calleeNumber);
        b.append(", ");
        b.append("callerNumber=");
        b.append(this.callerNumber);
        b.append(", ");
        b.append("callId=");
        b.append(this.callId);
        b.append(", ");
        b.append("callType=");
        b.append(this.callType);
        b.append(", ");
        b.append("charge=");
        b.append(this.charge);
        b.append(", ");
        b.append("conferenceId=");
        b.append(this.conferenceId);
        b.append(", ");
        b.append("connectionCharge=");
        b.append(this.connectionCharge);
        b.append(", ");
        b.append("currency=");
        b.append(this.currency);
        b.append(", ");
        b.append("destinationContext=");
        b.append(this.destinationContext);
        b.append(", ");
        b.append("destinationName=");
        b.append(this.destinationName);
        b.append(", ");
        b.append("duration=");
        b.append(this.duration);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("inventoryType=");
        b.append(this.inventoryType);
        b.append(", ");
        b.append("licenseCapability=");
        b.append(this.licenseCapability);
        b.append(", ");
        b.append("operator=");
        b.append(this.operator);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("tenantCountryCode=");
        b.append(this.tenantCountryCode);
        b.append(", ");
        b.append("usageCountryCode=");
        b.append(this.usageCountryCode);
        b.append(", ");
        b.append("userDisplayName=");
        b.append(this.userDisplayName);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
