package odata.msgraph.client.beta.callRecords.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "calleeDevice", 
    "calleeNetwork", 
    "callerDevice", 
    "callerNetwork", 
    "label", 
    "streams"})
@JsonInclude(Include.NON_NULL)
public class Media implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("calleeDevice")
    protected DeviceInfo calleeDevice;

    @JsonProperty("calleeNetwork")
    protected NetworkInfo calleeNetwork;

    @JsonProperty("callerDevice")
    protected DeviceInfo callerDevice;

    @JsonProperty("callerNetwork")
    protected NetworkInfo callerNetwork;

    @JsonProperty("label")
    protected String label;

    @JsonProperty("streams")
    protected List<MediaStream> streams;

    @JsonProperty("streams@nextLink")
    protected String streamsNextLink;

    protected Media() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.callRecords.media";
    }

    @Property(name="calleeDevice")
    @JsonIgnore
    public Optional<DeviceInfo> getCalleeDevice() {
        return Optional.ofNullable(calleeDevice);
    }

    public Media withCalleeDevice(DeviceInfo calleeDevice) {
        Media _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.media");
        _x.calleeDevice = calleeDevice;
        return _x;
    }

    @Property(name="calleeNetwork")
    @JsonIgnore
    public Optional<NetworkInfo> getCalleeNetwork() {
        return Optional.ofNullable(calleeNetwork);
    }

    public Media withCalleeNetwork(NetworkInfo calleeNetwork) {
        Media _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.media");
        _x.calleeNetwork = calleeNetwork;
        return _x;
    }

    @Property(name="callerDevice")
    @JsonIgnore
    public Optional<DeviceInfo> getCallerDevice() {
        return Optional.ofNullable(callerDevice);
    }

    public Media withCallerDevice(DeviceInfo callerDevice) {
        Media _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.media");
        _x.callerDevice = callerDevice;
        return _x;
    }

    @Property(name="callerNetwork")
    @JsonIgnore
    public Optional<NetworkInfo> getCallerNetwork() {
        return Optional.ofNullable(callerNetwork);
    }

    public Media withCallerNetwork(NetworkInfo callerNetwork) {
        Media _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.media");
        _x.callerNetwork = callerNetwork;
        return _x;
    }

    @Property(name="label")
    @JsonIgnore
    public Optional<String> getLabel() {
        return Optional.ofNullable(label);
    }

    public Media withLabel(String label) {
        Media _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.media");
        _x.label = label;
        return _x;
    }

    @Property(name="streams")
    @JsonIgnore
    public CollectionPage<MediaStream> getStreams() {
        return new CollectionPage<MediaStream>(contextPath, MediaStream.class, this.streams, Optional.ofNullable(streamsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="streams")
    @JsonIgnore
    public CollectionPage<MediaStream> getStreams(HttpRequestOptions options) {
        return new CollectionPage<MediaStream>(contextPath, MediaStream.class, this.streams, Optional.ofNullable(streamsNextLink), Collections.emptyList(), options);
    }

    public Media withUnmappedField(String name, Object value) {
        Media _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DeviceInfo calleeDevice;
        private NetworkInfo calleeNetwork;
        private DeviceInfo callerDevice;
        private NetworkInfo callerNetwork;
        private String label;
        private List<MediaStream> streams;
        private String streamsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder calleeDevice(DeviceInfo calleeDevice) {
            this.calleeDevice = calleeDevice;
            this.changedFields = changedFields.add("calleeDevice");
            return this;
        }

        public Builder calleeNetwork(NetworkInfo calleeNetwork) {
            this.calleeNetwork = calleeNetwork;
            this.changedFields = changedFields.add("calleeNetwork");
            return this;
        }

        public Builder callerDevice(DeviceInfo callerDevice) {
            this.callerDevice = callerDevice;
            this.changedFields = changedFields.add("callerDevice");
            return this;
        }

        public Builder callerNetwork(NetworkInfo callerNetwork) {
            this.callerNetwork = callerNetwork;
            this.changedFields = changedFields.add("callerNetwork");
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            this.changedFields = changedFields.add("label");
            return this;
        }

        public Builder streams(List<MediaStream> streams) {
            this.streams = streams;
            this.changedFields = changedFields.add("streams");
            return this;
        }

        public Builder streams(MediaStream... streams) {
            return streams(Arrays.asList(streams));
        }

        public Builder streamsNextLink(String streamsNextLink) {
            this.streamsNextLink = streamsNextLink;
            this.changedFields = changedFields.add("streams");
            return this;
        }

        public Media build() {
            Media _x = new Media();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.callRecords.media";
            _x.calleeDevice = calleeDevice;
            _x.calleeNetwork = calleeNetwork;
            _x.callerDevice = callerDevice;
            _x.callerNetwork = callerNetwork;
            _x.label = label;
            _x.streams = streams;
            _x.streamsNextLink = streamsNextLink;
            return _x;
        }
    }

    private Media _copy() {
        Media _x = new Media();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.calleeDevice = calleeDevice;
        _x.calleeNetwork = calleeNetwork;
        _x.callerDevice = callerDevice;
        _x.callerNetwork = callerNetwork;
        _x.label = label;
        _x.streams = streams;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Media[");
        b.append("calleeDevice=");
        b.append(this.calleeDevice);
        b.append(", ");
        b.append("calleeNetwork=");
        b.append(this.calleeNetwork);
        b.append(", ");
        b.append("callerDevice=");
        b.append(this.callerDevice);
        b.append(", ");
        b.append("callerNetwork=");
        b.append(this.callerNetwork);
        b.append(", ");
        b.append("label=");
        b.append(this.label);
        b.append(", ");
        b.append("streams=");
        b.append(this.streams);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
