package odata.msgraph.client.beta.callRecords.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.callRecords.enums.ClientPlatform;
import odata.msgraph.client.beta.callRecords.enums.ProductFamily;

@JsonPropertyOrder({
    "@odata.type", 
    "platform", 
    "productFamily"})
@JsonInclude(Include.NON_NULL)
public class ClientUserAgent extends UserAgent implements ODataType {

    @JsonProperty("platform")
    protected ClientPlatform platform;

    @JsonProperty("productFamily")
    protected ProductFamily productFamily;

    protected ClientUserAgent() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.callRecords.clientUserAgent";
    }

    @Property(name="platform")
    @JsonIgnore
    public Optional<ClientPlatform> getPlatform() {
        return Optional.ofNullable(platform);
    }

    public ClientUserAgent withPlatform(ClientPlatform platform) {
        ClientUserAgent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.clientUserAgent");
        _x.platform = platform;
        return _x;
    }

    @Property(name="productFamily")
    @JsonIgnore
    public Optional<ProductFamily> getProductFamily() {
        return Optional.ofNullable(productFamily);
    }

    public ClientUserAgent withProductFamily(ProductFamily productFamily) {
        ClientUserAgent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.clientUserAgent");
        _x.productFamily = productFamily;
        return _x;
    }

    public ClientUserAgent withUnmappedField(String name, Object value) {
        ClientUserAgent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderClientUserAgent() {
        return new Builder();
    }

    public static final class Builder {
        private String applicationVersion;
        private String headerValue;
        private ClientPlatform platform;
        private ProductFamily productFamily;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder applicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
            this.changedFields = changedFields.add("applicationVersion");
            return this;
        }

        public Builder headerValue(String headerValue) {
            this.headerValue = headerValue;
            this.changedFields = changedFields.add("headerValue");
            return this;
        }

        public Builder platform(ClientPlatform platform) {
            this.platform = platform;
            this.changedFields = changedFields.add("platform");
            return this;
        }

        public Builder productFamily(ProductFamily productFamily) {
            this.productFamily = productFamily;
            this.changedFields = changedFields.add("productFamily");
            return this;
        }

        public ClientUserAgent build() {
            ClientUserAgent _x = new ClientUserAgent();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.callRecords.clientUserAgent";
            _x.applicationVersion = applicationVersion;
            _x.headerValue = headerValue;
            _x.platform = platform;
            _x.productFamily = productFamily;
            return _x;
        }
    }

    private ClientUserAgent _copy() {
        ClientUserAgent _x = new ClientUserAgent();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.applicationVersion = applicationVersion;
        _x.headerValue = headerValue;
        _x.platform = platform;
        _x.productFamily = productFamily;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ClientUserAgent[");
        b.append("applicationVersion=");
        b.append(this.applicationVersion);
        b.append(", ");
        b.append("headerValue=");
        b.append(this.headerValue);
        b.append(", ");
        b.append("platform=");
        b.append(this.platform);
        b.append(", ");
        b.append("productFamily=");
        b.append(this.productFamily);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
