package microsoft.graph.security.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ActionSource implements Enum {

    @JsonProperty("manual")
    MANUAL("manual", "0"),

    @JsonProperty("automatic")
    AUTOMATIC("automatic", "1"),

    @JsonProperty("recommended")
    RECOMMENDED("recommended", "2"),

    @JsonProperty("default")
    DEFAULT("default", "3");

    private final String name;
    private final String value;

    private ActionSource(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
