package microsoft.graph.security.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import microsoft.graph.security.enums.WatermarkLayout;

@JsonPropertyOrder({
    "@odata.type", 
    "fontColor", 
    "fontName", 
    "fontSize", 
    "layout", 
    "text", 
    "uiElementName"})
@JsonInclude(Include.NON_NULL)
public class AddWatermarkAction extends InformationProtectionAction implements ODataType {

    @JsonProperty("fontColor")
    protected String fontColor;

    @JsonProperty("fontName")
    protected String fontName;

    @JsonProperty("fontSize")
    protected Integer fontSize;

    @JsonProperty("layout")
    protected WatermarkLayout layout;

    @JsonProperty("text")
    protected String text;

    @JsonProperty("uiElementName")
    protected String uiElementName;

    protected AddWatermarkAction() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.security.addWatermarkAction";
    }

    @Property(name="fontColor")
    @JsonIgnore
    public Optional<String> getFontColor() {
        return Optional.ofNullable(fontColor);
    }

    public AddWatermarkAction withFontColor(String fontColor) {
        AddWatermarkAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.addWatermarkAction");
        _x.fontColor = fontColor;
        return _x;
    }

    @Property(name="fontName")
    @JsonIgnore
    public Optional<String> getFontName() {
        return Optional.ofNullable(fontName);
    }

    public AddWatermarkAction withFontName(String fontName) {
        AddWatermarkAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.addWatermarkAction");
        _x.fontName = fontName;
        return _x;
    }

    @Property(name="fontSize")
    @JsonIgnore
    public Optional<Integer> getFontSize() {
        return Optional.ofNullable(fontSize);
    }

    public AddWatermarkAction withFontSize(Integer fontSize) {
        AddWatermarkAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.addWatermarkAction");
        _x.fontSize = fontSize;
        return _x;
    }

    @Property(name="layout")
    @JsonIgnore
    public Optional<WatermarkLayout> getLayout() {
        return Optional.ofNullable(layout);
    }

    public AddWatermarkAction withLayout(WatermarkLayout layout) {
        AddWatermarkAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.addWatermarkAction");
        _x.layout = layout;
        return _x;
    }

    @Property(name="text")
    @JsonIgnore
    public Optional<String> getText() {
        return Optional.ofNullable(text);
    }

    public AddWatermarkAction withText(String text) {
        AddWatermarkAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.addWatermarkAction");
        _x.text = text;
        return _x;
    }

    @Property(name="uiElementName")
    @JsonIgnore
    public Optional<String> getUiElementName() {
        return Optional.ofNullable(uiElementName);
    }

    public AddWatermarkAction withUiElementName(String uiElementName) {
        AddWatermarkAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.addWatermarkAction");
        _x.uiElementName = uiElementName;
        return _x;
    }

    public AddWatermarkAction withUnmappedField(String name, Object value) {
        AddWatermarkAction _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAddWatermarkAction() {
        return new Builder();
    }

    public static final class Builder {
        private String fontColor;
        private String fontName;
        private Integer fontSize;
        private WatermarkLayout layout;
        private String text;
        private String uiElementName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder fontColor(String fontColor) {
            this.fontColor = fontColor;
            this.changedFields = changedFields.add("fontColor");
            return this;
        }

        public Builder fontName(String fontName) {
            this.fontName = fontName;
            this.changedFields = changedFields.add("fontName");
            return this;
        }

        public Builder fontSize(Integer fontSize) {
            this.fontSize = fontSize;
            this.changedFields = changedFields.add("fontSize");
            return this;
        }

        public Builder layout(WatermarkLayout layout) {
            this.layout = layout;
            this.changedFields = changedFields.add("layout");
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            this.changedFields = changedFields.add("text");
            return this;
        }

        public Builder uiElementName(String uiElementName) {
            this.uiElementName = uiElementName;
            this.changedFields = changedFields.add("uiElementName");
            return this;
        }

        public AddWatermarkAction build() {
            AddWatermarkAction _x = new AddWatermarkAction();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.security.addWatermarkAction";
            _x.fontColor = fontColor;
            _x.fontName = fontName;
            _x.fontSize = fontSize;
            _x.layout = layout;
            _x.text = text;
            _x.uiElementName = uiElementName;
            return _x;
        }
    }

    private AddWatermarkAction _copy() {
        AddWatermarkAction _x = new AddWatermarkAction();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.fontColor = fontColor;
        _x.fontName = fontName;
        _x.fontSize = fontSize;
        _x.layout = layout;
        _x.text = text;
        _x.uiElementName = uiElementName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AddWatermarkAction[");
        b.append("fontColor=");
        b.append(this.fontColor);
        b.append(", ");
        b.append("fontName=");
        b.append(this.fontName);
        b.append(", ");
        b.append("fontSize=");
        b.append(this.fontSize);
        b.append(", ");
        b.append("layout=");
        b.append(this.layout);
        b.append(", ");
        b.append("text=");
        b.append(this.text);
        b.append(", ");
        b.append("uiElementName=");
        b.append(this.uiElementName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
