package microsoft.graph.search.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AnswerState implements Enum {

    @JsonProperty("published")
    PUBLISHED("published", "0"),

    @JsonProperty("draft")
    DRAFT("draft", "1"),

    @JsonProperty("excluded")
    EXCLUDED("excluded", "2"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "3");

    private final String name;
    private final String value;

    private AnswerState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
